/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe;

import dev.failsafe.Policy;
import dev.failsafe.TimeoutBuilder;
import dev.failsafe.TimeoutConfig;
import dev.failsafe.internal.TimeoutImpl;
import dev.failsafe.internal.util.Assert;
import java.time.Duration;

public interface Timeout<R>
extends Policy<R> {
    public static <R> TimeoutBuilder<R> builder(Duration timeout) {
        Assert.notNull(timeout, "timeout");
        Assert.isTrue(timeout.toNanos() > 0L, "timeout must be > 0", new Object[0]);
        return new TimeoutBuilder(timeout);
    }

    public static <R> Timeout<R> of(Duration timeout) {
        return new TimeoutImpl(new TimeoutConfig(timeout, false));
    }

    @Override
    public TimeoutConfig<R> getConfig();
}

