/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe;

import dev.failsafe.DelayablePolicyBuilder;
import dev.failsafe.PolicyListeners;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyConfig;
import dev.failsafe.event.EventListener;
import dev.failsafe.event.ExecutionAttemptedEvent;
import dev.failsafe.event.ExecutionCompletedEvent;
import dev.failsafe.event.ExecutionScheduledEvent;
import dev.failsafe.internal.RetryPolicyImpl;
import dev.failsafe.internal.util.Assert;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class RetryPolicyBuilder<R>
extends DelayablePolicyBuilder<RetryPolicyBuilder<R>, RetryPolicyConfig<R>, R>
implements PolicyListeners<RetryPolicyBuilder<R>, R> {
    private static final int DEFAULT_MAX_RETRIES = 2;

    RetryPolicyBuilder() {
        super(new RetryPolicyConfig());
        ((RetryPolicyConfig)this.config).delay = Duration.ZERO;
        ((RetryPolicyConfig)this.config).maxRetries = 2;
        ((RetryPolicyConfig)this.config).abortConditions = new ArrayList();
    }

    public RetryPolicy<R> build() {
        return new RetryPolicyImpl(new RetryPolicyConfig((RetryPolicyConfig)this.config));
    }

    public RetryPolicyBuilder<R> abortIf(BiPredicate<R, ? extends Throwable> completionPredicate) {
        Assert.notNull(completionPredicate, "completionPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(completionPredicate);
        return this;
    }

    public RetryPolicyBuilder<R> abortIf(Predicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.abortOn(Arrays.asList(failure));
    }

    @SafeVarargs
    public final RetryPolicyBuilder<R> abortOn(Class<? extends Throwable> ... failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(failures.length > 0, "Failures cannot be empty", new Object[0]);
        return this.abortOn(Arrays.asList(failures));
    }

    public RetryPolicyBuilder<R> abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(failures));
        return this;
    }

    public RetryPolicyBuilder<R> abortOn(Predicate<? extends Throwable> failurePredicate) {
        Assert.notNull(failurePredicate, "failurePredicate");
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.failurePredicateFor(failurePredicate));
        return this;
    }

    public RetryPolicyBuilder<R> abortWhen(R result) {
        ((RetryPolicyConfig)this.config).abortConditions.add(RetryPolicyBuilder.resultPredicateFor(result));
        return this;
    }

    public RetryPolicyBuilder<R> onAbort(EventListener<ExecutionCompletedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).abortListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onFailedAttempt(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).failedAttemptListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetriesExceeded(EventListener<ExecutionCompletedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retriesExceededListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetry(EventListener<ExecutionAttemptedEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retryListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> onRetryScheduled(EventListener<ExecutionScheduledEvent<R>> listener) {
        ((RetryPolicyConfig)this.config).retryScheduledListener = Assert.notNull(listener, "listener");
        return this;
    }

    public RetryPolicyBuilder<R> withBackoff(Duration delay, Duration maxDelay) {
        return this.withBackoff(delay, maxDelay, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit) {
        return this.withBackoff(delay, maxDelay, chronoUnit, 2.0);
    }

    public RetryPolicyBuilder<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit, double delayFactor) {
        return this.withBackoff(Duration.of(delay, chronoUnit), Duration.of(maxDelay, chronoUnit), delayFactor);
    }

    public RetryPolicyBuilder<R> withBackoff(Duration delay, Duration maxDelay, double delayFactor) {
        Assert.notNull(delay, "delay");
        Assert.notNull(maxDelay, "maxDelay");
        Assert.isTrue(!delay.isNegative() && !delay.isZero(), "The delay must be greater than 0", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.isTrue(delay.toNanos() < maxDelay.toNanos(), "delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayFactor > 1.0, "delayFactor must be greater than 1", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delay == null || ((RetryPolicyConfig)this.config).delay.equals(Duration.ZERO), "Delays have already been set", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delayMin == null, "Random delays have already been set", new Object[0]);
        ((RetryPolicyConfig)this.config).delay = delay;
        ((RetryPolicyConfig)this.config).maxDelay = maxDelay;
        ((RetryPolicyConfig)this.config).delayFactor = delayFactor;
        return this;
    }

    @Override
    public RetryPolicyBuilder<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delay.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delayMin == null, "Random delays have already been set", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDelay == null, "Backoff delays have already been set", new Object[0]);
        return (RetryPolicyBuilder)super.withDelay(delay);
    }

    public RetryPolicyBuilder<R> withDelay(long delayMin, long delayMax, ChronoUnit chronoUnit) {
        return this.withDelay(Duration.of(delayMin, chronoUnit), Duration.of(delayMax, chronoUnit));
    }

    public RetryPolicyBuilder<R> withDelay(Duration delayMin, Duration delayMax) {
        Assert.notNull(delayMin, "delayMin");
        Assert.notNull(delayMax, "delayMax");
        Assert.isTrue(!delayMin.isNegative() && !delayMin.isZero(), "delayMin must be greater than 0", new Object[0]);
        Assert.isTrue(!delayMax.isNegative() && !delayMax.isZero(), "delayMax must be greater than 0", new Object[0]);
        Assert.isTrue(delayMin.toNanos() < delayMax.toNanos(), "delayMin must be less than delayMax", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDuration == null || delayMax.toNanos() < ((RetryPolicyConfig)this.config).maxDuration.toNanos(), "delayMax must be less than the maxDuration", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).delay == null || ((RetryPolicyConfig)this.config).delay.equals(Duration.ZERO), "Delays have already been set", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).maxDelay == null, "Backoff delays have already been set", new Object[0]);
        ((RetryPolicyConfig)this.config).delayMin = delayMin;
        ((RetryPolicyConfig)this.config).delayMax = delayMax;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(double jitterFactor) {
        Assert.isTrue(jitterFactor >= 0.0 && jitterFactor <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitter == null, "withJitter(Duration) has already been called", new Object[0]);
        ((RetryPolicyConfig)this.config).jitterFactor = jitterFactor;
        return this;
    }

    public RetryPolicyBuilder<R> withJitter(Duration jitter) {
        Assert.notNull(jitter, "jitter");
        Assert.isTrue(jitter.toNanos() > 0L, "jitter must be > 0", new Object[0]);
        Assert.state(((RetryPolicyConfig)this.config).jitterFactor == 0.0, "withJitter(double) has already been called", new Object[0]);
        Assert.state(jitter.toNanos() <= (((RetryPolicyConfig)this.config).delayMin != null ? ((RetryPolicyConfig)this.config).delayMin.toNanos() : ((RetryPolicyConfig)this.config).delay.toNanos()), "jitter must be less than the minimum configured delay", new Object[0]);
        ((RetryPolicyConfig)this.config).jitter = jitter;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxAttempts(int maxAttempts) {
        Assert.isTrue(maxAttempts != 0, "maxAttempts cannot be 0", new Object[0]);
        Assert.isTrue(maxAttempts >= -1, "maxAttempts cannot be less than -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxAttempts == -1 ? -1 : maxAttempts - 1;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, "maxDuration");
        Assert.state(maxDuration.toNanos() > ((RetryPolicyConfig)this.config).delay.toNanos(), "maxDuration must be greater than the delay", new Object[0]);
        ((RetryPolicyConfig)this.config).maxDuration = maxDuration;
        return this;
    }

    public RetryPolicyBuilder<R> withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be greater than or equal to -1", new Object[0]);
        ((RetryPolicyConfig)this.config).maxRetries = maxRetries;
        return this;
    }
}

