/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

public class MessageIdSupplier {
    protected static final int MESSAGE_ID_LENGTH = 8;
    protected static final int LONG_LENGTH = 8;
    private byte[] machinePart;

    public MessageIdSupplier() {
        try {
            this.machinePart = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException e) {
            this.machinePart = new byte[8];
            new Random().nextBytes(this.machinePart);
        }
    }

    protected byte[] getMachinePart() {
        return Arrays.copyOf(this.machinePart, this.machinePart.length);
    }

    protected void setMachinePart(byte[] machinePart) {
        this.machinePart = Arrays.copyOf(machinePart, machinePart.length);
    }

    public byte[] get() {
        return Arrays.copyOf(this.buildMessageId(), 8);
    }

    protected byte[] buildMessageId() {
        ByteBuffer bb = ByteBuffer.allocate(this.machinePart.length + 8);
        bb.put(this.machinePart);
        bb.putLong(System.nanoTime());
        bb.flip();
        return MessageIdSupplier.md5(bb.array());
    }

    protected static byte[] md5(byte[] data) {
        try {
            return MessageDigest.getInstance("MD5").digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

