/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.visitor;

import de.fau.cs.osr.utils.StringTools;
import de.fau.cs.osr.utils.visitor.Baton;
import de.fau.cs.osr.utils.visitor.IncompatibleVisitorStackDefinition;
import de.fau.cs.osr.utils.visitor.MultipleVisitMethodsMatchException;
import de.fau.cs.osr.utils.visitor.StackedVisitorInterface;
import de.fau.cs.osr.utils.visitor.VisitNotFoundException;
import de.fau.cs.osr.utils.visitor.VisitingException;
import de.fau.cs.osr.utils.visitor.VisitorException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class VisitorStackController<T> {
    public static boolean DEBUG = false;
    private static final String VISIT_METHOD_NAME = "visit";
    private static final Class<?> BATON_CLASS = Baton.class;
    private static final Map<String, Cache> CACHES = new HashMap<String, Cache>();
    private final Cache cache;
    private StackedVisitorInterface<T>[] visitorStack;
    private StackedVisitorInterface<T>[] enabledVisitors;
    private Baton baton;

    public static <S> Cache getOrRegisterCache(String name, List<? extends StackedVisitorInterface<S>> visitorStack) throws IncompatibleVisitorStackDefinition {
        return VisitorStackController.getOrRegisterCache(name, visitorStack, 0.6f, 256, 384);
    }

    public static synchronized <S> Cache getOrRegisterCache(String name, List<? extends StackedVisitorInterface<S>> visitorStack, float loadFactor, int lowerCapacity, int upperCapacity) throws IncompatibleVisitorStackDefinition {
        Cache cache = CACHES.get(name);
        if (cache == null) {
            cache = new Cache(visitorStack, loadFactor, lowerCapacity, upperCapacity);
            CACHES.put(name, cache);
        } else {
            cache.verifyDefinition(visitorStack);
        }
        return cache;
    }

    public static synchronized boolean dropCache(String name) {
        return CACHES.remove(name) != null;
    }

    protected VisitorStackController(String cacheName, List<? extends StackedVisitorInterface<T>> visitorStack) throws IncompatibleVisitorStackDefinition {
        this(VisitorStackController.getOrRegisterCache(cacheName, visitorStack), visitorStack);
    }

    protected VisitorStackController(Cache cache, List<? extends StackedVisitorInterface<T>> visitorStack) throws IncompatibleVisitorStackDefinition {
        for (StackedVisitorInterface<StackedVisitorInterface> stackedVisitorInterface : visitorStack) {
            if (stackedVisitorInterface != null) continue;
            throw new NullPointerException("Visitor stack contains <null>s");
        }
        int tmp = new HashSet<StackedVisitorInterface<StackedVisitorInterface>>(visitorStack).size();
        if (tmp != visitorStack.size()) {
            throw new IllegalArgumentException("Visitor stack contains duplicates!");
        }
        cache.verifyDefinition(visitorStack);
        StackedVisitorInterface[] stackedVisitorInterfaceArray = new StackedVisitorInterface[visitorStack.size()];
        this.cache = cache;
        this.visitorStack = visitorStack.toArray(stackedVisitorInterfaceArray);
        this.enabledVisitors = Arrays.copyOf(this.visitorStack, this.visitorStack.length);
    }

    public int indexOfVisitor(StackedVisitorInterface<T> visitor) {
        for (int i = 0; i < this.visitorStack.length; ++i) {
            if (this.visitorStack[i] != visitor) continue;
            return i;
        }
        return -1;
    }

    public void setVisitor(int i, StackedVisitorInterface<T> visitor) {
        if (visitor == null) {
            throw new NullPointerException();
        }
        if (this.cache.cacheDef.visitorStackDef[i] != visitor.getClass()) {
            throw new IllegalArgumentException("Replacement visitor's class does not matched the replaced visitor's class");
        }
        this.visitorStack[i] = visitor;
        if (this.isVisitorEnabled(i)) {
            this.enabledVisitors[i] = visitor;
        }
    }

    public StackedVisitorInterface<T> getVisitor(int i) {
        return this.visitorStack[i];
    }

    public StackedVisitorInterface<T> getEnabledVisitor(int i) {
        return this.enabledVisitors[i];
    }

    public boolean isVisitorEnabled(int i) {
        return this.getEnabledVisitor(i) != null;
    }

    public void disableVisitor(int i) {
        this.enabledVisitors[i] = null;
    }

    public void enableVisitor(int i) {
        this.enabledVisitors[i] = this.visitorStack[i];
    }

    public void setVisitorEnabled(int i, boolean enable) {
        if (enable) {
            this.enableVisitor(i);
        } else {
            this.disableVisitor(i);
        }
    }

    public Object go(T node) {
        T startNode = this.before(node);
        this.baton = new Baton();
        Object result = this.resolveAndVisit(startNode);
        return this.after(node, result);
    }

    protected T before(T node) {
        T transformed = node;
        for (int i = 0; i < this.visitorStack.length; ++i) {
            if (!this.isVisitorEnabled(i)) continue;
            T result = this.getEnabledVisitor(i).before(transformed);
            if (result == null) {
                this.disableVisitor(i);
                continue;
            }
            transformed = result;
        }
        return transformed;
    }

    protected Object after(T node, Object result) {
        for (int i = 0; i < this.visitorStack.length; ++i) {
            if (!this.isVisitorEnabled(i)) continue;
            result = this.getEnabledVisitor(i).after(node, result);
        }
        return result;
    }

    protected abstract Object visitNotFound(T var1);

    protected Object handleVisitingException(T node, Throwable cause) {
        throw new VisitingException(node, cause);
    }

    protected Object resolveAndVisit(T node) {
        Class<?> nClass = node.getClass();
        VisitChain key = new VisitChain(nClass);
        VisitChain visiChain = this.cache.get(key);
        try {
            if (visiChain == null) {
                visiChain = this.buildVisitChain(key);
                this.cache.put(visiChain);
            }
            if (visiChain.isEmpty()) {
                return this.visitNotFound(node);
            }
            return visiChain.invokeChain(this.baton, this, node);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof VisitingException) {
                throw (VisitingException)cause;
            }
            return this.handleVisitingException(node, cause);
        }
        catch (VisitingException e) {
            throw e;
        }
        catch (VisitNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new VisitorException(node, (Throwable)e);
        }
    }

    private VisitChain buildVisitChain(VisitChain key) throws SecurityException, NoSuchMethodException {
        Class<?> nClass = key.getNodeClass();
        ArrayList<Link> chain = new ArrayList<Link>();
        for (int i = 0; i < this.visitorStack.length; ++i) {
            Class<?> vClass = this.visitorStack[i].getClass();
            Method method = VisitorStackController.findVisit(vClass, nClass);
            if (method == null) continue;
            chain.add(new Link(i, method));
        }
        return new VisitChain(key, chain);
    }

    private static Method findVisit(final Class<?> vClass, final Class<?> nClass) throws NoSuchMethodException, SecurityException {
        Method method = null;
        ArrayList<Class> candidates = new ArrayList<Class>();
        ArrayDeque work = new ArrayDeque();
        work.add(nClass);
        while (!work.isEmpty()) {
            Class workItem = (Class)work.remove();
            try {
                method = vClass.getMethod(VISIT_METHOD_NAME, BATON_CLASS, workItem);
                candidates.add(workItem);
            }
            catch (NoSuchMethodException e) {
                Class superclass = workItem.getSuperclass();
                if (superclass != null) {
                    work.add(superclass);
                }
                for (Class<?> i : workItem.getInterfaces()) {
                    work.add(i);
                }
            }
        }
        if (!candidates.isEmpty()) {
            Collections.sort(candidates, new Comparator<Class<?>>(){

                @Override
                public int compare(Class<?> arg0, Class<?> arg1) {
                    if (arg0 == arg1) {
                        return 0;
                    }
                    if (arg0.isAssignableFrom(arg1)) {
                        return 1;
                    }
                    if (arg1.isAssignableFrom(arg0)) {
                        return -1;
                    }
                    throw new MultipleVisitMethodsMatchException(vClass, nClass, arg0, arg1);
                }
            });
            method = vClass.getMethod(VISIT_METHOD_NAME, BATON_CLASS, (Class)candidates.get(0));
        }
        return method;
    }

    private static final class CacheDefinition {
        private final int hash;
        private final Class<?>[] visitorStackDef;

        public CacheDefinition(List<? extends StackedVisitorInterface<?>> visitorStack) {
            Class[] visitorStackDef = new Class[visitorStack.size()];
            int hash = 0;
            int i = 0;
            for (StackedVisitorInterface<?> visitor : visitorStack) {
                visitorStackDef[i] = visitor.getClass();
                hash = hash * 13 + visitorStackDef[i].hashCode() * 17;
                ++i;
            }
            this.hash = hash;
            this.visitorStackDef = visitorStackDef;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheDefinition other = (CacheDefinition)obj;
            return Arrays.equals(this.visitorStackDef, other.visitorStackDef);
        }
    }

    public static final class Cache {
        private int lowerCapacity;
        private int upperCapacity;
        private final CacheDefinition cacheDef;
        private final ConcurrentHashMap<VisitChain, VisitChain> cache;

        private Cache(List<? extends StackedVisitorInterface<?>> visitorStack, float loadFactor, int lowerCapacity, int upperCapacity) {
            this.lowerCapacity = lowerCapacity;
            this.upperCapacity = upperCapacity;
            this.cacheDef = new CacheDefinition(visitorStack);
            this.cache = new ConcurrentHashMap(lowerCapacity, loadFactor);
        }

        private void verifyDefinition(List<? extends StackedVisitorInterface<?>> visitorStack) throws IncompatibleVisitorStackDefinition {
            if (!new CacheDefinition(visitorStack).equals(this.cacheDef)) {
                throw new IncompatibleVisitorStackDefinition("Incompatible visitor stack");
            }
        }

        private VisitChain get(VisitChain key) {
            return this.cache.get(key);
        }

        private synchronized VisitChain put(VisitChain chain) {
            VisitChain cached = this.cache.putIfAbsent(chain, chain);
            if (cached != null) {
                return cached;
            }
            chain.touch();
            if (this.cache.size() > this.upperCapacity) {
                this.sweepCache();
            }
            return chain;
        }

        private synchronized void sweepCache() {
            if (this.cache.size() <= this.upperCapacity) {
                return;
            }
            Object[] keys = new VisitChain[this.cache.size()];
            Enumeration<VisitChain> keysEnum = this.cache.keys();
            int i = 0;
            while (i < keys.length && keysEnum.hasMoreElements()) {
                keys[i++] = keysEnum.nextElement();
            }
            int length = i;
            Arrays.sort(keys, 0, length);
            int to = length - this.lowerCapacity;
            for (int j = 0; j < to; ++j) {
                this.cache.remove(keys[j]);
            }
        }
    }

    private static final class Link {
        private final int visitorIndex;
        private final Method method;

        public Link(int visitorIndex, Method method) {
            this.visitorIndex = visitorIndex;
            this.method = method;
        }
    }

    protected static final class VisitChain
    implements Comparable<VisitChain> {
        private static long useCounter = 0L;
        private long lastUse = -1L;
        private final Class<?> nodeClass;
        private final Link[] chain;

        public VisitChain(Class<?> nClass) {
            this.nodeClass = nClass;
            this.chain = null;
        }

        public VisitChain(VisitChain chain, List<Link> links) {
            this.nodeClass = chain.nodeClass;
            this.chain = links.toArray(new Link[links.size()]);
        }

        public Class<?> getNodeClass() {
            return this.nodeClass;
        }

        public boolean isEmpty() {
            return this.chain.length == 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object invokeChain(Baton baton, VisitorStackController controller, Object node) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.touch();
            if (this.isEmpty()) {
                throw new AssertionError();
            }
            Object visitNext = node;
            Object result = node;
            StackedVisitorInterface[] enabledVisitors = controller.enabledVisitors;
            int i = 0;
            while (true) {
                StackedVisitorInterface visitor;
                if ((visitor = enabledVisitors[this.chain[i].visitorIndex]) != null) {
                    if (DEBUG) {
                        System.err.println(this.chain[i].method + ": " + StringTools.crop(visitNext.toString(), 32));
                    }
                    result = this.chain[i].method.invoke((Object)visitor, baton, visitNext);
                    int batonCode = baton.queryAndResetCode();
                    if (result == null) return result;
                    switch (batonCode) {
                        case 1: {
                            if (!this.nodeClass.isInstance(result)) return result;
                            return this.redispatch(controller, result);
                        }
                        case 2: {
                            if (node.getClass() == result.getClass()) break;
                            if (!this.nodeClass.isInstance(result)) return result;
                            return this.redispatch(controller, result);
                        }
                        case 3: {
                            if (node.getClass().isInstance(result)) break;
                            if (!this.nodeClass.isInstance(result)) return result;
                            return this.redispatch(controller, result);
                        }
                        case 4: {
                            if (visitNext == result) break;
                            return result;
                        }
                        case 5: {
                            if (node.getClass() == result.getClass()) break;
                            return result;
                        }
                        case 6: {
                            if (node.getClass().isInstance(result)) break;
                            return result;
                        }
                        case 7: {
                            return result;
                        }
                        default: {
                            throw new AssertionError(batonCode);
                        }
                    }
                    if (++i >= this.chain.length) return result;
                    visitNext = result;
                    continue;
                }
                if (++i >= this.chain.length) return result;
            }
        }

        private Object redispatch(VisitorStackController controller, Object visitNext) {
            if (DEBUG) {
                System.err.println(StringTools.crop(visitNext.toString(), 32));
            }
            return controller.resolveAndVisit(visitNext);
        }

        public void touch() {
            this.lastUse = ++useCounter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.nodeClass.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            VisitChain other = (VisitChain)obj;
            return this.nodeClass == other.nodeClass;
        }

        @Override
        public int compareTo(VisitChain o) {
            return this.lastUse < o.lastUse ? -1 : 1;
        }
    }
}

