/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.visitor;

public final class Baton {
    static final int CODE_QUERIED = -2;
    static final int JUST_CREATED = -1;
    static final int CODE_SET_THRESHOLD = 0;
    static final int REDISPATCH = 1;
    static final int CONTINUE_SAME_TYPE_OR_REDISPATCH = 2;
    static final int CONTINUE_ASSIGNABLE_TYPE_OR_REDISPATCH = 3;
    static final int CONTINUE_SAME_REF = 4;
    static final int CONTINUE_SAME_TYPE = 5;
    static final int CONTINUE_ASSIGNABLE_TYPE = 6;
    static final int SKIP = 7;
    private int code = -1;

    Baton() {
    }

    final int queryAndResetCode() {
        this.checkCodeSet();
        int code = this.code;
        this.code = -2;
        return code;
    }

    protected final void checkCodeSet() {
        if (this.code <= 0) {
            throw new IllegalStateException("No code set: " + this.code);
        }
    }

    public final <T> T redispatch(T returnValue) {
        this.setCode(1);
        return returnValue;
    }

    public final <T> T continueIfSameTypeOrRedispatch(T returnValue) {
        this.setCode(2);
        return returnValue;
    }

    public final <T> T continueIfAssignableTypeOrRedispatch(T returnValue) {
        this.setCode(3);
        return returnValue;
    }

    public final <T> T continueIfSameRef(T returnValue) {
        this.setCode(4);
        return returnValue;
    }

    public final <T> T continueIfSameType(T returnValue) {
        this.setCode(5);
        return returnValue;
    }

    public final <T> T continueIfAssignableType(T returnValue) {
        this.setCode(6);
        return returnValue;
    }

    public final <T> T skip(T returnValue) {
        this.setCode(7);
        return returnValue;
    }

    protected final void setCode(int setCode) {
        if (this.code >= 0) {
            throw new IllegalStateException("No code set: " + this.code);
        }
        this.code = setCode;
    }
}

