/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class ReflectionUtils {
    private static final Map<Class<?>, Class<?>> lcToUcTypeMap = new HashMap();
    private static final Map<Class<?>, Class<?>> ucToLcTypeMap = new HashMap();
    private static final Map<Class<?>, String> typeToAbbrev = new HashMap();
    private static final Map<String, Class<?>> abbrevToType = new HashMap();

    public static Class<?> classForName(String className) throws ClassNotFoundException {
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("void")) {
            return Void.TYPE;
        }
        return Class.forName(className);
    }

    public static boolean isExtPrimitive(Class<?> clazz) {
        return ucToLcTypeMap.containsKey(clazz);
    }

    public static boolean isBasicDataType(Class<?> clazz) {
        return clazz.isPrimitive() || ReflectionUtils.isExtPrimitive(clazz) || clazz == String.class;
    }

    public static boolean isBasicDataType(String name) {
        return abbrevToType.containsKey(name);
    }

    public static Class<?> mapPrimitiveToUcType(Class<?> clazz) {
        Class<?> ucType = lcToUcTypeMap.get(clazz);
        if (ucType == null) {
            throw new IllegalArgumentException("Not a primitive data type!");
        }
        return ucType;
    }

    public static String abbreviateBasicDataTypeName(Class<?> clazz) {
        String abbrev = typeToAbbrev.get(clazz);
        if (abbrev == null) {
            throw new IllegalArgumentException("Not a basic data type!");
        }
        return abbrev;
    }

    public static Class<?> getTypeFromAbbreviation(String abbrev) {
        Class<?> type = abbrevToType.get(abbrev);
        if (type == null) {
            throw new IllegalArgumentException("Not the abbreviation of a basic data type!");
        }
        return type;
    }

    public static Class<?> arrayClassFor(Class<?> clazz, int dim) {
        if (dim <= 0) {
            throw new IllegalArgumentException("Invalid dimension");
        }
        Class<?> arrayClass = clazz;
        for (int i = 1; i <= dim; ++i) {
            arrayClass = Array.newInstance(arrayClass, 0).getClass();
        }
        return arrayClass;
    }

    public static ArrayInfo arrayDimension(Class<?> clazz) {
        int dim = 0;
        Class<?> cClass = clazz;
        while (cClass.isArray()) {
            cClass = cClass.getComponentType();
            ++dim;
        }
        return new ArrayInfo(cClass, dim);
    }

    static {
        lcToUcTypeMap.put(Byte.TYPE, Byte.class);
        lcToUcTypeMap.put(Short.TYPE, Short.class);
        lcToUcTypeMap.put(Integer.TYPE, Integer.class);
        lcToUcTypeMap.put(Long.TYPE, Long.class);
        lcToUcTypeMap.put(Float.TYPE, Float.class);
        lcToUcTypeMap.put(Double.TYPE, Double.class);
        lcToUcTypeMap.put(Boolean.TYPE, Boolean.class);
        lcToUcTypeMap.put(Character.TYPE, Character.class);
        for (Map.Entry<Class<?>, Class<?>> entry : lcToUcTypeMap.entrySet()) {
            ucToLcTypeMap.put(entry.getValue(), entry.getKey());
        }
        typeToAbbrev.put(Byte.TYPE, "byte");
        typeToAbbrev.put(Short.TYPE, "short");
        typeToAbbrev.put(Integer.TYPE, "int");
        typeToAbbrev.put(Long.TYPE, "long");
        typeToAbbrev.put(Float.TYPE, "float");
        typeToAbbrev.put(Double.TYPE, "double");
        typeToAbbrev.put(Boolean.TYPE, "boolean");
        typeToAbbrev.put(Character.TYPE, "char");
        typeToAbbrev.put(Byte.class, "Byte");
        typeToAbbrev.put(Short.class, "Short");
        typeToAbbrev.put(Integer.class, "Integer");
        typeToAbbrev.put(Long.class, "Long");
        typeToAbbrev.put(Float.class, "Float");
        typeToAbbrev.put(Double.class, "Double");
        typeToAbbrev.put(Boolean.class, "Boolean");
        typeToAbbrev.put(Character.class, "Character");
        typeToAbbrev.put(String.class, "String");
        for (Map.Entry<Class<?>, Object> entry : typeToAbbrev.entrySet()) {
            abbrevToType.put((String)entry.getValue(), entry.getKey());
        }
    }

    public static final class ArrayInfo {
        public final Class<?> elementClass;
        public final int dim;

        public ArrayInfo(Class<?> elementClass, int dim) {
            this.elementClass = elementClass;
            this.dim = dim;
        }
    }
}

