/*
 * Decompiled with CFR 0.152.
 */
package de.xab.porter.transfer.jdbc.reader;

import de.xab.porter.api.Column;
import de.xab.porter.api.Relation;
import de.xab.porter.api.Result;
import de.xab.porter.api.dataconnection.DataConnection;
import de.xab.porter.api.dataconnection.SrcConnection;
import de.xab.porter.api.exception.PorterException;
import de.xab.porter.common.enums.SequenceEnum;
import de.xab.porter.common.util.Loggers;
import de.xab.porter.common.util.Strings;
import de.xab.porter.transfer.exception.ConnectionException;
import de.xab.porter.transfer.jdbc.connector.JDBCConnector;
import de.xab.porter.transfer.reader.AbstractReader;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

public class JDBCReader
extends AbstractReader<Connection>
implements JDBCConnector {
    private final Logger logger = Loggers.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long doRead(Map<String, Column> columnMap, String sql) {
        SrcConnection srcConnection = (SrcConnection)this.getConnector().getDataConnection();
        int batchSize = srcConnection.getProperties().getBatchSize();
        batchSize = batchSize <= 0 ? 5000 : batchSize;
        Statement statement = null;
        ResultSet resultSet = null;
        Instant start = Instant.now();
        long batch = 0L;
        try {
            ((Connection)this.connection).setReadOnly(true);
            statement = this.getStatement(batchSize);
            resultSet = statement.executeQuery(sql);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            this.fillResultSetMeta(columnMap, metaData, columnCount);
            ArrayList<Column> meta = new ArrayList<Column>(columnMap.values());
            long seq = 0L;
            Relation relation = new Relation(meta);
            List rows = relation.getData();
            while (resultSet.next()) {
                ++batch;
                ArrayList<String> row = new ArrayList<String>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    row.add(resultSet.getString(i));
                }
                rows.add(row);
                if (batch % (long)batchSize != 0L) continue;
                this.pushToChannel(new Result(++seq, (Object)relation));
                relation = new Relation(meta);
                rows = relation.getData();
            }
            this.pushLastBatch(meta, ++seq, relation);
        }
        catch (SQLException exception) {
            try {
                throw new PorterException("read data from JDBC connection failed", (Throwable)exception);
            }
            catch (Throwable throwable) {
                Instant end2 = Instant.now();
                long seconds2 = Duration.between(start, end2).toSeconds();
                this.logger.info(String.format("%s rows have been read, cost %s second(s)", batch, seconds2));
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                catch (SQLException exception2) {
                    this.logger.warning("close JDBC connection failed");
                }
                throw throwable;
            }
        }
        Instant end = Instant.now();
        long seconds = Duration.between(start, end).toSeconds();
        this.logger.info(String.format("%s rows have been read, cost %s second(s)", batch, seconds));
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement == null) return batch;
            statement.close();
            return batch;
        }
        catch (SQLException exception) {
            this.logger.warning("close JDBC connection failed");
            return batch;
        }
    }

    public Map<String, Column> getTableMetaData() {
        SrcConnection srcConnection = (SrcConnection)this.getConnector().getDataConnection();
        Connection connection = (Connection)this.connection;
        LinkedHashMap<String, Column> columnMap = new LinkedHashMap<String, Column>();
        try (ResultSet columns = connection.getMetaData().getColumns(srcConnection.getCatalog(), srcConnection.getSchema(), srcConnection.getTable(), null);
             ResultSet primaryKeys = connection.getMetaData().getPrimaryKeys(srcConnection.getCatalog(), srcConnection.getSchema(), srcConnection.getTable());
             ResultSet indexInfo = connection.getMetaData().getIndexInfo(srcConnection.getCatalog(), srcConnection.getSchema(), srcConnection.getTable(), false, false);){
            while (columns.next()) {
                String remarks = columns.getString("REMARKS");
                String nullable = columns.getString("IS_NULLABLE");
                String columnName = columns.getString("COLUMN_NAME");
                Column column2 = new Column();
                column2.setName(columnName);
                column2.setComment(remarks);
                column2.setNullable(nullable);
                columnMap.putIfAbsent(columnName, column2);
            }
            while (primaryKeys.next()) {
                String columnName = primaryKeys.getString("COLUMN_NAME");
                String pkName = primaryKeys.getString("PK_NAME");
                short keySeq = primaryKeys.getShort("KEY_SEQ");
                columnMap.computeIfPresent(columnName, (ignored, column) -> {
                    column.setPrimaryKey(Strings.notNullOrBlank((String)pkName));
                    column.setIndexName(pkName);
                    column.setPrimaryKeySeq(keySeq);
                    return column;
                });
            }
            while (indexInfo.next()) {
                String indexName = indexInfo.getString("INDEX_NAME");
                String columnName = indexInfo.getString("COLUMN_NAME");
                columnMap.computeIfPresent(columnName, (ignored, column) -> {
                    column.setIndexName(indexName);
                    return column;
                });
            }
        }
        catch (SQLException exception) {
            throw new PorterException("read source meta data from JDBC connection failed", (Throwable)exception);
        }
        return columnMap;
    }

    protected String getIdentifierQuote() {
        try {
            return ((Connection)this.connection).getMetaData().getIdentifierQuoteString();
        }
        catch (SQLException e) {
            throw new PorterException("read quote from JDBC meta data failed", (Throwable)e);
        }
    }

    public List<String> split() {
        String column;
        SrcConnection srcConnection = (SrcConnection)this.getConnector().getDataConnection();
        SrcConnection.Properties properties = srcConnection.getProperties();
        String sql = srcConnection.getSql();
        int max = 0;
        int min = 0;
        try (Statement statement = this.getStatement(1);){
            ResultSet minResultSet;
            String quote = this.getIdentifierQuote();
            column = String.format("%s%s%s", quote, properties.getSplitColumn(), quote);
            String maxSql = String.format("SELECT MAX(%s) FROM (%s) AS MAX_TEMP WHERE 1=1", column, sql);
            String minSql = String.format("SELECT MIN(%s) FROM (%s) AS MIN_TEMP WHERE 1=1", column, sql);
            ResultSet maxResultSet = statement.executeQuery(maxSql);
            if (maxResultSet.next()) {
                max = maxResultSet.getInt(1);
            }
            if ((minResultSet = statement.executeQuery(minSql)).next()) {
                min = minResultSet.getInt(1);
            }
        }
        catch (SQLException exception) {
            this.logger.warning("split failed, reset trunk num to 1. " + exception.getMessage());
            return List.of(sql);
        }
        int range = max - min + 1;
        if (range == 1) {
            this.logger.info("max equals min, reset trunk num to 1");
            return List.of(sql);
        }
        int trunkNumber = properties.getReaderNumber();
        int step = range / trunkNumber;
        step = range % trunkNumber == 0 ? step : step + 1;
        int start = min;
        this.logger.info(String.format("%s starts at %s, ends at %s. Step is %s", properties.getSplitColumn(), min, max, step));
        ArrayList<String> sequels = new ArrayList<String>();
        for (int i = 0; i < trunkNumber; ++i) {
            int left = start;
            int right = left + step;
            if (i == trunkNumber - 1) {
                right = max;
            }
            start = right + 1;
            String splitSql = String.format("SELECT * FROM (%s) as TEMP WHERE %s >= %s AND %s <= %s", sql, column, left, column, right);
            this.logger.info(splitSql);
            sequels.add(splitSql);
        }
        this.logger.info("trunk size is " + sequels.size());
        return sequels;
    }

    protected Statement getStatement(int batchSize) throws SQLException {
        Statement statement = ((Connection)this.connection).createStatement(1003, 1007);
        statement.setFetchSize(batchSize);
        return statement;
    }

    private void fillResultSetMeta(Map<String, Column> columnMap, ResultSetMetaData metaData, int columnCount) throws SQLException {
        for (int i = 1; i <= columnCount; ++i) {
            String name = metaData.getColumnName(i);
            Column column = columnMap.compute(name, (key, oldValue) -> Objects.requireNonNullElseGet(oldValue, () -> new Column(name)));
            int displaySize = metaData.getColumnDisplaySize(i);
            boolean signed = metaData.isSigned(i);
            int precision = metaData.getPrecision(i);
            int scale = metaData.getScale(i);
            int columnType = metaData.getColumnType(i);
            String columnTypeName = metaData.getColumnTypeName(i);
            String className = metaData.getColumnClassName(i);
            column.setClassName(className);
            column.setDisplaySize(displaySize);
            column.setSigned(signed);
            column.setPrecision(precision);
            column.setScale(scale);
            column.setColumnType(JDBCType.valueOf(columnType));
            column.setColumnTypeName(columnTypeName);
            columnMap.put(name, column);
        }
    }

    private void pushLastBatch(List<Column> meta, long seq, Relation relation) {
        SrcConnection srcConnection = (SrcConnection)this.getConnector().getDataConnection();
        if (!relation.getData().isEmpty()) {
            seq = seq == (long)SequenceEnum.FIRST.getSequenceNum() ? (long)SequenceEnum.FIRST_AND_LAST.getSequenceNum() : (long)SequenceEnum.LAST_NOT_EMPTY.getSequenceNum();
            this.logger.info(String.format("read last %d scrap(s) from %s %s", relation.getData().size(), srcConnection.getType(), srcConnection.getUrl()));
        } else {
            seq = SequenceEnum.LAST_IS_EMPTY.getSequenceNum();
            relation = new Relation(meta);
        }
        this.pushToChannel(new Result(seq, (Object)relation));
    }

    public Connection connect(DataConnection dataConnection) throws ConnectionException {
        SrcConnection srcConnection = (SrcConnection)dataConnection;
        this.connection = (Connection)this.getConnector().connect(new Object[]{srcConnection, this.getJDBCUrl((DataConnection)srcConnection)});
        return (Connection)this.connection;
    }
}

