/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.jsonrpc;

import com.google.gson.JsonElement;
import com.xxl.tool.gson.GsonTool;
import com.xxl.tool.http.HttpTool;
import com.xxl.tool.jsonrpc.model.JsonRpcRequest;
import com.xxl.tool.jsonrpc.model.JsonRpcResponse;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcClient {
    private static Logger logger = LoggerFactory.getLogger(JsonRpcClient.class);
    private String url;
    private int timeout = 3000;
    private Map<String, String> headers = null;

    public JsonRpcClient(String url) {
        this.url = url;
    }

    public JsonRpcClient(String url, int timeout) {
        this.url = url;
        this.timeout = timeout;
    }

    public JsonRpcClient(String url, int timeout, Map<String, String> headers) {
        this.url = url;
        this.timeout = timeout;
        this.headers = headers;
    }

    public <T> T proxy(Class<T> serviceInterface) {
        return this.proxy(null, serviceInterface);
    }

    public <T> T proxy(String service, Class<T> serviceInterface) {
        return (T)Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (proxy, method, args) -> {
            String serviceName = service != null ? service : serviceInterface.getName();
            String methodName = method.getName();
            return this.invoke(serviceName, methodName, args, method.getGenericReturnType());
        });
    }

    public <T> T invoke(String service, String method, Object[] params, Type responseType) {
        try {
            JsonRpcRequest request;
            String requestJson;
            String responseData;
            JsonElement[] paramJsons = null;
            if (params != null) {
                paramJsons = new JsonElement[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramJsons[i] = GsonTool.toJsonElement(params[i]);
                }
            }
            if ((responseData = HttpTool.postBody(this.url, requestJson = GsonTool.toJson(request = new JsonRpcRequest(service, method, paramJsons)), this.headers, this.timeout)).isEmpty()) {
                throw new RuntimeException("response data not found");
            }
            JsonRpcResponse response = GsonTool.fromJson(responseData, JsonRpcResponse.class);
            if (response.getError() != null) {
                throw new RuntimeException("response error=" + response.getError());
            }
            if (responseType instanceof ParameterizedType) {
                Object responseObj = GsonTool.fromJsonElement(response.getData(), responseType);
                return responseObj;
            }
            Object responseObj = GsonTool.fromJsonElement(response.getData(), (Class)responseType);
            return responseObj;
        }
        catch (Throwable e) {
            throw new RuntimeException("invoke error, service:" + service + ", method:" + method, e);
        }
    }
}

