/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import com.xnx3.bean.ShellBean;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public class SSHUtil {
    private Connection conn;
    private String ip;
    private String username;
    private String password;
    private String charset = Charset.defaultCharset().toString();
    private static final int TIME_OUT = 300000;

    public SSHUtil(String ip, String username, String password) {
        this.ip = ip;
        this.username = username;
        this.password = password;
    }

    public boolean open() {
        this.conn = new Connection(this.ip);
        try {
            this.conn.connect();
            return this.conn.authenticateWithPassword(this.username, this.password);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShellBean exeCommand(String cmd) throws Exception {
        ShellBean shellBean = new ShellBean();
        InputStream stdOut = null;
        InputStream stdErr = null;
        try {
            Session session = this.conn.openSession();
            session.execCommand(cmd);
            stdOut = new StreamGobbler(session.getStdout());
            shellBean.setOutString(this.processStream(stdOut, this.charset));
            stdErr = new StreamGobbler(session.getStderr());
            shellBean.setErrorString(this.processStream(stdErr, this.charset));
            session.waitForCondition(32, 300000L);
            shellBean.setExitStatus(session.getExitStatus());
        }
        finally {
            if (stdOut != null) {
                stdOut.close();
            }
            if (stdErr != null) {
                stdErr.close();
            }
        }
        return shellBean;
    }

    public void close() {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    private String processStream(InputStream in, String charset) throws Exception {
        byte[] buf = new byte[1024];
        StringBuilder sb = new StringBuilder();
        while (in.read(buf) != -1) {
            sb.append(new String(buf, charset));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        SSHUtil ssh = new SSHUtil("192.168.199.251", "root", "elinli@2015");
        ssh.open();
        System.out.println(ssh.exeCommand("cd /alidata;pwd;ls").getOutString());
        System.out.println(ssh.exeCommand("cd /;pwd").getOutString());
        ssh.close();
    }
}

