/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectResult;
import com.xnx3.Lang;
import com.xnx3.media.ImageUtil;
import com.xnx3.net.ossbean.PutResult;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class OSSUtils {
    public String endpoint = "";
    public String accessKeyId = "";
    public String secretAccessKey = "";
    public String bucketName = "";
    public String url = "";
    private OSSClient ossClient;

    public OSSUtils(String endpoint, String accessKeyId, String secretAccessKey, String bucketName, String url) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.secretAccessKey = secretAccessKey;
        this.bucketName = bucketName;
    }

    public OSSClient getOSSClient() {
        if (this.ossClient == null) {
            this.ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.secretAccessKey);
        }
        return this.ossClient;
    }

    public void createFolder(String folderName) {
        if (folderName.lastIndexOf("/") < folderName.length() - 1) {
            folderName = folderName + "/";
        }
        this.getOSSClient().putObject(this.bucketName, folderName, (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    public PutResult put(String filePath, String fileName, InputStream inputStream) {
        String fileSuffix = Lang.subString((String)fileName, (String)".", null, (int)3);
        String name = Lang.uuid() + "." + fileSuffix;
        String path = filePath + name;
        PutObjectResult pr = this.getOSSClient().putObject(this.bucketName, path, inputStream);
        return new PutResult(name, path, this.url + path);
    }

    public void deleteObject(String filePath) {
        this.getOSSClient().deleteObject(this.bucketName, filePath);
    }

    public PutResult put(String path, InputStream inputStream) {
        PutObjectResult pr = this.getOSSClient().putObject(this.bucketName, path, inputStream);
        String name = Lang.subString((String)path, (String)"/", null, (int)3);
        return new PutResult(name, path, this.url + path);
    }

    public PutResult put(String filePath, String localPath) {
        File file = new File(localPath);
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return this.put(filePath, localPath, input);
    }

    public PutResult putImageByUrl(String filePath, String imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        String suffix = Lang.findFileSuffix((String)imageUrl);
        BufferedImage bufferedImage = ImageUtil.getBufferedImageByUrl((String)imageUrl);
        if (suffix == null) {
            suffix = "jpg";
        }
        return this.put(filePath + "." + suffix, ImageUtil.bufferedImageToInputStream((BufferedImage)bufferedImage, (String)suffix));
    }

    public PutResult putStringFile(String path, String text, String encode) {
        try {
            return this.put(path, new ByteArrayInputStream(text.getBytes(encode)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PutResult putStringFile(String path, String text) {
        return this.putStringFile(path, text, "UTF-8");
    }

    public long getFolderSize(String filePath) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
        listObjectsRequest.setPrefix(filePath);
        listObjectsRequest.setMaxKeys(Integer.valueOf(1000));
        boolean have = true;
        String nextMarker = null;
        int size = 0;
        while (have) {
            if (nextMarker != null) {
                listObjectsRequest.setMarker(nextMarker);
            }
            ObjectListing listO = this.getOSSClient().listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listO.getObjectSummaries()) {
                size = (int)((long)size + objectSummary.getSize());
            }
            have = listO.isTruncated();
            nextMarker = listO.getNextMarker();
        }
        return size;
    }

    public List<OSSObjectSummary> getFolderObjectList(String filePath) {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.bucketName);
        listObjectsRequest.setPrefix(filePath);
        listObjectsRequest.setMaxKeys(Integer.valueOf(1000));
        ArrayList<OSSObjectSummary> list = new ArrayList<OSSObjectSummary>();
        boolean have = true;
        String nextMarker = null;
        while (have) {
            if (nextMarker != null) {
                listObjectsRequest.setMarker(nextMarker);
            }
            ObjectListing listO = this.getOSSClient().listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listO.getObjectSummaries()) {
                list.add(objectSummary);
            }
            have = listO.isTruncated();
            nextMarker = listO.getNextMarker();
        }
        return list;
    }

    public static void main(String[] args) throws FileNotFoundException {
        OSSUtils o = new OSSUtils("oss-cn-hongkong.aliyuncs.com", ".....", "...", "...", "http://www.baidu.com/");
        System.out.println(o.putStringFile("ceshi.txt", "\u54c8\u54c8"));
    }
}

