/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.push.model.v20160801.PushRequest;
import com.aliyuncs.push.model.v20160801.PushResponse;
import com.aliyuncs.utils.ParameterHelper;
import java.util.Date;

public class AliyunPushUtil {
    public long appKey = 0L;
    public IClientProfile profile;
    DefaultAcsClient client;

    public AliyunPushUtil(String regionId, String accessKeyId, String accessKeySecret, long appKey) {
        this.appKey = appKey;
        this.profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        this.client = new DefaultAcsClient(this.profile);
    }

    public void send(PushRequest pushRequest) {
        String expireTime = ParameterHelper.getISO8601Time((Date)new Date(System.currentTimeMillis() + 43200000L));
        pushRequest.setExpireTime(expireTime);
        pushRequest.setStoreOffline(Boolean.valueOf(true));
        PushResponse pushResponse = null;
        try {
            pushResponse = (PushResponse)this.client.getAcsResponse((AcsRequest)pushRequest);
            System.out.printf("RequestId: %s, MessageID: %s\n", pushResponse.getRequestId(), pushResponse.getMessageId());
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
    }

    public PushRequest getNewPushRequest() {
        PushRequest pushRequest = new PushRequest();
        pushRequest.setAppKey(Long.valueOf(this.appKey));
        pushRequest.setTarget("DEVICE");
        pushRequest.setTargetValue("deviceIds");
        pushRequest.setTarget("ALL");
        pushRequest.setTargetValue("ALL");
        pushRequest.setPushType("NOTICE");
        pushRequest.setDeviceType("ALL");
        pushRequest.setTitle("ALi Push Title");
        pushRequest.setBody("Ali Push Body");
        pushRequest.setAndroidNotifyType("NONE");
        pushRequest.setAndroidNotificationBarType(Integer.valueOf(1));
        pushRequest.setAndroidNotificationBarPriority(Integer.valueOf(1));
        pushRequest.setAndroidOpenType("URL");
        pushRequest.setAndroidOpenUrl("http://www.aliyun.com");
        pushRequest.setAndroidActivity("com.alibaba.push2.demo.XiaoMiPushActivity");
        pushRequest.setAndroidMusic("default");
        pushRequest.setAndroidXiaoMiActivity("com.ali.demo.MiActivity");
        pushRequest.setAndroidXiaoMiNotifyTitle("Mi title");
        pushRequest.setAndroidXiaoMiNotifyBody("MiActivity Body");
        pushRequest.setAndroidExtParameters("{\"k1\":\"android\",\"k2\":\"v2\"}");
        return null;
    }

    public static void main(String[] args) {
        AliyunPushUtil aliyunPush = new AliyunPushUtil("cn-hangzhou", "....", "....", 23584052L);
        PushRequest pushRequest = new PushRequest();
        pushRequest.setAppKey(Long.valueOf(aliyunPush.appKey));
        pushRequest.setTarget("DEVICE");
        pushRequest.setTargetValue("deviceIds");
        pushRequest.setTarget("ALL");
        pushRequest.setTargetValue("ALL");
        pushRequest.setPushType("NOTICE");
        pushRequest.setDeviceType("ALL");
        pushRequest.setTitle("ALi Push Title");
        pushRequest.setBody("Ali Push Body");
        pushRequest.setAndroidNotifyType("NONE");
        pushRequest.setAndroidNotificationBarType(Integer.valueOf(1));
        pushRequest.setAndroidNotificationBarPriority(Integer.valueOf(1));
        pushRequest.setAndroidOpenType("URL");
        pushRequest.setAndroidOpenUrl("http://www.aliyun.com");
        pushRequest.setAndroidActivity("com.alibaba.push2.demo.XiaoMiPushActivity");
        pushRequest.setAndroidMusic("default");
        pushRequest.setAndroidXiaoMiActivity("com.ali.demo.MiActivity");
        pushRequest.setAndroidXiaoMiNotifyTitle("Mi title");
        pushRequest.setAndroidXiaoMiNotifyBody("MiActivity Body");
        pushRequest.setAndroidExtParameters("{\"k1\":\"android\",\"k2\":\"v2\"}");
        aliyunPush.send(pushRequest);
    }
}

