/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3.net;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.common.QueriedLog;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.request.GetHistogramsRequest;
import com.aliyun.openservices.log.request.GetLogsRequest;
import com.aliyun.openservices.log.request.ListLogStoresRequest;
import com.aliyun.openservices.log.request.PutLogsRequest;
import com.aliyun.openservices.log.response.GetHistogramsResponse;
import com.aliyun.openservices.log.response.GetLogsResponse;
import com.aliyun.openservices.log.response.PutLogsResponse;
import com.xnx3.DateUtil;
import com.xnx3.exception.NotReturnValueException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class AliyunLogUtil {
    public String project = "";
    public String logstore = "";
    public Vector<LogItem> logGroupCache;
    public int cacheLogMaxNumber = 100;
    public int cacheLogMaxTime = 600;
    public int stack_trace_deep = 0;
    public int lastSubmitTime = DateUtil.timeForUnix10();
    public Client client;

    public AliyunLogUtil(String endpoint, String accessKeyId, String accessKeySecret, String project, String logstore) {
        this.project = project;
        this.logstore = logstore;
        this.client = new Client(endpoint, accessKeyId, accessKeySecret);
        this.logGroupCache = new Vector();
    }

    public void setCacheLogMaxNumber(int cacheLogMaxNumber) {
        this.cacheLogMaxNumber = cacheLogMaxNumber;
    }

    public void setCacheAutoSubmit(int maxNumber, int maxTime) {
        this.cacheLogMaxNumber = maxNumber;
        this.cacheLogMaxTime = maxTime;
    }

    public void setStackTraceDeep(int deep) {
        this.stack_trace_deep = deep;
    }

    public ArrayList<String> getLogStore() throws LogException {
        int offset = 0;
        int size = 100;
        String logStoreSubName = "";
        ListLogStoresRequest req1 = new ListLogStoresRequest(this.project, offset, size, logStoreSubName);
        ArrayList logStores = this.client.ListLogStores(req1).GetLogStores();
        return logStores;
    }

    public PutLogsResponse save(String topic, String source, LogItem logItem) throws LogException {
        Vector<LogItem> logGroup = new Vector<LogItem>();
        logGroup.add(logItem);
        PutLogsRequest req2 = new PutLogsRequest(this.project, this.logstore, topic, source, logGroup);
        return this.client.PutLogs(req2);
    }

    public void cacheLog(LogItem logItem) throws LogException {
        if (logItem == null) {
            return;
        }
        if (this.stack_trace_deep > 0) {
            StackTraceElement st = Thread.currentThread().getStackTrace()[this.stack_trace_deep];
            logItem.PushBack("className", st.getClassName());
            logItem.PushBack("methodName", st.getMethodName());
            logItem.PushBack("fileName", st.getFileName());
        }
        this.logGroupCache.add(logItem);
        boolean submit = false;
        if (this.logGroupCache.size() > this.cacheLogMaxNumber) {
            submit = true;
        } else {
            int currentTime = DateUtil.timeForUnix10();
            if (this.lastSubmitTime + this.cacheLogMaxTime < currentTime) {
                submit = true;
                this.lastSubmitTime = currentTime;
            }
        }
        if (submit) {
            this.cacheCommit();
        }
    }

    public PutLogsResponse cacheCommit() throws LogException {
        PutLogsResponse r = this.saveByGroup("", "", this.logGroupCache);
        if (r != null && r.GetRequestId() != null && r.GetRequestId().length() > 0) {
            this.logGroupCache.clear();
            int currentTime = DateUtil.timeForUnix10();
            if (this.lastSubmitTime < currentTime) {
                this.lastSubmitTime = currentTime;
            }
        }
        return r;
    }

    public PutLogsResponse saveByGroup(String topic, String source, Vector<LogItem> logGroup) throws LogException {
        PutLogsRequest req2 = new PutLogsRequest(this.project, this.logstore, topic, source, logGroup);
        return this.client.PutLogs(req2);
    }

    public LogItem newLogItem() {
        return new LogItem((int)(new Date().getTime() / 1000L));
    }

    public long queryCount(String query, String topic, int startTime, int endTime) throws LogException {
        GetHistogramsRequest req3;
        GetHistogramsResponse res3 = null;
        int i = 0;
        while (!(i++ >= 3 || (res3 = this.client.GetHistograms(req3 = new GetHistogramsRequest(this.project, this.logstore, topic, query, startTime, endTime))) != null && res3.IsCompleted())) {
        }
        return res3.GetTotalCount();
    }

    public ArrayList<QueriedLog> queryList(String query, String topic, int startTime, int endTime, int offset, int line, boolean reverse) throws LogException {
        GetLogsRequest req4;
        GetLogsResponse res4 = null;
        for (int retry_time = 0; !(retry_time >= 3 || (res4 = this.client.GetLogs(req4 = new GetLogsRequest(this.project, this.logstore, startTime, endTime, topic, query, offset, line, reverse))) != null && res4.IsCompleted()); ++retry_time) {
        }
        if (res4 == null) {
            return null;
        }
        return res4.GetLogs();
    }

    public static void main(String[] args) throws LogException, InterruptedException, NotReturnValueException {
        AliyunLogUtil aliyunLogUtil = new AliyunLogUtil("cn-hongkong.log.aliyuncs.com", "121212", "121212", "requestlog", "fangwen");
        ArrayList<QueriedLog> qlList = aliyunLogUtil.queryList("*", "leiwen.wang.market", DateUtil.timeForUnix10() - 10000000, DateUtil.timeForUnix10(), 0, 100, true);
        for (int i = 0; i < qlList.size(); ++i) {
            System.out.println(i);
            QueriedLog ll = qlList.get(i);
            LogItem li = ll.GetLogItem();
            System.out.println(li.GetLogContents().toString());
        }
        System.out.println("qlList  :  " + qlList.size());
    }
}

