/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.ConfigManagerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Language {
    public static final String cacheLanguagePackageName = "language_default";
    public static String language_default = "chinese";
    public static Map<String, Map<String, String>> languageMap;

    public static void main(String[] args) {
        for (Map.Entry<String, Map<String, String>> entry : languageMap.entrySet()) {
            System.out.println(entry.getKey() + " ---->  " + entry.getValue().size());
            for (Map.Entry<String, String> e : entry.getValue().entrySet()) {
                System.out.println("   " + e.getKey());
            }
        }
    }

    private static void loadLanguagePackage() {
        languageMap = new HashMap<String, Map<String, String>>();
        ConfigManagerUtil config = ConfigManagerUtil.getSingleton("language.xml");
        Iterator englishIt = config.getFileConfiguration().getKeys();
        HashMap<String, String> languageMap = new HashMap<String, String>();
        while (englishIt.hasNext()) {
            String key = (String)englishIt.next();
            if (key.indexOf(".") <= -1) continue;
            String[] l = key.split("\\.");
            languageMap.put(l[0], l[0]);
        }
        for (Map.Entry entry : languageMap.entrySet()) {
            Language.loadLanguagePackage((String)entry.getKey());
        }
    }

    private static void loadLanguagePackage(String languageName) {
        ConfigManagerUtil config = ConfigManagerUtil.getSingleton("language.xml");
        Iterator englishIt = config.getFileConfiguration().getKeys(languageName);
        HashMap<String, String> englishMap = new HashMap<String, String>();
        while (englishIt.hasNext()) {
            String key = (String)englishIt.next();
            String value = config.getValue(key);
            englishMap.put(key.replace(languageName + ".", ""), value);
        }
        languageMap.put(languageName, englishMap);
    }

    public static String show(String packageName, String key) {
        if (packageName == null) {
            packageName = language_default;
        }
        if (key == null) {
            return "";
        }
        String value = languageMap.get(packageName).get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public static List<String> getLanguagePackageList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Map<String, String>> entry : languageMap.entrySet()) {
            list.add(entry.getKey());
        }
        return list;
    }

    public static boolean isHaveLanguagePackageName(String packageName) {
        return languageMap.get(packageName) != null;
    }

    static {
        language_default = ConfigManagerUtil.getSingleton("language.xml").getValue("defaultLanguage");
        Language.loadLanguagePackage();
    }
}

