/*
 * Decompiled with CFR 0.152.
 */
package com.xnx3;

import com.xnx3.Lang;
import com.xnx3.exception.NotReturnValueException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String FORMAT_DEFAULT = "yyyy-MM-dd hh:mm:ss";

    public static long timeForUnix13() {
        Date date = new Date();
        long time = date.getTime();
        return time;
    }

    public static String intToString(int linuxTime, String format) {
        try {
            return DateUtil.dateFormat(linuxTime, format);
        }
        catch (NotReturnValueException e) {
            e.printStackTrace();
            return linuxTime + "";
        }
    }

    public static String dateFormat(long linuxTime, String format) throws NotReturnValueException {
        int linuxTimeLength = (linuxTime + "").length();
        if (linuxTime == 0L || linuxTimeLength > 13) {
            throw new NotReturnValueException("\u4f20\u5165\u7684linux\u65f6\u95f4\u6233\u957f\u5ea6\u9519\u8bef\uff01\u5f53\u524d\u4f20\u5165\u7684\u65f6\u95f4\u6233\uff1a" + linuxTime + ",\u8bf7\u4f20\u516510\u6216\u800513\u4f4d\u7684\u65f6\u95f4\u6233");
        }
        if (format == null || format.length() == 0) {
            format = FORMAT_DEFAULT;
        }
        if (linuxTimeLength < 11) {
            linuxTime *= 1000L;
        }
        return new SimpleDateFormat(format).format(new Date(linuxTime));
    }

    public String dateFormat(long linuxTime) throws NotReturnValueException {
        return DateUtil.dateFormat(linuxTime, FORMAT_DEFAULT);
    }

    public static String currentDate(String format) {
        if (format == null || format.length() == 0) {
            format = FORMAT_DEFAULT;
        }
        return new SimpleDateFormat(format).format(new Date());
    }

    public static int timeForUnix10() {
        return DateUtil.long13To10(DateUtil.timeForUnix13());
    }

    public static Date StringToDate(String time, String format) {
        SimpleDateFormat sFormat = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sFormat.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static int StringToInt(String time, String format) {
        long d = DateUtil.StringToDate(time, format).getTime();
        if (d == 0L) {
            return 0;
        }
        return (int)Math.ceil(d / 1000L);
    }

    public static Date weeHours(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        long millisecond = hour * 60 * 60 * 1000 + minute * 60 * 1000 + second * 1000;
        cal.setTimeInMillis(cal.getTimeInMillis() - millisecond);
        return cal.getTime();
    }

    public static Date midnight(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setTimeInMillis(cal.getTimeInMillis() + 82800000L + 3540000L + 59000L);
        return cal.getTime();
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format2.format(date);
    }

    public static int dateToInt10(Date date) {
        return DateUtil.long13To10(date.getTime());
    }

    public static int long13To10(long time) {
        return Lang.stringToInt((time + "").substring(0, 10), 0);
    }

    public static int currentWeek() {
        Calendar cal = Calendar.getInstance();
        return cal.get(7);
    }

    public static int getDateZeroTime(int time) {
        String ls;
        try {
            ls = DateUtil.dateFormat(time, "yyyy-MM-dd");
        }
        catch (NotReturnValueException e) {
            e.printStackTrace();
            return 0;
        }
        return DateUtil.StringToInt(ls + " 00:00:00", FORMAT_DEFAULT);
    }

    public static int getWeekForTime(String pTime) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        try {
            c.setTime(format.parse(pTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
        int dayForWeek = 0;
        dayForWeek = c.get(7) == 1 ? 7 : c.get(7) - 1;
        return dayForWeek;
    }
}

