/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cron;

import com.xiaoleilu.hutool.cron.Scheduler;
import com.xiaoleilu.hutool.date.DateUnit;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.util.ThreadUtil;

public class CronTimer
extends Thread {
    private static final Log log = LogFactory.get();
    private long TIMER_UNIT_SECOND = DateUnit.SECOND.getMillis();
    private long TIMER_UNIT_MINUTE = DateUnit.MINUTE.getMillis();
    private Scheduler scheduler;

    public CronTimer(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        long nextTime;
        long sleep;
        long timerUnit = this.scheduler.matchSecond ? this.TIMER_UNIT_SECOND : this.TIMER_UNIT_MINUTE;
        long thisTime = System.currentTimeMillis();
        while ((sleep = (nextTime = (thisTime / timerUnit + 1L) * timerUnit) - System.currentTimeMillis()) <= 0L || ThreadUtil.safeSleep((Number)sleep)) {
            thisTime = System.currentTimeMillis();
            this.spawnLauncher(thisTime);
        }
        log.debug("Hutool Cron Timer stoped.", new Object[0]);
    }

    private void spawnLauncher(long millis) {
        this.scheduler.taskLauncherManager.spawnLauncher(millis);
    }
}

