/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractServer;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.transport.netty.NettyChannelHandler;
import com.weibo.api.motan.transport.netty.NettyDecoder;
import com.weibo.api.motan.transport.netty.NettyEncoder;
import com.weibo.api.motan.transport.netty.NettyServerChannelManage;
import com.weibo.api.motan.transport.netty.StandardThreadExecutor;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.StatisticCallback;
import com.weibo.api.motan.util.StatsUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class NettyServer
extends AbstractServer
implements StatisticCallback {
    private static final ChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("nettyServerBoss", true)), (Executor)Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory("nettyServerWorker", true)));
    protected NettyServerChannelManage channelManage = null;
    private StandardThreadExecutor standardThreadExecutor = null;
    private org.jboss.netty.channel.Channel serverChannel;
    private ServerBootstrap bootstrap;
    private MessageHandler messageHandler;
    private NettyChannelHandler nettyChannelHandler;

    public NettyServer(URL url, MessageHandler messageHandler) {
        super(url);
        this.messageHandler = messageHandler;
    }

    public Response request(Request request) throws TransportException {
        throw new MotanFrameworkException("NettyServer request(Request request) method unsupport: url: " + this.url);
    }

    public synchronized boolean open() {
        if (this.isAvailable()) {
            LoggerUtil.warn((String)("NettyServer ServerChannel already Open: url=" + this.url));
            return true;
        }
        LoggerUtil.info((String)("NettyServer ServerChannel start Open: url=" + this.url));
        this.initServerBootstrap();
        this.serverChannel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.url.getPort()));
        this.state = ChannelState.ALIVE;
        StatsUtil.registryStatisticCallback((StatisticCallback)this);
        LoggerUtil.info((String)("NettyServer ServerChannel finish Open: url=" + this.url));
        return this.state.isAliveState();
    }

    private synchronized void initServerBootstrap() {
        boolean shareChannel = this.url.getBooleanParameter(URLParamType.shareChannel.getName(), URLParamType.shareChannel.getBooleanValue());
        final int maxContentLength = this.url.getIntParameter(URLParamType.maxContentLength.getName(), URLParamType.maxContentLength.getIntValue());
        int maxServerConnection = this.url.getIntParameter(URLParamType.maxServerConnection.getName(), URLParamType.maxServerConnection.getIntValue());
        int workerQueueSize = this.url.getIntParameter(URLParamType.workerQueueSize.getName(), URLParamType.workerQueueSize.getIntValue());
        int minWorkerThread = 0;
        int maxWorkerThread = 0;
        if (shareChannel) {
            minWorkerThread = this.url.getIntParameter(URLParamType.minWorkerThread.getName(), 40);
            maxWorkerThread = this.url.getIntParameter(URLParamType.maxWorkerThread.getName(), 800);
        } else {
            minWorkerThread = this.url.getIntParameter(URLParamType.minWorkerThread.getName(), 20);
            maxWorkerThread = this.url.getIntParameter(URLParamType.maxWorkerThread.getName(), 200);
        }
        this.standardThreadExecutor = this.standardThreadExecutor != null && !this.standardThreadExecutor.isShutdown() ? this.standardThreadExecutor : new StandardThreadExecutor(minWorkerThread, maxWorkerThread, workerQueueSize, (ThreadFactory)new DefaultThreadFactory("NettyServer-" + this.url.getServerPortStr(), true));
        this.standardThreadExecutor.prestartAllCoreThreads();
        this.channelManage = new NettyServerChannelManage(maxServerConnection);
        this.bootstrap = new ServerBootstrap(channelFactory);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.nettyChannelHandler = new NettyChannelHandler((Channel)this, this.messageHandler, this.standardThreadExecutor);
        StatsUtil.registryStatisticCallback((StatisticCallback)this.nettyChannelHandler);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("channel_manage", (ChannelHandler)NettyServer.this.channelManage);
                pipeline.addLast("decoder", (ChannelHandler)new NettyDecoder(NettyServer.this.codec, (Channel)NettyServer.this, maxContentLength));
                pipeline.addLast("encoder", (ChannelHandler)new NettyEncoder(NettyServer.this.codec, (Channel)NettyServer.this));
                pipeline.addLast("nettyChannelHandler", (ChannelHandler)NettyServer.this.nettyChannelHandler);
                return pipeline;
            }
        });
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int timeout) {
        if (this.state.isCloseState()) {
            LoggerUtil.info((String)"NettyServer close fail: already close, url={}", (Object[])new Object[]{this.url.getUri()});
            return;
        }
        if (this.state.isUnInitState()) {
            LoggerUtil.info((String)"NettyServer close Fail: don't need to close because node is unInit state: url={}", (Object[])new Object[]{this.url.getUri()});
            return;
        }
        try {
            this.serverChannel.close();
            this.channelManage.close();
            this.standardThreadExecutor.shutdownNow();
            this.state = ChannelState.CLOSE;
            StatsUtil.unRegistryStatisticCallback((StatisticCallback)this.nettyChannelHandler);
            StatsUtil.unRegistryStatisticCallback((StatisticCallback)this);
            LoggerUtil.info((String)"NettyServer close Success: url={}", (Object[])new Object[]{this.url.getUri()});
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyServer close Error: url=" + this.url.getUri()), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.state.isCloseState();
    }

    public boolean isAvailable() {
        return this.state.isAliveState();
    }

    public URL getUrl() {
        return this.url;
    }

    public String statisticCallback() {
        return String.format("identity: %s connectionCount: %s taskCount: %s queueCount: %s maxThreadCount: %s maxTaskCount: %s", this.url.getIdentity(), this.channelManage.getChannels().size(), this.standardThreadExecutor.getSubmittedTasksCount(), this.standardThreadExecutor.getQueue().size(), this.standardThreadExecutor.getMaximumPoolSize(), this.standardThreadExecutor.getMaxSubmittedTaskCount());
    }

    public boolean isBound() {
        return this.serverChannel != null && this.serverChannel.isBound();
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }
}

