/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.protocol.v2motan.MotanV2Codec;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.io.IOException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

public class NettyEncoder
extends OneToOneEncoder {
    private Codec codec;
    private Channel client;

    public NettyEncoder(Codec codec, Channel client) {
        this.codec = codec;
        this.client = client;
    }

    protected Object encode(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel nettyChannel, Object message) throws Exception {
        ChannelBuffer channelBuffer = this.codec instanceof MotanV2Codec ? this.encodev2(ctx, nettyChannel, message) : this.encodev1(ctx, nettyChannel, message);
        if (message instanceof Response) {
            ((Response)message).setAttachment("Content-Length", String.valueOf(channelBuffer.readableBytes()));
        }
        MotanFrameworkUtil.logRequestEvent((long)this.getRequestId(message), (String)("after encode rpc " + (message instanceof Request ? "request " : "response ") + this.client.getUrl().getServerPortStr()), (long)System.currentTimeMillis());
        return channelBuffer;
    }

    private ChannelBuffer encodev2(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel nettyChannel, Object message) throws Exception {
        return ChannelBuffers.wrappedBuffer((byte[])this.encodeMessage(message));
    }

    private ChannelBuffer encodev1(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel nettyChannel, Object message) throws Exception {
        long requestId = this.getRequestId(message);
        byte[] data = this.encodeMessage(message);
        byte[] transportHeader = new byte[16];
        ByteUtil.short2bytes((short)-3599, (byte[])transportHeader, (int)0);
        transportHeader[3] = this.getType(message);
        ByteUtil.long2bytes((long)requestId, (byte[])transportHeader, (int)4);
        ByteUtil.int2bytes((int)data.length, (byte[])transportHeader, (int)12);
        return ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{transportHeader, data});
    }

    private byte[] encodeMessage(Object message) throws IOException {
        byte[] data = null;
        if (message instanceof Response) {
            try {
                data = this.codec.encode(this.client, message);
            }
            catch (Exception e) {
                LoggerUtil.error((String)("NettyEncoder encode error, identity=" + this.client.getUrl().getIdentity()), (Throwable)e);
                long requestId = this.getRequestId(message);
                Response response = this.buildExceptionResponse(requestId, e);
                data = this.codec.encode(this.client, (Object)response);
            }
        } else {
            data = this.codec.encode(this.client, message);
        }
        return data;
    }

    private long getRequestId(Object message) {
        if (message instanceof Request) {
            return ((Request)message).getRequestId();
        }
        if (message instanceof Response) {
            return ((Response)message).getRequestId();
        }
        return 0L;
    }

    private byte getType(Object message) {
        if (message instanceof Request) {
            return 0;
        }
        if (message instanceof Response) {
            return 1;
        }
        return -1;
    }

    private Response buildExceptionResponse(long requestId, Exception e) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setException(e);
        return response;
    }
}

