/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport;

import com.weibo.api.motan.exception.MotanBizException;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.protocol.rpc.CompressRpcCodec;
import com.weibo.api.motan.rpc.DefaultRequest;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Provider;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.serialize.DeserializableObject;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import com.weibo.api.motan.util.ReflectUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class ProviderMessageRouter
implements MessageHandler {
    protected Map<String, Provider<?>> providers = new HashMap();
    protected AtomicInteger methodCounter = new AtomicInteger(0);

    public ProviderMessageRouter() {
    }

    public ProviderMessageRouter(Provider<?> provider) {
        this.addProvider(provider);
    }

    @Override
    public Object handle(Channel channel, Object message) {
        if (channel == null || message == null) {
            throw new MotanFrameworkException("RequestRouter handler(channel, message) params is null");
        }
        if (!(message instanceof Request)) {
            throw new MotanFrameworkException("RequestRouter message type not support: " + message.getClass());
        }
        Request request = (Request)message;
        String serviceKey = MotanFrameworkUtil.getServiceKey(request);
        Provider<?> provider = this.providers.get(serviceKey);
        if (provider == null) {
            LoggerUtil.error(this.getClass().getSimpleName() + " handler Error: provider not exist serviceKey=" + serviceKey + " " + MotanFrameworkUtil.toString(request));
            MotanServiceException exception = new MotanServiceException(this.getClass().getSimpleName() + " handler Error: provider not exist serviceKey=" + serviceKey + " " + MotanFrameworkUtil.toString(request));
            DefaultResponse response = MotanFrameworkUtil.buildErrorResponse(request, exception);
            return response;
        }
        Method method = provider.lookupMethod(request.getMethodName(), request.getParamtersDesc());
        this.fillParamDesc(request, method);
        this.processLazyDeserialize(request, method);
        Response response = this.call(request, provider);
        response.setSerializeNumber(request.getSerializeNumber());
        response.setRpcProtocolVersion(request.getRpcProtocolVersion());
        return response;
    }

    protected Response call(Request request, Provider<?> provider) {
        try {
            return provider.call(request);
        }
        catch (Exception e) {
            return MotanFrameworkUtil.buildErrorResponse(request, new MotanBizException("provider call process error", e));
        }
    }

    private void processLazyDeserialize(Request request, Method method) {
        if (method != null && request.getArguments() != null && request.getArguments().length == 1 && request.getArguments()[0] instanceof DeserializableObject && request instanceof DefaultRequest) {
            try {
                Object[] args = ((DeserializableObject)request.getArguments()[0]).deserializeMulti(method.getParameterTypes());
                ((DefaultRequest)request).setArguments(args);
            }
            catch (IOException e) {
                throw new MotanFrameworkException("deserialize parameters fail: " + request.toString() + ", error:" + e.getMessage());
            }
        }
    }

    private void fillParamDesc(Request request, Method method) {
        if (method != null && StringUtils.isBlank((CharSequence)request.getParamtersDesc()) && request instanceof DefaultRequest) {
            DefaultRequest dr = (DefaultRequest)request;
            dr.setParamtersDesc(ReflectUtil.getMethodParamDesc(method));
            dr.setMethodName(method.getName());
        }
    }

    public synchronized void addProvider(Provider<?> provider) {
        String serviceKey = MotanFrameworkUtil.getServiceKey(provider.getUrl());
        if (this.providers.containsKey(serviceKey)) {
            throw new MotanFrameworkException("provider alread exist: " + serviceKey);
        }
        this.providers.put(serviceKey, provider);
        List<Method> methods = ReflectUtil.getPublicMethod(provider.getInterface());
        CompressRpcCodec.putMethodSign(provider, methods);
        int publicMethodCount = methods.size();
        this.methodCounter.addAndGet(publicMethodCount);
        LoggerUtil.info("RequestRouter addProvider: url=" + provider.getUrl() + " all_public_method_count=" + this.methodCounter.get());
    }

    public synchronized void removeProvider(Provider<?> provider) {
        String serviceKey = MotanFrameworkUtil.getServiceKey(provider.getUrl());
        this.providers.remove(serviceKey);
        List<Method> methods = ReflectUtil.getPublicMethod(provider.getInterface());
        int publicMethodCount = methods.size();
        this.methodCounter.getAndSet(this.methodCounter.get() - publicMethodCount);
        LoggerUtil.info("RequestRouter removeProvider: url=" + provider.getUrl() + " all_public_method_count=" + this.methodCounter.get());
    }

    public int getPublicMethodCount() {
        return this.methodCounter.get();
    }
}

