/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.partners.v20180321.models;

import com.tencentcloudapi.common.AbstractModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeClientBalanceResponse extends AbstractModel{

    /**
    * 账户可用余额，单位分 （可用余额 = 现金余额 - 冻结金额）
    */
    @SerializedName("Balance")
    @Expose
    private Long Balance;

    /**
    * 账户现金余额，单位分
    */
    @SerializedName("Cash")
    @Expose
    private Long Cash;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get 账户可用余额，单位分 （可用余额 = 现金余额 - 冻结金额） 
     * @return Balance 账户可用余额，单位分 （可用余额 = 现金余额 - 冻结金额）
     */
    public Long getBalance() {
        return this.Balance;
    }

    /**
     * Set 账户可用余额，单位分 （可用余额 = 现金余额 - 冻结金额）
     * @param Balance 账户可用余额，单位分 （可用余额 = 现金余额 - 冻结金额）
     */
    public void setBalance(Long Balance) {
        this.Balance = Balance;
    }

    /**
     * Get 账户现金余额，单位分 
     * @return Cash 账户现金余额，单位分
     */
    public Long getCash() {
        return this.Cash;
    }

    /**
     * Set 账户现金余额，单位分
     * @param Cash 账户现金余额，单位分
     */
    public void setCash(Long Cash) {
        this.Cash = Cash;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public DescribeClientBalanceResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeClientBalanceResponse(DescribeClientBalanceResponse source) {
        if (source.Balance != null) {
            this.Balance = new Long(source.Balance);
        }
        if (source.Cash != null) {
            this.Cash = new Long(source.Cash);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "Balance", this.Balance);
        this.setParamSimple(map, prefix + "Cash", this.Cash);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

