/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.util;

import com.qq.tars.client.ServantProxyConfig;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.rpc.common.Url;
import com.qq.tars.rpc.exc.ClientException;
import com.qq.tars.support.query.prx.EndpointF;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ParseTools {
    public static String parseSimpleObjectName(String objectName) {
        int point = objectName.indexOf("@");
        if (point != -1) {
            return objectName.substring(0, point);
        }
        return objectName;
    }

    public static String parseSlaveName(String simpleObjectName) {
        String[] tmp = StringUtils.split(simpleObjectName, ".");
        if (tmp.length > 2) {
            return String.format("%s.%s", tmp[0], tmp[1]);
        }
        return simpleObjectName;
    }

    public static boolean hasServerNode(String objectName) {
        int point = objectName.indexOf("@");
        return point != -1;
    }

    public static List<Url> parse(ServantProxyConfig conf) {
        String[] items;
        String name = conf.getSimpleObjectName();
        String serverNode = conf.getObjectName();
        int point = serverNode.indexOf("@");
        String services = serverNode.substring(point + 1);
        ArrayList<Url> list = new ArrayList<Url>();
        for (String item : items = services.split(":")) {
            list.add(ParseTools.parse(name, item, conf));
        }
        return list;
    }

    public static String parse(List<EndpointF> list, String objName) {
        StringBuilder value = new StringBuilder();
        for (EndpointF endpointF : list) {
            if (value.length() > 0) {
                value.append(":");
            }
            value.append(ParseTools.toFormatString(endpointF, true));
        }
        if (value.length() < 1) {
            return null;
        }
        value.insert(0, "@");
        value.insert(0, objName);
        return value.toString();
    }

    public static String toFormatString(EndpointF endpointF, boolean active) {
        StringBuilder value = new StringBuilder();
        if (!StringUtils.isEmpty(endpointF.host) && endpointF.port > 0) {
            value.append(endpointF.istcp == 0 ? "udp" : "tcp").append(" ");
            value.append("-h").append(" ").append(endpointF.host).append(" ");
            value.append("-p").append(" ").append(endpointF.port).append(" ");
            value.append("-t").append(" 3000 ");
            value.append("-a").append(" ").append(active ? "1" : "0").append(" ");
            value.append("-g").append(" ").append(endpointF.grid).append(" ");
            if (endpointF.setId != null && endpointF.setId.length() > 0) {
                value.append(" ").append("-s").append(" ").append(endpointF.setId);
            }
            if (endpointF.weightType != 0) {
                value.append(" ").append("-v").append(" ").append(endpointF.weightType);
                value.append(" ").append("-w").append(" ").append(endpointF.weight);
            }
        }
        return value.toString();
    }

    private static Url parse(String objectName, String content, ServantProxyConfig conf) {
        content = content.toLowerCase();
        int point = content.indexOf("  ");
        while (point > -1) {
            content = StringUtils.replaceAll(content, "  ", " ");
            point = content.indexOf("  ");
        }
        String[] items = StringUtils.split(content, " ");
        if (items.length < 5) {
            throw new ClientException(objectName, "error occurred on parse url|endpoint=" + content);
        }
        String host = null;
        int port = 0;
        int active = 1;
        String setDivision = null;
        String enableAuth = "0";
        int weightType = 0;
        int weight = 0;
        block19: for (int i = 0; i < items.length; ++i) {
            switch (items[i]) {
                case "-h": {
                    host = items[i + 1];
                    continue block19;
                }
                case "-p": {
                    port = Integer.parseInt(items[i + 1]);
                    continue block19;
                }
                case "-a": {
                    active = Integer.parseInt(items[i + 1]);
                    continue block19;
                }
                case "-s": {
                    setDivision = items[i + 1];
                    continue block19;
                }
                case "-e": {
                    enableAuth = items[i + 1];
                    continue block19;
                }
                case "-v": {
                    weightType = Integer.parseInt(items[i + 1]);
                    continue block19;
                }
                case "-w": {
                    weight = Integer.parseInt(items[i + 1]);
                }
            }
        }
        if (StringUtils.isEmpty(host) || port == -1) {
            throw new ClientException(objectName, "error occurred on parse url|endpoint=" + content);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("connections", String.valueOf(conf.getConnections()));
        parameters.put("active", Boolean.toString(active == 1));
        parameters.put("setDivision", setDivision);
        parameters.put("connectTimeout", String.valueOf(conf.getConnectTimeout()));
        parameters.put("syncTimeout", String.valueOf(conf.getSyncTimeout()));
        parameters.put("asyncTimeout", String.valueOf(conf.getAsyncTimeout()));
        parameters.put("udpMode", Boolean.toString(items[0].toLowerCase().equals("udp")));
        parameters.put("tcpNoDelay", Boolean.toString(conf.isTcpNoDelay()));
        parameters.put("charsetName", conf.getCharsetName());
        parameters.put("enableAuth", enableAuth);
        parameters.put("weightType", String.valueOf(weightType));
        parameters.put("weight", String.valueOf(weight));
        return new Url(conf.getProtocol(), host, port, objectName, parameters);
    }
}

