/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.tmq;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.tmq.TMQConstants;
import com.taosdata.jdbc.tmq.TaosConsumer;
import com.taosdata.jdbc.utils.StringUtils;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class TMQConnector
extends TSDBJNIConnector {
    private String createConsumerErrorMsg;
    private String[] topics;

    public long createConfig(Properties properties) throws SQLException {
        long conf = this.tmqConfNewImp();
        if (null == properties || properties.size() < 1) {
            return conf;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (StringUtils.isEmpty(key) || !TMQConstants.configSet.contains(key)) continue;
            int code = this.tmqConfSetImp(conf, key, String.valueOf(entry.getValue()));
            if (code == -101) {
                this.tmqConfDestroyImp(conf);
                throw TSDBError.createSQLException(code, "Failed to set tmq property. key is null");
            }
            if (code == -102) {
                this.tmqConfDestroyImp(conf);
                throw TSDBError.createSQLException(code, "Failed to set tmq property : " + key + ". value is null");
            }
            if (code >= 0) continue;
            this.tmqConfDestroyImp(conf);
            throw TSDBError.createSQLException(code, "Failed to set consumer config property : " + key + ". reason: " + this.getErrMsg(code));
        }
        return conf;
    }

    private native long tmqConfNewImp();

    private native int tmqConfSetImp(long var1, String var3, String var4);

    public void destroyConf(long conf) {
        this.tmqConfDestroyImp(conf);
    }

    private native void tmqConfDestroyImp(long var1);

    public void createConsumer(long conf) throws SQLException {
        this.taos = this.tmqConsumerNewImp(conf, this);
        if (this.taos == -100L) {
            throw TSDBError.createSQLException(-100, "consumer config reference has been destroyed");
        }
        if (this.taos < 0L) {
            throw TSDBError.createSQLException(-121, this.createConsumerErrorMsg);
        }
    }

    private native long tmqConsumerNewImp(long var1, TMQConnector var3);

    void setCreateConsumerErrorMsg(String msg) {
        this.createConsumerErrorMsg = msg;
    }

    public long createTopic(Collection<String> topics) throws SQLException {
        long topic = this.tmqTopicNewImp(this.taos);
        if (topic < 0L) {
            throw TSDBError.createSQLException(-120, "Failed to create tmq topic, consumer reference is null");
        }
        if (null != topics && topics.size() > 0) {
            for (String name : topics) {
                int code = this.tmqTopicAppendImp(topic, name);
                if (code == -110) {
                    this.destroyTopic(topic);
                    throw TSDBError.createSQLException(-110, "Failed to set consumer topic");
                }
                if (code == -111) {
                    this.destroyTopic(topic);
                    throw TSDBError.createSQLException(-111, "Failed to set consumer topic, topic name is empty");
                }
                if (code == 0) continue;
                this.destroyTopic(topic);
                throw TSDBError.createSQLException(-999, "Failed to set consumer topic.");
            }
        }
        return topic;
    }

    private native long tmqTopicNewImp(long var1);

    private native int tmqTopicAppendImp(long var1, String var3);

    public void destroyTopic(long topic) {
        this.tmqTopicDestroyImp(topic);
    }

    private native void tmqTopicDestroyImp(long var1);

    public void subscribe(long topic) throws SQLException {
        int code = this.tmqSubscribeImp(this.taos, topic);
        if (code == -120) {
            throw TSDBError.createSQLException(-120, "consumer reference has been destroyed");
        }
        if (code == -110) {
            throw TSDBError.createSQLException(-110, "topic reference has been destroyed");
        }
        if (code != 0) {
            throw TSDBError.createSQLException(code, this.getErrMsg(code));
        }
    }

    private native int tmqSubscribeImp(long var1, long var3);

    public Set<String> subscription() throws SQLException {
        int code = this.tmqSubscriptionImp(this.taos, this);
        if (code == -120) {
            throw TSDBError.createSQLException(-120, "consumer reference has been destroyed");
        }
        if (code != 0) {
            throw TSDBError.createSQLException(code, this.getErrMsg(code));
        }
        return Arrays.stream(this.topics).collect(Collectors.toSet());
    }

    private native int tmqSubscriptionImp(long var1, TMQConnector var3);

    public void setTopicList(String[] topics) {
        this.topics = topics;
    }

    public void syncCommit(long offsets) throws SQLException {
        int code = this.tmqCommitSync(this.taos, offsets);
        if (code == -120) {
            throw TSDBError.createSQLException(-120, "consumer reference has been destroyed");
        }
        if (code != 0) {
            throw TSDBError.createSQLException(code, this.createConsumerErrorMsg);
        }
    }

    private native int tmqCommitSync(long var1, long var3);

    public void asyncCommit(long offsets, TaosConsumer consumer) {
        this.tmqCommitAsync(this.taos, offsets, consumer);
    }

    private native void tmqCommitAsync(long var1, long var3, TaosConsumer var5);

    public void unsubscribe() throws SQLException {
        int code = this.tmqUnsubscribeImp(this.taos);
        if (code == -120) {
            throw TSDBError.createSQLException(-120, "consumer reference has been destroyed");
        }
        if (code != 0) {
            throw TSDBError.createSQLException(code, this.getErrMsg(code));
        }
    }

    private native int tmqUnsubscribeImp(long var1);

    public void closeConsumer() throws SQLException {
        int code = this.tmqConsumerCloseImp(this.taos);
        if (code != 0 && code != -120) {
            throw TSDBError.createSQLException(code, this.getErrMsgImp(code));
        }
    }

    private native int tmqConsumerCloseImp(long var1);

    public String getErrMsg(int code) {
        return this.getErrMsgImp(code);
    }

    private native String getErrMsgImp(int var1);

    public long poll(long waitTime) {
        return this.tmqConsumerPoll(this.taos, waitTime);
    }

    private native long tmqConsumerPoll(long var1, long var3);

    public String getTopicName(long res) {
        return this.tmqGetTopicName(res);
    }

    private native String tmqGetTopicName(long var1);

    public String getDbName(long res) {
        return this.tmqGetDbName(res);
    }

    private native String tmqGetDbName(long var1);

    public int getVgroupId(long res) {
        return this.tmqGetVgroupId(res);
    }

    private native int tmqGetVgroupId(long var1);

    public String getTableName(long res) {
        return this.tmqGetTableName(res);
    }

    private native String tmqGetTableName(long var1);

    public int fetchBlock(long resultSet, TSDBResultSetBlockData blockData, List<ColumnMetaData> columnMetaData) {
        int ret = this.fetchRawBlockImp(this.taos, resultSet, blockData, columnMetaData);
        columnMetaData.forEach(column -> column.setColIndex(column.getColIndex() + 1));
        return ret;
    }

    private native int fetchRawBlockImp(long var1, long var3, TSDBResultSetBlockData var5, List<ColumnMetaData> var6);
}

