/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.databinding.DatabindingConfig;
import com.sun.xml.ws.api.databinding.DatabindingFactory;
import com.sun.xml.ws.api.databinding.WSDLGenInfo;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.policy.PolicyResolver;
import com.sun.xml.ws.api.policy.PolicyResolverFactory;
import com.sun.xml.ws.api.server.AsyncProvider;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.ContainerResolver;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.api.wsdl.parser.XMLEntityResolver;
import com.sun.xml.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.db.DatabindingImpl;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.model.SOAPSEIModel;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.jaxws.PolicyUtil;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.EndpointAwareTube;
import com.sun.xml.ws.server.SDDocumentImpl;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import com.sun.xml.ws.server.WSDLGenResolver;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.server.provider.ProviderInvokerTube;
import com.sun.xml.ws.server.sei.SEIInvokerTube;
import com.sun.xml.ws.util.HandlerAnnotationInfo;
import com.sun.xml.ws.util.HandlerAnnotationProcessor;
import com.sun.xml.ws.util.ServiceConfigurationError;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class EndpointFactory {
    private static final EndpointFactory instance = new EndpointFactory();
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.server.endpoint");

    public static EndpointFactory getInstance() {
        return instance;
    }

    public static <T> WSEndpoint<T> createEndpoint(Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, EntityResolver resolver, boolean isTransportSynchronous) {
        return EndpointFactory.createEndpoint(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, isTransportSynchronous, true);
    }

    public static <T> WSEndpoint<T> createEndpoint(Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, EntityResolver resolver, boolean isTransportSynchronous, boolean isStandard) {
        EndpointFactory factory;
        EndpointFactory endpointFactory = factory = container != null ? container.getSPI(EndpointFactory.class) : null;
        if (factory == null) {
            factory = EndpointFactory.getInstance();
        }
        return factory.create(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, isTransportSynchronous, isStandard);
    }

    public <T> WSEndpoint<T> create(Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, EntityResolver resolver, boolean isTransportSynchronous) {
        return this.create(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, isTransportSynchronous, true);
    }

    public <T> WSEndpoint<T> create(Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, EntityResolver resolver, boolean isTransportSynchronous, boolean isStandard) {
        EndpointAwareTube terminal;
        String portNS;
        String serviceNS;
        if (implType == null) {
            throw new IllegalArgumentException();
        }
        if (isStandard) {
            EndpointFactory.verifyImplementorClass(implType);
        }
        if (invoker == null) {
            invoker = InstanceResolver.createDefault(implType).createInvoker();
        }
        ArrayList<SDDocumentSource> md = new ArrayList<SDDocumentSource>();
        if (metadata != null) {
            md.addAll(metadata);
        }
        if (primaryWsdl != null && !md.contains(primaryWsdl)) {
            md.add(primaryWsdl);
        }
        if (container == null) {
            container = ContainerResolver.getInstance().getContainer();
        }
        if (serviceName == null) {
            serviceName = EndpointFactory.getDefaultServiceName(implType);
        }
        if (portName == null) {
            portName = EndpointFactory.getDefaultPortName(serviceName, implType);
        }
        if (!(serviceNS = serviceName.getNamespaceURI()).equals(portNS = portName.getNamespaceURI())) {
            throw new ServerRtException("wrong.tns.for.port", portNS, serviceNS);
        }
        if (binding == null) {
            binding = BindingImpl.create(BindingID.parse(implType));
        }
        if (isStandard && primaryWsdl != null) {
            EndpointFactory.verifyPrimaryWSDL(primaryWsdl, serviceName);
        }
        QName portTypeName = null;
        if (isStandard && implType.getAnnotation(WebServiceProvider.class) == null) {
            portTypeName = RuntimeModeler.getPortTypeName(implType);
        }
        List<SDDocumentImpl> docList = EndpointFactory.categoriseMetadata(md, serviceName, portTypeName);
        SDDocumentImpl primaryDoc = EndpointFactory.findPrimary(docList);
        WSDLPortImpl wsdlPort = null;
        AbstractSEIModelImpl seiModel = null;
        if (primaryDoc != null) {
            wsdlPort = EndpointFactory.getWSDLPort(primaryDoc, docList, serviceName, portName, container);
        }
        WebServiceFeatureList features = ((BindingImpl)binding).getFeatures();
        if (isStandard) {
            features.parseAnnotations(implType);
        }
        PolicyMap policyMap = null;
        if (this.isUseProviderTube(implType, isStandard)) {
            Iterable<WebServiceFeature> configFtrs;
            if (wsdlPort != null) {
                policyMap = wsdlPort.getOwner().getParent().getPolicyMap();
                configFtrs = wsdlPort.getFeatures();
            } else {
                policyMap = PolicyResolverFactory.create().resolve(new PolicyResolver.ServerContext(null, container, implType, false, new PolicyMapMutator[0]));
                configFtrs = PolicyUtil.getPortScopedFeatures(policyMap, serviceName, portName);
            }
            features.mergeFeatures(configFtrs, true);
            terminal = this.createProviderInvokerTube(implType, binding, invoker);
        } else {
            seiModel = EndpointFactory.createSEIModel(wsdlPort, implType, serviceName, portName, binding);
            if (binding instanceof SOAPBindingImpl) {
                ((SOAPBindingImpl)binding).setPortKnownHeaders(((SOAPSEIModel)seiModel).getKnownHeaders());
            }
            if (primaryDoc == null) {
                primaryDoc = EndpointFactory.generateWSDL(binding, seiModel, docList, container, implType);
                wsdlPort = EndpointFactory.getWSDLPort(primaryDoc, docList, serviceName, portName, container);
                seiModel.freeze(wsdlPort);
            }
            policyMap = wsdlPort.getOwner().getParent().getPolicyMap();
            features.mergeFeatures(wsdlPort.getFeatures(), true);
            terminal = this.createSEIInvokerTube(seiModel, invoker, binding);
        }
        if (processHandlerAnnotation) {
            EndpointFactory.processHandlerAnnotation(binding, implType, serviceName, portName);
        }
        if (primaryDoc != null) {
            docList = EndpointFactory.findMetadataClosure(primaryDoc, docList);
        }
        ServiceDefinitionImpl serviceDefiniton = primaryDoc != null ? new ServiceDefinitionImpl(docList, primaryDoc) : null;
        return this.create(serviceName, portName, binding, container, seiModel, wsdlPort, implType, serviceDefiniton, terminal, isTransportSynchronous, policyMap);
    }

    protected <T> WSEndpoint<T> create(QName serviceName, QName portName, WSBinding binding, Container container, SEIModel seiModel, WSDLPort wsdlPort, Class<T> implType, ServiceDefinitionImpl serviceDefinition, EndpointAwareTube terminal, boolean isTransportSynchronous, PolicyMap policyMap) {
        return new WSEndpointImpl<T>(serviceName, portName, binding, container, seiModel, wsdlPort, implType, serviceDefinition, terminal, isTransportSynchronous, policyMap);
    }

    protected boolean isUseProviderTube(Class<?> implType, boolean isStandard) {
        return !isStandard || implType.getAnnotation(WebServiceProvider.class) != null;
    }

    protected EndpointAwareTube createSEIInvokerTube(AbstractSEIModelImpl seiModel, Invoker invoker, WSBinding binding) {
        return new SEIInvokerTube(seiModel, invoker, binding);
    }

    protected <T> EndpointAwareTube createProviderInvokerTube(Class<T> implType, WSBinding binding, Invoker invoker) {
        return ProviderInvokerTube.create(implType, binding, invoker);
    }

    private static List<SDDocumentImpl> findMetadataClosure(SDDocumentImpl primaryDoc, List<SDDocumentImpl> docList) {
        HashMap<String, SDDocumentImpl> oldMap = new HashMap<String, SDDocumentImpl>();
        for (SDDocumentImpl doc : docList) {
            oldMap.put(doc.getSystemId().toString(), doc);
        }
        HashMap<String, SDDocumentImpl> newMap = new HashMap<String, SDDocumentImpl>();
        newMap.put(primaryDoc.getSystemId().toString(), primaryDoc);
        ArrayList<String> remaining = new ArrayList<String>();
        remaining.addAll(primaryDoc.getImports());
        while (!remaining.isEmpty()) {
            String url = (String)remaining.remove(0);
            SDDocumentImpl doc = (SDDocumentImpl)oldMap.get(url);
            if (doc == null || newMap.containsKey(url)) continue;
            newMap.put(url, doc);
            remaining.addAll(doc.getImports());
        }
        ArrayList<SDDocumentImpl> newMetadata = new ArrayList<SDDocumentImpl>();
        newMetadata.addAll(newMap.values());
        return newMetadata;
    }

    private static <T> void processHandlerAnnotation(WSBinding binding, Class<T> implType, QName serviceName, QName portName) {
        HandlerAnnotationInfo chainInfo = HandlerAnnotationProcessor.buildHandlerInfo(implType, serviceName, portName, binding);
        if (chainInfo != null) {
            binding.setHandlerChain(chainInfo.getHandlers());
            if (binding instanceof SOAPBinding) {
                ((SOAPBinding)binding).setRoles(chainInfo.getRoles());
            }
        }
    }

    public static boolean verifyImplementorClass(Class<?> clz) {
        WebServiceProvider wsProvider = clz.getAnnotation(WebServiceProvider.class);
        WebService ws = clz.getAnnotation(WebService.class);
        if (wsProvider == null && ws == null) {
            throw new IllegalArgumentException(clz + " has neither @WebService nor @WebServiceProvider annotation");
        }
        if (wsProvider != null && ws != null) {
            throw new IllegalArgumentException(clz + " has both @WebService and @WebServiceProvider annotations");
        }
        if (wsProvider != null) {
            if (Provider.class.isAssignableFrom(clz) || AsyncProvider.class.isAssignableFrom(clz)) {
                return true;
            }
            throw new IllegalArgumentException(clz + " doesn't implement Provider or AsyncProvider interface");
        }
        return false;
    }

    private static AbstractSEIModelImpl createSEIModel(WSDLPort wsdlPort, Class<?> implType, @NotNull QName serviceName, @NotNull QName portName, WSBinding binding) {
        DatabindingFactory fac = DatabindingFactory.newInstance();
        DatabindingConfig config = new DatabindingConfig();
        config.setEndpointClass(implType);
        config.getMappingInfo().setServiceName(serviceName);
        config.setWsdlPort(wsdlPort);
        config.setWSBinding(binding);
        config.setClassLoader(implType.getClassLoader());
        config.getMappingInfo().setPortName(portName);
        DatabindingImpl rt = (DatabindingImpl)fac.createRuntime(config);
        return (AbstractSEIModelImpl)rt.getModel();
    }

    @NotNull
    public static QName getDefaultServiceName(Class<?> implType) {
        return EndpointFactory.getDefaultServiceName(implType, true);
    }

    @NotNull
    public static QName getDefaultServiceName(Class<?> implType, boolean isStandard) {
        QName serviceName;
        WebServiceProvider wsProvider = implType.getAnnotation(WebServiceProvider.class);
        if (wsProvider != null) {
            String tns = wsProvider.targetNamespace();
            String local = wsProvider.serviceName();
            serviceName = new QName(tns, local);
        } else {
            serviceName = RuntimeModeler.getServiceName(implType, isStandard);
        }
        assert (serviceName != null);
        return serviceName;
    }

    @NotNull
    public static QName getDefaultPortName(QName serviceName, Class<?> implType) {
        return EndpointFactory.getDefaultPortName(serviceName, implType, true);
    }

    @NotNull
    public static QName getDefaultPortName(QName serviceName, Class<?> implType, boolean isStandard) {
        QName portName;
        WebServiceProvider wsProvider = implType.getAnnotation(WebServiceProvider.class);
        if (wsProvider != null) {
            String tns = wsProvider.targetNamespace();
            String local = wsProvider.portName();
            portName = new QName(tns, local);
        } else {
            portName = RuntimeModeler.getPortName(implType, serviceName.getNamespaceURI(), isStandard);
        }
        assert (portName != null);
        return portName;
    }

    @Nullable
    public static String getWsdlLocation(Class<?> implType) {
        String wsdl;
        WebService ws = implType.getAnnotation(WebService.class);
        if (ws != null) {
            wsdl = ws.wsdlLocation();
        } else {
            WebServiceProvider wsProvider = implType.getAnnotation(WebServiceProvider.class);
            assert (wsProvider != null);
            wsdl = wsProvider.wsdlLocation();
        }
        if (wsdl.length() < 1) {
            wsdl = null;
        }
        return wsdl;
    }

    private static SDDocumentImpl generateWSDL(WSBinding binding, AbstractSEIModelImpl seiModel, List<SDDocumentImpl> docs, Container container, Class implType) {
        BindingID bindingId = binding.getBindingId();
        if (!bindingId.canGenerateWSDL()) {
            throw new ServerRtException("can.not.generate.wsdl", bindingId);
        }
        if (bindingId.toString().equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/")) {
            String msg = ServerMessages.GENERATE_NON_STANDARD_WSDL();
            logger.warning(msg);
        }
        WSDLGenResolver wsdlResolver = new WSDLGenResolver(docs, seiModel.getServiceQName(), seiModel.getPortTypeName());
        WSDLGenInfo wsdlGenInfo = new WSDLGenInfo();
        wsdlGenInfo.setWsdlResolver(wsdlResolver);
        wsdlGenInfo.setContainer(container);
        wsdlGenInfo.setExtensions(ServiceFinder.find(WSDLGeneratorExtension.class).toArray());
        wsdlGenInfo.setInlineSchemas(false);
        seiModel.getDatabinding().generateWSDL(wsdlGenInfo);
        return wsdlResolver.updateDocs();
    }

    private static List<SDDocumentImpl> categoriseMetadata(List<SDDocumentSource> src, QName serviceName, QName portTypeName) {
        ArrayList<SDDocumentImpl> r = new ArrayList<SDDocumentImpl>(src.size());
        for (SDDocumentSource doc : src) {
            r.add(SDDocumentImpl.create(doc, serviceName, portTypeName));
        }
        return r;
    }

    private static void verifyPrimaryWSDL(@NotNull SDDocumentSource primaryWsdl, @NotNull QName serviceName) {
        SDDocumentImpl primaryDoc = SDDocumentImpl.create(primaryWsdl, serviceName, null);
        if (!(primaryDoc instanceof SDDocument.WSDL)) {
            throw new WebServiceException(primaryWsdl.getSystemId() + " is not a WSDL. But it is passed as a primary WSDL");
        }
        SDDocument.WSDL wsdlDoc = (SDDocument.WSDL)((Object)primaryDoc);
        if (!wsdlDoc.hasService()) {
            if (wsdlDoc.getAllServices().isEmpty()) {
                throw new WebServiceException("Not a primary WSDL=" + primaryWsdl.getSystemId() + " since it doesn't have Service " + serviceName);
            }
            throw new WebServiceException("WSDL " + primaryDoc.getSystemId() + " has the following services " + wsdlDoc.getAllServices() + " but not " + serviceName + ". Maybe you forgot to specify a serviceName and/or targetNamespace in @WebService/@WebServiceProvider?");
        }
    }

    @Nullable
    private static SDDocumentImpl findPrimary(@NotNull List<SDDocumentImpl> docList) {
        SDDocumentImpl primaryDoc = null;
        boolean foundConcrete = false;
        boolean foundAbstract = false;
        for (SDDocumentImpl doc : docList) {
            if (!(doc instanceof SDDocument.WSDL)) continue;
            SDDocument.WSDL wsdlDoc = (SDDocument.WSDL)((Object)doc);
            if (wsdlDoc.hasService()) {
                primaryDoc = doc;
                if (foundConcrete) {
                    throw new ServerRtException("duplicate.primary.wsdl", doc.getSystemId());
                }
                foundConcrete = true;
            }
            if (!wsdlDoc.hasPortType()) continue;
            if (foundAbstract) {
                throw new ServerRtException("duplicate.abstract.wsdl", doc.getSystemId());
            }
            foundAbstract = true;
        }
        return primaryDoc;
    }

    @NotNull
    private static WSDLPortImpl getWSDLPort(SDDocumentSource primaryWsdl, List<? extends SDDocumentSource> metadata, @NotNull QName serviceName, @NotNull QName portName, Container container) {
        URL wsdlUrl = primaryWsdl.getSystemId();
        try {
            WSDLModelImpl wsdlDoc = RuntimeWSDLParser.parse(new XMLEntityResolver.Parser(primaryWsdl), (XMLEntityResolver)new EntityResolverImpl(metadata), false, container, ServiceFinder.find(WSDLParserExtension.class).toArray());
            if (wsdlDoc.getServices().size() == 0) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_NOSERVICE_IN_WSDLMODEL(wsdlUrl));
            }
            WSDLServiceImpl wsdlService = wsdlDoc.getService(serviceName);
            if (wsdlService == null) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_INCORRECTSERVICE(serviceName, wsdlUrl));
            }
            WSDLPortImpl wsdlPort = wsdlService.get(portName);
            if (wsdlPort == null) {
                throw new ServerRtException(ServerMessages.localizableRUNTIME_PARSER_WSDL_INCORRECTSERVICEPORT(serviceName, portName, wsdlUrl));
            }
            return wsdlPort;
        }
        catch (IOException e) {
            throw new ServerRtException("runtime.parser.wsdl", wsdlUrl, e);
        }
        catch (XMLStreamException e) {
            throw new ServerRtException("runtime.saxparser.exception", e.getMessage(), e.getLocation(), e);
        }
        catch (SAXException e) {
            throw new ServerRtException("runtime.parser.wsdl", wsdlUrl, e);
        }
        catch (ServiceConfigurationError e) {
            throw new ServerRtException("runtime.parser.wsdl", wsdlUrl, e);
        }
    }

    private static final class EntityResolverImpl
    implements XMLEntityResolver {
        private Map<String, SDDocumentSource> metadata = new HashMap<String, SDDocumentSource>();

        public EntityResolverImpl(List<? extends SDDocumentSource> metadata) {
            for (SDDocumentSource sDDocumentSource : metadata) {
                this.metadata.put(sDDocumentSource.getSystemId().toExternalForm(), sDDocumentSource);
            }
        }

        @Override
        public XMLEntityResolver.Parser resolveEntity(String publicId, String systemId) throws IOException, XMLStreamException {
            SDDocumentSource doc;
            if (systemId != null && (doc = this.metadata.get(systemId)) != null) {
                return new XMLEntityResolver.Parser(doc);
            }
            return null;
        }
    }
}

