/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model.wsdl;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.ParameterBinding;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLMessage;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLPortType;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLMessageImpl;
import com.sun.xml.ws.model.wsdl.WSDLPartImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WSDLModelImpl
extends AbstractExtensibleImpl
implements WSDLModel {
    private final Map<QName, WSDLMessageImpl> messages = new HashMap<QName, WSDLMessageImpl>();
    private final Map<QName, WSDLPortTypeImpl> portTypes = new HashMap<QName, WSDLPortTypeImpl>();
    private final Map<QName, WSDLBoundPortTypeImpl> bindings = new HashMap<QName, WSDLBoundPortTypeImpl>();
    private final Map<QName, WSDLServiceImpl> services = new LinkedHashMap<QName, WSDLServiceImpl>();
    private final Map<QName, WSDLBoundPortType> unmBindings = Collections.unmodifiableMap(this.bindings);

    public WSDLModelImpl(@NotNull String systemId) {
        super(systemId, -1);
    }

    public WSDLModelImpl() {
        super(null, -1);
    }

    public void addMessage(WSDLMessageImpl msg) {
        this.messages.put(msg.getName(), msg);
    }

    public WSDLMessageImpl getMessage(QName name) {
        return this.messages.get(name);
    }

    public void addPortType(WSDLPortTypeImpl pt) {
        this.portTypes.put(pt.getName(), pt);
    }

    @Override
    public WSDLPortTypeImpl getPortType(QName name) {
        return this.portTypes.get(name);
    }

    public void addBinding(WSDLBoundPortTypeImpl boundPortType) {
        assert (!this.bindings.containsValue(boundPortType));
        this.bindings.put(boundPortType.getName(), boundPortType);
    }

    @Override
    public WSDLBoundPortTypeImpl getBinding(QName name) {
        return this.bindings.get(name);
    }

    public void addService(WSDLServiceImpl svc) {
        this.services.put(svc.getName(), svc);
    }

    @Override
    public WSDLServiceImpl getService(QName name) {
        return this.services.get(name);
    }

    public Map<QName, WSDLMessageImpl> getMessages() {
        return this.messages;
    }

    @NotNull
    public Map<QName, WSDLPortTypeImpl> getPortTypes() {
        return this.portTypes;
    }

    @Override
    @NotNull
    public Map<QName, WSDLBoundPortType> getBindings() {
        return this.unmBindings;
    }

    @NotNull
    public Map<QName, WSDLServiceImpl> getServices() {
        return this.services;
    }

    public QName getFirstServiceName() {
        if (this.services.isEmpty()) {
            return null;
        }
        return this.services.values().iterator().next().getName();
    }

    public QName getFirstPortName() {
        WSDLPort fp = this.getFirstPort();
        if (fp == null) {
            return null;
        }
        return fp.getName();
    }

    private WSDLPort getFirstPort() {
        if (this.services.isEmpty()) {
            return null;
        }
        WSDLService service = this.services.values().iterator().next();
        Iterator<? extends WSDLPort> iter = service.getPorts().iterator();
        WSDLPort port = iter.hasNext() ? iter.next() : null;
        return port;
    }

    public WSDLPortImpl getMatchingPort(QName serviceName, QName portType) {
        return this.getService(serviceName).getMatchingPort(portType);
    }

    @Override
    public WSDLBoundPortTypeImpl getBinding(QName serviceName, QName portName) {
        WSDLPortImpl port;
        WSDLServiceImpl service = this.services.get(serviceName);
        if (service != null && (port = service.get(portName)) != null) {
            return port.getBinding();
        }
        return null;
    }

    void finalizeRpcLitBinding(WSDLBoundPortTypeImpl boundPortType) {
        assert (boundPortType != null);
        QName portTypeName = boundPortType.getPortTypeName();
        if (portTypeName == null) {
            return;
        }
        WSDLPortType pt = this.portTypes.get(portTypeName);
        if (pt == null) {
            return;
        }
        for (WSDLBoundOperationImpl bop : boundPortType.getBindingOperations()) {
            WSDLMessageImpl outMsg;
            WSDLMessage outMsgName;
            WSDLOperation pto = pt.get(bop.getName().getLocalPart());
            WSDLMessage inMsgName = pto.getInput().getMessage();
            if (inMsgName == null) continue;
            WSDLMessageImpl inMsg = this.messages.get(inMsgName.getName());
            int bodyindex = 0;
            if (inMsg != null) {
                for (WSDLPartImpl part : inMsg.parts()) {
                    String name = part.getName();
                    ParameterBinding pb = bop.getInputBinding(name);
                    if (!pb.isBody()) continue;
                    part.setIndex(bodyindex++);
                    part.setBinding(pb);
                    bop.addPart(part, WebParam.Mode.IN);
                }
            }
            bodyindex = 0;
            if (pto.isOneWay() || (outMsgName = pto.getOutput().getMessage()) == null || (outMsg = this.messages.get(outMsgName.getName())) == null) continue;
            for (WSDLPartImpl part : outMsg.parts()) {
                String name = part.getName();
                ParameterBinding pb = bop.getOutputBinding(name);
                if (!pb.isBody()) continue;
                part.setIndex(bodyindex++);
                part.setBinding(pb);
                bop.addPart(part, WebParam.Mode.OUT);
            }
        }
    }

    public void freeze() {
        for (WSDLServiceImpl service : this.services.values()) {
            service.freeze(this);
        }
        for (WSDLBoundPortTypeImpl bp : this.bindings.values()) {
            bp.freeze();
        }
    }
}

