/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.http.authc;

import com.stormpath.sdk.client.ApiKey;
import com.stormpath.sdk.impl.http.Request;
import com.stormpath.sdk.impl.http.authc.RequestAuthenticator;
import com.stormpath.sdk.impl.http.support.RequestAuthenticationException;
import com.stormpath.sdk.impl.util.Base64;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRequestAuthenticator
implements RequestAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(BasicRequestAuthenticator.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String STORMPATH_DATE_HEADER = "X-Stormpath-Date";
    public static final String AUTHENTICATION_SCHEME = "Basic";
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd'T'HHmmss'Z'";
    public static final String TIME_ZONE = "UTC";
    private static final String NL = "\n";

    @Override
    public void authenticate(Request request, ApiKey apiKey) throws RequestAuthenticationException {
        byte[] valueBytes;
        Date date = new Date();
        SimpleDateFormat timestampFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
        timestampFormat.setTimeZone(new SimpleTimeZone(0, TIME_ZONE));
        String timestamp = timestampFormat.format(date);
        request.getHeaders().set(STORMPATH_DATE_HEADER, timestamp);
        String authorizationHeader = apiKey.getId() + ":" + apiKey.getSecret();
        try {
            valueBytes = authorizationHeader.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RequestAuthenticationException("Unable to acquire UTF-8 bytes!");
        }
        authorizationHeader = Base64.encodeToString(valueBytes, false);
        request.getHeaders().set(AUTHORIZATION_HEADER, "Basic " + authorizationHeader);
    }
}

