/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.cache;

import com.stormpath.sdk.cache.Cache;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.impl.cache.CacheConfiguration;
import com.stormpath.sdk.impl.cache.DefaultCache;
import com.stormpath.sdk.impl.util.Duration;
import com.stormpath.sdk.impl.util.SoftHashMap;
import com.stormpath.sdk.lang.Assert;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class DefaultCacheManager
implements CacheManager {
    protected final ConcurrentMap<String, CacheConfiguration> configs = new ConcurrentHashMap<String, CacheConfiguration>();
    protected final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private volatile Duration defaultTimeToLive;
    private volatile Duration defaultTimeToIdle;

    public Duration getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    public void setDefaultTimeToLive(Duration defaultTimeToLive) {
        DefaultCache.assertTtl(defaultTimeToLive);
        this.defaultTimeToLive = defaultTimeToLive;
    }

    public void setDefaultTimeToLiveSeconds(long seconds) {
        this.setDefaultTimeToLive(new Duration(seconds, TimeUnit.SECONDS));
    }

    public Duration getDefaultTimeToIdle() {
        return this.defaultTimeToIdle;
    }

    public void setDefaultTimeToIdle(Duration defaultTimeToIdle) {
        DefaultCache.assertTti(defaultTimeToIdle);
        this.defaultTimeToIdle = defaultTimeToIdle;
    }

    public void setDefaultTimeToIdleSeconds(long seconds) {
        this.setDefaultTimeToIdle(new Duration(seconds, TimeUnit.SECONDS));
    }

    public void setCacheConfigurations(Collection<CacheConfiguration> configs) {
        Assert.notNull((Object)"Argument cannot be null.  To remove all configuration, set an empty collection.");
        this.configs.clear();
        for (CacheConfiguration config : configs) {
            this.configs.put(config.getName(), config);
        }
    }

    public <K, V> Cache<K, V> getCache(String name) throws IllegalArgumentException {
        Cache existing;
        Assert.hasText((String)name, (String)"Cache name cannot be null or empty.");
        Cache cache = (Cache)this.caches.get(name);
        if (cache == null && (existing = this.caches.putIfAbsent(name, cache = this.createCache(name))) != null) {
            cache = existing;
        }
        return cache;
    }

    protected Cache createCache(String name) {
        Duration ttl = this.defaultTimeToLive != null ? this.defaultTimeToLive.clone() : null;
        Duration tti = this.defaultTimeToIdle != null ? this.defaultTimeToIdle.clone() : null;
        CacheConfiguration config = (CacheConfiguration)this.configs.get(name);
        if (config != null) {
            Duration d = config.getTimeToLive();
            if (d != null) {
                ttl = d;
            }
            if ((d = config.getTimeToIdle()) != null) {
                tti = d;
            }
        }
        return new DefaultCache(name, new SoftHashMap(), ttl, tti);
    }

    public String toString() {
        Collection values = this.caches.values();
        StringBuilder sb = new StringBuilder().append("{\n").append("  \"cacheCount\": ").append(this.caches.size()).append(",\n").append("  \"defaultTimeToLive\": \"").append(this.toString(this.defaultTimeToLive)).append("\",\n").append("  \"defaultTimeToIdle\": \"").append(this.toString(this.defaultTimeToIdle)).append("\",\n").append("  \"caches\": [");
        if (!this.caches.isEmpty()) {
            sb.append("\n");
            int i = 0;
            for (Cache cache : values) {
                if (i > 0) {
                    sb.append(",\n");
                }
                sb.append(cache.toString());
                ++i;
            }
            sb.append("\n  ");
        }
        sb.append("]\n}");
        return sb.toString();
    }

    private String toString(Duration d) {
        return d != null ? d.toString() : "indefinite";
    }
}

