/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.JDBCUniversalConnectionPoolMBeanImpl;
import oracle.ucp.admin.UniversalConnectionPoolMBean;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.admin.UniversalConnectionPoolManagerHelper;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.jdbc.ConnectionConnectionPool;
import oracle.ucp.jdbc.ConnectionLabelingCallback;
import oracle.ucp.jdbc.DataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionPoolStatistics;
import oracle.ucp.jdbc.JDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleDriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatisticsImpl;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolDataSourceImpl
implements PoolDataSource,
Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(PoolDataSourceImpl.class.getCanonicalName());
    final List<AutoProperty> m_autoProperties = new ArrayList<AutoProperty>();
    private final Object m_userLocker = new Object();
    private String m_user = null;
    private final Object m_passwordLocker = new Object();
    private String m_password = null;
    private final Object m_urlLocker = new Object();
    private String m_url = null;
    private final Object m_serverNameLocker = new Object();
    private String m_serverName = null;
    private final Object m_portNumberLocker = new Object();
    private int m_portNumber = 0;
    private final Object m_databaseNameLocker = new Object();
    private String m_databaseName = null;
    private final AutoProperty<String> m_dataSourceName = new AutoProperty<String>(null){
        {
            this.m_err = 52;
        }

        @Override
        void onSet(String value) throws Exception {
            PoolDataSourceImpl.setProperty(PoolDataSourceImpl.this.m_connectionFactory, "dataSourceName", value, true, true);
        }

        @Override
        String onGet() {
            return (String)this.m_value;
        }
    };
    private final AutoProperty<String> m_description = new AutoProperty<String>(null){
        {
            this.m_err = 53;
        }

        @Override
        void onSet(String value) throws Exception {
            PoolDataSourceImpl.setProperty(PoolDataSourceImpl.this.m_connectionFactory, "description", value, true, true);
        }

        @Override
        String onGet() {
            return (String)this.m_value;
        }
    };
    private final AutoProperty<String> m_networkProtocol = new AutoProperty<String>(null){
        {
            this.m_err = 54;
        }

        @Override
        void onSet(String value) throws Exception {
            PoolDataSourceImpl.setProperty(PoolDataSourceImpl.this.m_connectionFactory, "networkProtocol", value, true, true);
        }

        @Override
        String onGet() {
            return (String)this.m_value;
        }
    };
    private final Object m_roleNameLocker = new Object();
    private String m_roleName = null;
    private final Object m_connectionPropertiesLocker = new Object();
    private final Properties m_connectionProperties = new Properties();
    private final Object m_connectionFactoryPropertiesLocker = new Object();
    private final Properties m_connectionFactoryProperties = new Properties();
    protected String m_connectionFactoryClassName = "";
    private boolean m_isDriverFactory = false;
    protected Object m_connectionFactory = null;
    private String m_connectionPoolName = null;
    private final AutoProperty<Boolean> m_validateConnectionOnBorrow = new AutoProperty<Boolean>(Boolean.valueOf(false)){

        @Override
        void onSet(Boolean value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setValidateConnectionOnBorrow(value);
        }

        @Override
        Boolean onGet() {
            return PoolDataSourceImpl.this.m_cp.getValidateConnectionOnBorrow();
        }
    };
    private final AutoProperty<String> m_SQLForValidateConnection = new AutoProperty<String>(null){
        {
            this.m_err = 22;
        }

        @Override
        void onSet(String value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setSQLForValidateConnection(value);
        }

        @Override
        String onGet() {
            return PoolDataSourceImpl.this.m_cp.getSQLForValidateConnection();
        }
    };
    private final AutoProperty<Integer> m_initialPoolSize = new AutoProperty<Integer>(Integer.valueOf(0)){
        {
            this.m_err = 6;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setInitialPoolSize(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getInitialPoolSize();
        }
    };
    private final AutoProperty<Integer> m_minPoolSize = new AutoProperty<Integer>(Integer.valueOf(0)){
        {
            this.m_err = 2;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setMinPoolSize(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getMinPoolSize();
        }
    };
    private final AutoProperty<Integer> m_maxPoolSize = new AutoProperty<Integer>(Integer.valueOf(Integer.MAX_VALUE)){
        {
            this.m_err = 3;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setMaxPoolSize(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getMaxPoolSize();
        }
    };
    private final AutoProperty<Integer> m_abandonedConnectionTimeout = new AutoProperty<Integer>(Integer.valueOf(0)){
        {
            this.m_err = 7;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setAbandonedConnectionTimeout(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getAbandonedConnectionTimeout();
        }
    };
    private final AutoProperty<Integer> m_timeToLiveConnectionTimeout = new AutoProperty<Integer>(Integer.valueOf(0)){
        {
            this.m_err = 6;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setTimeToLiveConnectionTimeout(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getTimeToLiveConnectionTimeout();
        }
    };
    private final AutoProperty<Integer> m_inactiveConnectionTimeout = new AutoProperty<Integer>(Integer.valueOf(0)){
        {
            this.m_err = 4;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setInactiveConnectionTimeout(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getInactiveConnectionTimeout();
        }
    };
    private final AutoProperty<Integer> m_timeoutCheckInterval = new AutoProperty<Integer>(Integer.valueOf(30)){
        {
            this.m_err = 8;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setTimeoutCheckInterval(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getTimeoutCheckInterval();
        }
    };
    private final AutoProperty<Integer> m_maxStatements = new AutoProperty<Integer>(Integer.valueOf(0)){
        {
            this.m_err = 10;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setMaxStatements(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getMaxStatements();
        }

        @Override
        boolean isValid(Integer value) {
            return value >= 0;
        }
    };
    private final AutoProperty<Integer> m_connectionWaitTimeout = new AutoProperty<Integer>(Integer.valueOf(3)){
        {
            this.m_err = 5;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setConnectionWaitTimeout(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getConnectionWaitTimeout();
        }
    };
    private final AutoProperty<Long> m_maxConnectionReuseTime = new AutoProperty<Long>(Long.valueOf(0L)){
        {
            this.m_err = 56;
        }

        @Override
        void onSet(Long value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setMaxConnectionReuseTime(value);
        }

        @Override
        Long onGet() {
            return PoolDataSourceImpl.this.m_cp.getMaxConnectionReuseTime();
        }
    };
    private final AutoProperty<Integer> m_maxConnectionReuseCount = new AutoProperty<Integer>(Integer.valueOf(0)){
        {
            this.m_err = 57;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setMaxConnectionReuseCount(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getMaxConnectionReuseCount();
        }
    };
    private final AutoProperty<oracle.ucp.ConnectionLabelingCallback> m_connectionLabelingCallback = new AutoPropertyX<oracle.ucp.ConnectionLabelingCallback>(null){

        @Override
        void onSet(oracle.ucp.ConnectionLabelingCallback value) throws Exception {
            if (null != value) {
                logger.log(Level.FINEST, "onSet: registering labeling callback");
                this.m_err = 18;
                PoolDataSourceImpl.this.m_cp.registerConnectionLabelingCallback(value);
            } else {
                logger.log(Level.FINEST, "onSet: removing labeling callback");
                this.m_err = 19;
                PoolDataSourceImpl.this.m_cp.removeConnectionLabelingCallback();
            }
        }

        @Override
        oracle.ucp.ConnectionLabelingCallback onGet() {
            logger.log(Level.FINEST, "onGet: obtained labeling callback {0}", this.m_value);
            return (oracle.ucp.ConnectionLabelingCallback)this.m_value;
        }
    };
    private final AutoProperty<ConnectionAffinityCallback> m_connectionAffinityCallback = new AutoPropertyX<ConnectionAffinityCallback>(null){

        @Override
        void onSet(ConnectionAffinityCallback value) throws Exception {
            if (null != value) {
                this.m_err = 20;
                PoolDataSourceImpl.this.m_cp.registerConnectionAffinityCallback(value);
            } else {
                this.m_err = 21;
                PoolDataSourceImpl.this.m_cp.removeConnectionAffinityCallback();
            }
        }
    };
    private final AutoProperty<Integer> m_connectionHarvestTriggerCount = new AutoProperty<Integer>(Integer.valueOf(Integer.MAX_VALUE)){
        {
            this.m_err = 12;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setConnectionHarvestTriggerCount(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getConnectionHarvestTriggerCount();
        }
    };
    private final AutoProperty<Integer> m_connectionHarvestMaxCount = new AutoProperty<Integer>(Integer.valueOf(1)){
        {
            this.m_err = 13;
        }

        @Override
        void onSet(Integer value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setConnectionHarvestMaxCount(value);
        }

        @Override
        Integer onGet() {
            return PoolDataSourceImpl.this.m_cp.getConnectionHarvestMaxCount();
        }
    };
    private DataSource m_dataSource = null;
    private AtomicBoolean m_created = new AtomicBoolean(false);
    private AtomicBoolean m_started = new AtomicBoolean(false);
    protected JDBCConnectionPool m_cp = null;
    private final AutoProperty<Boolean> m_fastConnectionFailoverEnabled = new AutoProperty<Boolean>(Boolean.valueOf(false)){
        {
            this.m_err = 9;
        }

        @Override
        void onSet(Boolean value) throws Exception {
            PoolDataSourceImpl.this.m_cp.setFailoverEnabled(value);
        }

        @Override
        Boolean onGet() {
            return PoolDataSourceImpl.this.m_cp.isFailoverEnabled();
        }
    };
    private final Object m_onsConfigurationStringLocker = new Object();
    private String m_onsConfigurationString = null;
    private UniversalConnectionPoolManagerMBean m_mgrMBean = null;
    private UniversalConnectionPoolManager m_mgr = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPool() throws SQLException {
        AtomicBoolean atomicBoolean = this.m_started;
        synchronized (atomicBoolean) {
            if (!this.m_started.get()) {
                try {
                    if (this.m_cp == null) {
                        this.m_mgr = UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager();
                        if (this.m_mgr.isJmxEnabled()) {
                            if (this.m_mgrMBean == null) {
                                this.m_mgrMBean = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
                            }
                            this.m_mgrMBean.createConnectionPool(this);
                        } else {
                            this.m_mgr.createConnectionPool(this);
                        }
                        logger.fine("Connection pool instance is created");
                    }
                    if (this.m_cp.isLifecycleStopped() || this.m_cp.isLifecycleFailed()) {
                        this.m_cp.start();
                    }
                    logger.fine("connection pool is started");
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(0, e);
                }
                this.m_started.set(true);
            }
        }
    }

    protected void createPoolWithDefaultProperties() throws SQLException {
        String className = this.getClass().getName();
        try {
            if (this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.startsWith("oracle.jdbc")) {
                if (!this.m_isDriverFactory) {
                    OracleDataSourceConnectionFactoryAdapter ocfa = new OracleDataSourceConnectionFactoryAdapter((DataSource)this.m_connectionFactory);
                    this.m_cp = new OracleConnectionConnectionPool(ocfa);
                    ocfa.setUniversalConnectionPool(this.m_cp);
                } else {
                    OracleDriverConnectionFactoryAdapter odcfa = new OracleDriverConnectionFactoryAdapter((Driver)this.m_connectionFactory, this.m_url, this.m_connectionFactoryProperties);
                    this.m_cp = new OracleConnectionConnectionPool(odcfa);
                    odcfa.setUniversalConnectionPool(this.m_cp);
                }
            } else if (!this.m_isDriverFactory) {
                DataSourceConnectionFactoryAdapter cfa = new DataSourceConnectionFactoryAdapter((DataSource)this.m_connectionFactory);
                this.m_cp = new ConnectionConnectionPool(cfa);
                cfa.setUniversalConnectionPool(this.m_cp);
            } else {
                DriverConnectionFactoryAdapter dcfa = new DriverConnectionFactoryAdapter((Driver)this.m_connectionFactory, this.m_url, this.m_connectionFactoryProperties);
                this.m_cp = new ConnectionConnectionPool(dcfa);
                dcfa.setUniversalConnectionPool(this.m_cp);
            }
            assert (this.m_cp != null);
            logger.fine("Connection pool instance is created with default properties");
        }
        catch (Exception e) {
            UCPErrorHandler.throwSQLException(1, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniversalConnectionPool createUniversalConnectionPool() throws SQLException {
        String className = this.getClass().getName();
        AtomicBoolean atomicBoolean = this.m_started;
        synchronized (atomicBoolean) {
            if (!this.m_created.get()) {
                try {
                    this.initConnectionFactory();
                    this.createPoolWithDefaultProperties();
                    assert (this.m_cp != null);
                    this.m_created.set(true);
                    if (this.m_connectionPoolName != null && !this.m_connectionPoolName.equals("")) {
                        this.m_cp.setName(this.m_connectionPoolName);
                    }
                    for (AutoProperty param : this.m_autoProperties) {
                        param.set();
                    }
                    Object i$ = this.m_onsConfigurationStringLocker;
                    synchronized (i$) {
                        if (this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.startsWith("oracle.jdbc")) {
                            ((OracleJDBCConnectionPool)this.m_cp).setONSConfiguration(this.m_onsConfigurationString);
                        }
                    }
                    logger.finest("connection pool is configured");
                    assert (this.m_cp != null);
                    this.m_cp.setConnectionRetrievalInfo(new JDBCConnectionRetrievalInfo(this.m_user, this.m_password));
                }
                catch (Exception exc) {
                    this.m_cp = null;
                    UCPErrorHandler.throwSQLException(22, exc);
                }
            }
        }
        return this.m_cp;
    }

    @Override
    public UniversalConnectionPoolMBean createUniversalConnectionPoolMBean() throws SQLException {
        JDBCUniversalConnectionPoolMBeanImpl poolMBean = null;
        try {
            assert (this.m_cp != null);
            poolMBean = new JDBCUniversalConnectionPoolMBeanImpl(this.m_cp);
            logger.fine("JDBC PoolMBean created");
        }
        catch (Exception exc) {
            UCPErrorHandler.throwSQLException(1, exc);
        }
        return poolMBean;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.m_user, this.m_password);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        oracle.ucp.ConnectionLabelingCallback labelingCbk = this.m_connectionLabelingCallback.get();
        if (labelingCbk == null) {
            logger.log(Level.FINEST, "labeling callback is null");
            return this.getConnection(username, password, null);
        }
        if (!(labelingCbk instanceof ConnectionLabelingCallback)) {
            logger.log(Level.FINEST, "labeling callback is not oracle.ucp.jdbc.ConnectionLabelingCallback");
            return this.getConnection(username, password, null);
        }
        logger.log(Level.FINEST, "labeling callback is oracle.ucp.jdbc.ConnectionLabelingCallback");
        ConnectionLabelingCallback newLabelingCbk = (ConnectionLabelingCallback)labelingCbk;
        return this.getConnection(username, password, newLabelingCbk.getRequestedLabels());
    }

    @Override
    public Connection getConnection(Properties labels) throws SQLException {
        return this.getConnection(this.m_user, this.m_password, labels);
    }

    @Override
    public Connection getConnection(String username, String password, Properties labels) throws SQLException {
        this.startPool();
        Connection conn = null;
        try {
            JDBCConnectionRetrievalInfo cri = new JDBCConnectionRetrievalInfo(username, password, labels);
            JDBCUniversalPooledConnection jdbcPooledConnection = (JDBCUniversalPooledConnection)this.m_cp.borrowConnection(cri);
            conn = (Connection)ConnectionProxyFactory.createConnectionProxy(this.m_cp, jdbcPooledConnection);
        }
        catch (NoAvailableConnectionsException e) {
            UCPErrorHandler.throwSQLException(28, e);
        }
        catch (UniversalConnectionPoolException e) {
            UCPErrorHandler.throwSQLException(29, e);
        }
        return conn;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUser() {
        Object object = this.m_userLocker;
        synchronized (object) {
            return this.m_user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUser(String user) throws SQLException {
        logger.log(Level.FINEST, "user: {0}", user);
        Object object = this.m_userLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "user", user, true, true);
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "userName", user, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(24, e);
                }
            }
            this.m_user = user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPassword() {
        Object object = this.m_passwordLocker;
        synchronized (object) {
            return this.m_password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(String password) throws SQLException {
        Object object = this.m_passwordLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                try {
                    assert (this.m_connectionFactory != null);
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "password", password, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(25, e);
                }
            }
            this.m_password = password;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getURL() {
        Object object = this.m_urlLocker;
        synchronized (object) {
            return this.m_url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(String url) throws SQLException {
        logger.log(Level.FINEST, "URL: {0}", url);
        Object object = this.m_urlLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                try {
                    this.setURLProperties(url);
                    try {
                        this.m_cp.refresh();
                    }
                    catch (Exception e) {
                        this.setURLProperties(this.m_url);
                        this.m_cp.stop();
                        this.m_cp.start();
                        UCPErrorHandler.throwSQLException(22, e);
                    }
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(26, e);
                }
            }
            this.m_url = url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServerName(String serverName) throws SQLException {
        logger.log(Level.FINEST, "Server Name: {0}", serverName);
        Object object = this.m_serverNameLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "serverName", serverName, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(49, e);
                }
            }
            this.m_serverName = serverName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getServerName() {
        Object object = this.m_serverNameLocker;
        synchronized (object) {
            return this.m_serverName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPortNumber(int portNumber) throws SQLException {
        logger.log(Level.FINEST, "Port Number: {0}", portNumber);
        Object object = this.m_portNumberLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "portNumber", portNumber, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(50, e);
                }
            }
            this.m_portNumber = portNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPortNumber() {
        Object object = this.m_portNumberLocker;
        synchronized (object) {
            return this.m_portNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDatabaseName(String databaseName) throws SQLException {
        logger.log(Level.FINEST, "Database Name : {0}", databaseName);
        Object object = this.m_databaseNameLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "databaseName", databaseName, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(51, e);
                }
            }
            this.m_databaseName = databaseName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDatabaseName() {
        Object object = this.m_databaseNameLocker;
        synchronized (object) {
            return this.m_databaseName;
        }
    }

    @Override
    public void setDataSourceName(String dataSourceName) throws SQLException {
        logger.log(Level.FINEST, "DataSourceName : {0}", dataSourceName);
        this.m_dataSourceName.set(dataSourceName);
    }

    @Override
    public String getDataSourceName() {
        return this.m_dataSourceName.get();
    }

    @Override
    public void setDescription(String description) throws SQLException {
        logger.log(Level.FINEST, "Description : {0}", description);
        this.m_description.set(description);
    }

    @Override
    public String getDescription() {
        return this.m_description.get();
    }

    @Override
    public void setNetworkProtocol(String networkProtocol) throws SQLException {
        logger.log(Level.FINEST, "networkProtocol : {0}", networkProtocol);
        this.m_networkProtocol.set(networkProtocol);
    }

    @Override
    public String getNetworkProtocol() {
        return this.m_networkProtocol.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRoleName(String roleName) throws SQLException {
        logger.log(Level.FINEST, "RoleName : {0}", roleName);
        Object object = this.m_roleNameLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                try {
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "roleName", roleName, true, true);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(55, e);
                }
            }
            this.m_roleName = roleName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRoleName() {
        Object object = this.m_roleNameLocker;
        synchronized (object) {
            return this.m_roleName;
        }
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) throws SQLException {
        logger.log(Level.FINEST, "initialPoolSize: {0}", initialPoolSize);
        this.m_initialPoolSize.set(initialPoolSize);
    }

    @Override
    public int getInitialPoolSize() {
        return this.m_initialPoolSize.get();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) throws SQLException {
        logger.log(Level.FINEST, "minPoolSize: {0}", minPoolSize);
        this.m_minPoolSize.set(minPoolSize);
    }

    @Override
    public int getMinPoolSize() {
        return this.m_minPoolSize.get();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) throws SQLException {
        logger.log(Level.FINEST, "maxPoolSize: {0}", maxPoolSize);
        this.m_maxPoolSize.set(maxPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.m_maxPoolSize.get();
    }

    @Override
    public void setInactiveConnectionTimeout(int inactivityTimeout) throws SQLException {
        logger.log(Level.FINEST, "inactivityTimeout: {0}", inactivityTimeout);
        this.m_inactiveConnectionTimeout.set(inactivityTimeout);
    }

    @Override
    public int getInactiveConnectionTimeout() {
        return this.m_inactiveConnectionTimeout.get();
    }

    @Override
    public void setConnectionWaitTimeout(int waitTimeout) throws SQLException {
        logger.log(Level.FINEST, "waitTimeout: {0}", waitTimeout);
        this.m_connectionWaitTimeout.set(waitTimeout);
    }

    @Override
    public int getConnectionWaitTimeout() {
        return this.m_connectionWaitTimeout.get();
    }

    @Override
    public void setTimeToLiveConnectionTimeout(int timeToLiveConnectionTimeout) throws SQLException {
        logger.log(Level.FINEST, "timeToLiveConnectionTimeout: {0}", timeToLiveConnectionTimeout);
        this.m_timeToLiveConnectionTimeout.set(timeToLiveConnectionTimeout);
    }

    @Override
    public int getTimeToLiveConnectionTimeout() {
        return this.m_timeToLiveConnectionTimeout.get();
    }

    @Override
    public int getAbandonedConnectionTimeout() {
        return this.m_abandonedConnectionTimeout.get();
    }

    @Override
    public void setAbandonedConnectionTimeout(int abandonedConnectionTimeout) throws SQLException {
        logger.log(Level.FINEST, "abandonedConnectionTimeout: {0}", abandonedConnectionTimeout);
        this.m_abandonedConnectionTimeout.set(abandonedConnectionTimeout);
    }

    @Override
    public void setTimeoutCheckInterval(int timeInterval) throws SQLException {
        logger.log(Level.FINEST, "timeInterval: {0}", timeInterval);
        this.m_timeoutCheckInterval.set(timeInterval);
    }

    @Override
    public int getTimeoutCheckInterval() {
        return this.m_timeoutCheckInterval.get();
    }

    @Override
    public void setFastConnectionFailoverEnabled(boolean failoverEnabled) throws SQLException {
        logger.log(Level.FINEST, "failoverEnabled: {0}", failoverEnabled);
        this.m_fastConnectionFailoverEnabled.set(failoverEnabled);
    }

    @Override
    public boolean getFastConnectionFailoverEnabled() {
        return this.m_fastConnectionFailoverEnabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionFactoryClassName() {
        String string = this.m_connectionFactoryClassName;
        synchronized (string) {
            return this.m_connectionFactoryClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionFactoryClassName(String factoryClassName) throws SQLException {
        logger.log(Level.FINEST, "factoryClassName: {0}", factoryClassName);
        if (factoryClassName == null) {
            UCPErrorHandler.throwSQLException(22, null);
        }
        String string = this.m_connectionFactoryClassName;
        synchronized (string) {
            this.m_connectionFactoryClassName = factoryClassName;
        }
    }

    @Override
    public void setMaxStatements(int maxStatements) throws SQLException {
        logger.log(Level.FINEST, "maxStatements: {0}", maxStatements);
        this.m_maxStatements.set(maxStatements);
    }

    @Override
    public int getMaxStatements() {
        return this.m_maxStatements.get();
    }

    @Override
    public void setMaxIdleTime(int idleTime) throws SQLException {
        this.setInactiveConnectionTimeout(idleTime);
    }

    @Override
    public int getMaxIdleTime() {
        return this.getInactiveConnectionTimeout();
    }

    @Override
    public void setPropertyCycle(int propertyCycle) throws SQLException {
        this.setTimeoutCheckInterval(propertyCycle);
    }

    @Override
    public int getPropertyCycle() {
        return this.getTimeoutCheckInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionPoolName(String connectionPoolName) throws SQLException {
        logger.log(Level.FINEST, "connectionPoolName: {0}", connectionPoolName);
        AtomicBoolean atomicBoolean = this.m_started;
        synchronized (atomicBoolean) {
            if (connectionPoolName != null && !connectionPoolName.equals("") && this.m_created.get()) {
                try {
                    UniversalConnectionPoolManagerHelper umh = new UniversalConnectionPoolManagerHelper(this.m_cp);
                    umh.setManagerPoolID(connectionPoolName);
                }
                catch (UniversalConnectionPoolException e) {
                    UCPErrorHandler.throwSQLException(45, e);
                }
                this.m_cp.setName(connectionPoolName);
            }
            this.m_connectionPoolName = connectionPoolName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionPoolName() {
        AtomicBoolean atomicBoolean = this.m_started;
        synchronized (atomicBoolean) {
            return this.m_created.get() ? this.m_cp.getName() : this.m_connectionPoolName;
        }
    }

    @Override
    public void setValidateConnectionOnBorrow(boolean validateConnectionOnBorrow) throws SQLException {
        logger.log(Level.FINEST, "validateConnectionOnBorrow: {0}", validateConnectionOnBorrow);
        this.m_validateConnectionOnBorrow.set(validateConnectionOnBorrow);
    }

    @Override
    public boolean getValidateConnectionOnBorrow() {
        return this.m_validateConnectionOnBorrow.get();
    }

    @Override
    public void setSQLForValidateConnection(String SQLString) throws SQLException {
        logger.log(Level.FINEST, "SQLForValidateConnection: {0}", SQLString);
        if (SQLString != null && SQLString.equals("")) {
            UCPErrorHandler.throwSQLException(22, null);
        }
        this.m_SQLForValidateConnection.set(SQLString);
    }

    @Override
    public String getSQLForValidateConnection() {
        return this.m_SQLForValidateConnection.get();
    }

    @Override
    public int getConnectionHarvestTriggerCount() {
        return this.m_connectionHarvestTriggerCount.get();
    }

    @Override
    public void setConnectionHarvestTriggerCount(int connectionHarvestTriggerCount) throws SQLException {
        logger.log(Level.FINEST, "connectionHarvestTriggerCount: {0}", connectionHarvestTriggerCount);
        this.m_connectionHarvestTriggerCount.set(connectionHarvestTriggerCount);
    }

    @Override
    public int getConnectionHarvestMaxCount() {
        return this.m_connectionHarvestMaxCount.get();
    }

    @Override
    public void setConnectionHarvestMaxCount(int connectionHarvestMaxCount) throws SQLException {
        logger.log(Level.FINEST, "connectionHarvestMaxCount: {0}", connectionHarvestMaxCount);
        this.m_connectionHarvestMaxCount.set(connectionHarvestMaxCount);
    }

    @Override
    public long getMaxConnectionReuseTime() {
        return this.m_maxConnectionReuseTime.get();
    }

    @Override
    public void setMaxConnectionReuseTime(long maxConnectionReuseTime) throws SQLException {
        logger.log(Level.FINEST, "maxConnectionReuseTime: {0}", maxConnectionReuseTime);
        this.m_maxConnectionReuseTime.set(maxConnectionReuseTime);
    }

    @Override
    public int getMaxConnectionReuseCount() {
        return this.m_maxConnectionReuseCount.get();
    }

    @Override
    public void setMaxConnectionReuseCount(int maxConnectionReuseCount) throws SQLException {
        logger.log(Level.FINEST, "maxConnectionReuseCount: {0}", maxConnectionReuseCount);
        this.m_maxConnectionReuseCount.set(maxConnectionReuseCount);
    }

    @Override
    public int getAvailableConnectionsCount() {
        if (this.m_cp == null) {
            return 0;
        }
        return this.m_cp.getAvailableConnectionsCount();
    }

    @Override
    public int getBorrowedConnectionsCount() {
        if (this.m_cp == null) {
            return 0;
        }
        return this.m_cp.getBorrowedConnectionsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getONSConfiguration() throws SQLException {
        Object object = this.m_onsConfigurationStringLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                if (!(this.m_cp instanceof OracleJDBCConnectionPool)) {
                    UCPErrorHandler.throwSQLException(17, null);
                }
                try {
                    return ((OracleJDBCConnectionPool)this.m_cp).getONSConfiguration();
                }
                catch (UniversalConnectionPoolException e) {
                    UCPErrorHandler.throwSQLException(17, e);
                    return null;
                }
            }
            return this.m_onsConfigurationString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setONSConfiguration(String onsConfigStr) throws SQLException {
        logger.log(Level.FINEST, "onsConfigStr: {0}", Util.maskONSConfigurationString(onsConfigStr));
        Object object = this.m_onsConfigurationStringLocker;
        synchronized (object) {
            if (this.m_created.get()) {
                if (!(this.m_cp instanceof OracleJDBCConnectionPool)) {
                    UCPErrorHandler.throwSQLException(17, null);
                }
                try {
                    ((OracleJDBCConnectionPool)this.m_cp).setONSConfiguration(onsConfigStr);
                }
                catch (UniversalConnectionPoolException e) {
                    UCPErrorHandler.throwSQLException(17, e);
                }
            }
            this.m_onsConfigurationString = onsConfigStr;
        }
    }

    @Override
    public void registerConnectionLabelingCallback(oracle.ucp.ConnectionLabelingCallback cbk) throws SQLException {
        logger.finest("connection labeling callback registered");
        if (cbk == null) {
            throw new NullPointerException("callback has to be non-null");
        }
        this.m_connectionLabelingCallback.set(cbk);
    }

    @Override
    public void removeConnectionLabelingCallback() throws SQLException {
        logger.finest("connection labeling callback removed");
        this.m_connectionLabelingCallback.set(null);
    }

    @Override
    public void registerConnectionAffinityCallback(ConnectionAffinityCallback cbk) throws SQLException {
        logger.finest("connection affinity callback registered");
        if (cbk == null) {
            throw new NullPointerException("callback has to be non-null");
        }
        this.m_connectionAffinityCallback.set(cbk);
    }

    @Override
    public void removeConnectionAffinityCallback() throws SQLException {
        logger.finest("connection affinity callback removed");
        this.m_connectionAffinityCallback.set(null);
    }

    @Override
    public JDBCConnectionPoolStatistics getStatistics() {
        if (this.m_cp == null) {
            return null;
        }
        if (this.m_cp instanceof OracleJDBCConnectionPool) {
            return new OracleJDBCConnectionPoolStatisticsImpl((OracleJDBCConnectionPool)this.m_cp);
        }
        return new JDBCConnectionPoolStatisticsImpl(this.m_cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getConnectionProperties() {
        Object object = this.m_connectionPropertiesLocker;
        synchronized (object) {
            return this.m_connectionProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionProperty(String propertyName) {
        Object object = this.m_connectionPropertiesLocker;
        synchronized (object) {
            return this.m_connectionProperties.getProperty(propertyName);
        }
    }

    @Override
    public void setConnectionProperty(String name, String value) throws SQLException {
        logger.log(Level.FINEST, "name: {0}, value: {1}", new Object[]{name, value});
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException();
        }
        Properties connProps = new Properties();
        connProps.setProperty(name, value);
        this.setConnectionProperties(connProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionProperties(Properties connectionProperties) throws SQLException {
        logger.log(Level.FINEST, "ConnectionProperties: {0}", connectionProperties);
        Object object = this.m_connectionPropertiesLocker;
        synchronized (object) {
            if (connectionProperties.size() <= 0) {
                throw new IllegalArgumentException();
            }
            for (Map.Entry<Object, Object> prop : connectionProperties.entrySet()) {
                this.m_connectionProperties.setProperty((String)prop.getKey(), (String)prop.getValue());
            }
            if (this.m_created.get() && this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.startsWith("oracle.jdbc.pool")) {
                try {
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "connectionProperties", this.m_connectionProperties, true, false);
                }
                catch (Exception e) {
                    UCPErrorHandler.throwSQLException(48, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getConnectionFactoryProperties() {
        Object object = this.m_connectionFactoryPropertiesLocker;
        synchronized (object) {
            return this.m_connectionFactoryProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConnectionFactoryProperty(String propertyName) {
        Object object = this.m_connectionFactoryPropertiesLocker;
        synchronized (object) {
            return this.m_connectionFactoryProperties.getProperty(propertyName);
        }
    }

    @Override
    public void setConnectionFactoryProperty(String name, String value) throws SQLException {
        logger.log(Level.FINEST, "name: {0}, value: {1}", new Object[]{name, value});
        if (value == null || value.equals("")) {
            throw new IllegalArgumentException();
        }
        Properties connFactoryProps = new Properties();
        connFactoryProps.setProperty(name, value);
        this.setConnectionFactoryProperties(connFactoryProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionFactoryProperties(Properties factoryProperties) throws SQLException {
        logger.log(Level.FINEST, "factoryProperties: {0}", factoryProperties);
        Object object = this.m_connectionFactoryPropertiesLocker;
        synchronized (object) {
            if (factoryProperties.size() <= 0) {
                throw new IllegalArgumentException();
            }
            for (Map.Entry<Object, Object> prop : factoryProperties.entrySet()) {
                String name = (String)prop.getKey();
                String value = (String)prop.getValue();
                if (this.m_created.get() && !this.m_isDriverFactory) {
                    try {
                        PoolDataSourceImpl.setProperty(this.m_connectionFactory, name, value, true, false);
                    }
                    catch (Exception e) {
                        UCPErrorHandler.throwSQLException(59, e);
                    }
                }
                this.m_connectionFactoryProperties.setProperty(name, value);
            }
        }
        object = this.m_userLocker;
        synchronized (object) {
            if (this.m_user == null || this.m_user.equals("")) {
                this.m_user = this.m_connectionFactoryProperties.getProperty("user");
                if (this.m_user == null || this.m_user.equals("")) {
                    this.m_user = this.m_connectionFactoryProperties.getProperty("username");
                }
            }
        }
        object = this.m_passwordLocker;
        synchronized (object) {
            if (this.m_password == null || this.m_password.equals("")) {
                this.m_password = this.m_connectionFactoryProperties.getProperty("password");
            }
        }
        object = this.m_urlLocker;
        synchronized (object) {
            if (this.m_url == null || this.m_url.equals("")) {
                this.m_url = this.m_connectionFactoryProperties.getProperty("url");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectionFactory() throws SQLException {
        Object e2;
        Object clsLoader;
        Object object;
        String className = this.getClass().getName();
        try {
            object = this.m_connectionFactoryClassName;
            synchronized (object) {
                clsLoader = Thread.currentThread().getContextClassLoader();
                this.m_connectionFactory = Class.forName(this.m_connectionFactoryClassName, true, (ClassLoader)clsLoader).newInstance();
                this.m_isDriverFactory = this.m_connectionFactory instanceof Driver;
            }
            logger.finest("factory class created");
        }
        catch (Exception e2) {
            UCPErrorHandler.throwSQLException(23, e2);
        }
        try {
            e2 = this.m_userLocker;
            synchronized (e2) {
                PoolDataSourceImpl.setProperty(this.m_connectionFactory, "user", this.m_user, true, true);
                PoolDataSourceImpl.setProperty(this.m_connectionFactory, "userName", this.m_user, true, true);
                if (this.m_isDriverFactory && this.m_user != null && !this.m_user.equals("")) {
                    clsLoader = this.m_connectionFactoryPropertiesLocker;
                    synchronized (clsLoader) {
                        this.m_connectionFactoryProperties.setProperty("user", this.m_user);
                    }
                }
            }
            logger.finest("user is set");
        }
        catch (Exception e3) {
            UCPErrorHandler.throwSQLException(24, e3);
        }
        try {
            e2 = this.m_passwordLocker;
            synchronized (e2) {
                PoolDataSourceImpl.setProperty(this.m_connectionFactory, "password", this.m_password, true, true);
                if (this.m_isDriverFactory && this.m_password != null && !this.m_password.equals("")) {
                    clsLoader = this.m_connectionFactoryPropertiesLocker;
                    synchronized (clsLoader) {
                        this.m_connectionFactoryProperties.setProperty("password", this.m_password);
                    }
                }
            }
            logger.finest("password is set");
        }
        catch (Exception e4) {
            UCPErrorHandler.throwSQLException(25, e4);
        }
        try {
            e2 = this.m_urlLocker;
            synchronized (e2) {
                this.setURLProperties(this.m_url);
            }
            logger.finest("URL is set");
        }
        catch (Exception e5) {
            UCPErrorHandler.throwSQLException(26, e5);
        }
        try {
            e2 = this.m_serverNameLocker;
            synchronized (e2) {
                PoolDataSourceImpl.setProperty(this.m_connectionFactory, "serverName", this.m_serverName, true, true);
                if (this.m_isDriverFactory && this.m_serverName != null && !this.m_serverName.equals("")) {
                    clsLoader = this.m_connectionFactoryPropertiesLocker;
                    synchronized (clsLoader) {
                        this.m_connectionFactoryProperties.setProperty("serverName", this.m_serverName);
                    }
                }
            }
            logger.finest("Database Server Name is set");
        }
        catch (Exception e6) {
            UCPErrorHandler.throwSQLException(49, e6);
        }
        try {
            e2 = this.m_portNumberLocker;
            synchronized (e2) {
                PoolDataSourceImpl.setProperty(this.m_connectionFactory, "portNumber", this.m_portNumber, true, true);
                if (this.m_isDriverFactory && this.m_portNumber != 0) {
                    clsLoader = this.m_connectionFactoryPropertiesLocker;
                    synchronized (clsLoader) {
                        this.m_connectionFactoryProperties.setProperty("portNumber", "" + this.m_portNumber);
                    }
                }
            }
            logger.finest("Port Number is set");
        }
        catch (Exception e7) {
            UCPErrorHandler.throwSQLException(50, e7);
        }
        try {
            e2 = this.m_databaseNameLocker;
            synchronized (e2) {
                PoolDataSourceImpl.setProperty(this.m_connectionFactory, "databaseName", this.m_databaseName, true, true);
                if (this.m_isDriverFactory && this.m_databaseName != null && !this.m_databaseName.equals("")) {
                    clsLoader = this.m_connectionFactoryPropertiesLocker;
                    synchronized (clsLoader) {
                        this.m_connectionFactoryProperties.setProperty("databaseName", this.m_databaseName);
                    }
                }
            }
            logger.finest("Database name is set");
        }
        catch (Exception e8) {
            UCPErrorHandler.throwSQLException(51, e8);
        }
        this.m_dataSourceName.set();
        logger.finest("DataSource name is set");
        this.m_description.set();
        logger.finest("DataSource description is set");
        e2 = this.m_networkProtocol;
        synchronized (e2) {
            this.m_networkProtocol.set();
            if (this.m_isDriverFactory && this.m_networkProtocol.get() != null && !this.m_networkProtocol.get().equals("")) {
                clsLoader = this.m_connectionFactoryPropertiesLocker;
                synchronized (clsLoader) {
                    try {
                        this.m_connectionFactoryProperties.setProperty("networkProtocol", this.m_networkProtocol.get());
                    }
                    catch (Exception e9) {
                        UCPErrorHandler.throwSQLException(54, e9);
                    }
                }
            }
        }
        logger.finest("DataSource network protocol is set");
        try {
            e2 = this.m_roleNameLocker;
            synchronized (e2) {
                PoolDataSourceImpl.setProperty(this.m_connectionFactory, "roleName", this.m_roleName, true, true);
                if (this.m_isDriverFactory && this.m_roleName != null && !this.m_roleName.equals("")) {
                    clsLoader = this.m_connectionFactoryPropertiesLocker;
                    synchronized (clsLoader) {
                        this.m_connectionFactoryProperties.setProperty("roleName", this.m_roleName);
                    }
                }
            }
            logger.finest("DataSource role name is set");
        }
        catch (Exception e2) {
            UCPErrorHandler.throwSQLException(55, e2);
        }
        if (this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.startsWith("oracle.jdbc.pool") && this.m_connectionProperties.size() > 0) {
            try {
                e2 = this.m_connectionPropertiesLocker;
                synchronized (e2) {
                    PoolDataSourceImpl.setProperty(this.m_connectionFactory, "connectionProperties", this.m_connectionProperties, true, false);
                }
                logger.finest("Connection properties are set");
            }
            catch (Exception e10) {
                UCPErrorHandler.throwSQLException(48, e10);
            }
        }
        if (!this.m_isDriverFactory && this.m_connectionFactoryProperties.size() > 0) {
            object = this.m_connectionFactoryPropertiesLocker;
            synchronized (object) {
                for (Map.Entry<Object, Object> prop : this.m_connectionFactoryProperties.entrySet()) {
                    try {
                        PoolDataSourceImpl.setProperty(this.m_connectionFactory, (String)prop.getKey(), (String)prop.getValue(), true, false);
                    }
                    catch (Exception e11) {
                        UCPErrorHandler.throwSQLException(59, e11);
                    }
                }
            }
        }
    }

    private static void setProperty(Object object, String name, Object value, boolean caseSensitive, boolean lenient) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        Object loggedValue = "password".equalsIgnoreCase(name) ? "*****" : value;
        logger.log(Level.FINEST, "property set: name={0}, value={1}, caseSensitive={2}, lenient={3}", new Object[]{name, loggedValue, caseSensitive, lenient});
        Class<?> type = object.getClass();
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(type).getPropertyDescriptors();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i].getWriteMethod() == null) continue;
            if (caseSensitive && descriptors[i].getName().equals(name) || !caseSensitive && descriptors[i].getName().equalsIgnoreCase(name)) {
                Method method = descriptors[i].getWriteMethod();
                Class<?> paramType = method.getParameterTypes()[0];
                if (value instanceof String) {
                    value = PoolDataSourceImpl.toBasicType(value.toString(), paramType.getName());
                }
                method.invoke(object, value);
                return;
            }
            names.add(descriptors[i].getName());
        }
        if (!lenient) {
            IllegalArgumentException iae = new IllegalArgumentException("No such property: " + name + ", existing writable properties are: " + names);
            logger.throwing(PoolDataSource.class.getName(), "setProperty", iae);
            throw iae;
        }
    }

    private void setSpecialProperty(String propertyName, String url) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (url == null) {
            throw new NullPointerException("no url");
        }
        StringTokenizer tokens = new StringTokenizer(url, ";");
        while (tokens.hasMoreTokens()) {
            String currToken = tokens.nextToken();
            if (!currToken.startsWith(propertyName + "=")) continue;
            PoolDataSourceImpl.setProperty(this.m_connectionFactory, propertyName, currToken.substring(currToken.indexOf("=") + 1), true, true);
            return;
        }
    }

    private void setURLProperties(String url) throws IllegalArgumentException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        PoolDataSourceImpl.setProperty(this.m_connectionFactory, "url", url, true, true);
        PoolDataSourceImpl.setProperty(this.m_connectionFactory, "URL", url, true, true);
        if (this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.endsWith("ias.jdbcx.informix.InformixDataSource")) {
            this.setSpecialProperty("informixServer", url);
        }
    }

    public static final Object toBasicType(String value, String type) {
        Object retVal = null;
        String eMsg = null;
        try {
            if (value == null) {
                retVal = null;
            } else if (type == null || type.equals("java.lang.String")) {
                retVal = value;
            } else if (type.equals("java.lang.Character") || type.equals("char")) {
                if (value.length() == 1) {
                    retVal = new Character(value.charAt(0));
                } else {
                    eMsg = "Invalid Character value";
                }
            } else if (type.equals("java.lang.Integer") || type.equals("int")) {
                retVal = Integer.valueOf(value);
            } else if (type.equals("java.lang.Float") || type.equals("float")) {
                retVal = Float.valueOf(value);
            } else if (type.equals("java.lang.Long") || type.equals("long")) {
                retVal = Long.valueOf(value);
            } else if (type.equals("java.lang.Double") || type.equals("double")) {
                retVal = Double.valueOf(value);
            } else if (type.equals("java.lang.Byte") || type.equals("byte")) {
                retVal = Byte.valueOf(value);
            } else if (type.equals("java.lang.Short") || type.equals("short")) {
                retVal = Short.valueOf(value);
            } else if (type.equals("java.lang.Boolean") || type.equals("boolean")) {
                retVal = Boolean.valueOf(value);
            } else {
                eMsg = "Invalid attribute type" + type;
            }
        }
        catch (NumberFormatException e) {
            eMsg = "Invalid " + type + " value";
        }
        if (null != eMsg) {
            IllegalArgumentException e = new IllegalArgumentException(eMsg);
            logger.throwing(PoolDataSource.class.getName(), "toBasicType", e);
            throw e;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "oracle.ucp.jdbc.PoolDataSourceImpl", null);
        Object object = this.m_userLocker;
        synchronized (object) {
            if (this.m_user != null) {
                ref.add(new StringRefAddr("user", this.m_user));
            }
        }
        object = this.m_passwordLocker;
        synchronized (object) {
            if (this.m_password != null) {
                ref.add(new StringRefAddr("password", this.m_password));
            }
        }
        object = this.m_urlLocker;
        synchronized (object) {
            if (this.m_url != null) {
                ref.add(new StringRefAddr("url", this.m_url));
            }
        }
        object = this.m_serverNameLocker;
        synchronized (object) {
            if (this.m_serverName != null) {
                ref.add(new StringRefAddr("serverName", this.m_serverName));
            }
        }
        object = this.m_portNumberLocker;
        synchronized (object) {
            ref.add(new StringRefAddr("portNumber", Integer.toString(this.m_portNumber)));
        }
        object = this.m_databaseNameLocker;
        synchronized (object) {
            if (this.m_databaseName != null) {
                ref.add(new StringRefAddr("databaseName", this.m_databaseName));
            }
        }
        if (this.m_dataSourceName.get() != null) {
            ref.add(new StringRefAddr("dataSourceName", this.m_dataSourceName.toString()));
        }
        if (this.m_description.get() != null) {
            ref.add(new StringRefAddr("description", this.m_description.toString()));
        }
        if (this.m_networkProtocol.get() != null) {
            ref.add(new StringRefAddr("networkProtocol", this.m_networkProtocol.toString()));
        }
        object = this.m_roleNameLocker;
        synchronized (object) {
            if (this.m_roleName != null) {
                ref.add(new StringRefAddr("roleName", this.m_roleName));
            }
        }
        if (this.m_connectionFactoryClassName != null) {
            ref.add(new StringRefAddr("connectionFactoryClassName", this.m_connectionFactoryClassName));
        }
        if (this.m_connectionProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionProperties", this.m_connectionProperties.toString()));
        }
        if (this.m_connectionFactoryProperties.size() > 0) {
            ref.add(new StringRefAddr("connectionFactoryProperties", this.m_connectionFactoryProperties.toString()));
        }
        if (this.m_validateConnectionOnBorrow.get().booleanValue()) {
            ref.add(new StringRefAddr("validateConnectionOnBorrow", "true"));
        }
        object = this.m_SQLForValidateConnection;
        synchronized (object) {
            String str = this.m_SQLForValidateConnection.get();
            if (str != null) {
                ref.add(new StringRefAddr("sqlForValidateConnection", str));
            }
        }
        if (this.m_connectionPoolName != null) {
            ref.add(new StringRefAddr("connectionPoolName", this.m_connectionPoolName));
        }
        ref.add(new StringRefAddr("initialPoolSize", this.m_initialPoolSize.toString()));
        ref.add(new StringRefAddr("minPoolSize", this.m_minPoolSize.toString()));
        ref.add(new StringRefAddr("maxPoolSize", this.m_maxPoolSize.toString()));
        ref.add(new StringRefAddr("abandonedConnectionTimeout", this.m_abandonedConnectionTimeout.toString()));
        ref.add(new StringRefAddr("timeToLiveConnectionTimeout", this.m_timeToLiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("inactiveConnectionTimeout", this.m_inactiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("maxIdleTime", this.m_inactiveConnectionTimeout.toString()));
        ref.add(new StringRefAddr("timeoutCheckInterval", this.m_timeoutCheckInterval.toString()));
        ref.add(new StringRefAddr("propertyCycle", this.m_timeoutCheckInterval.toString()));
        ref.add(new StringRefAddr("maxStatements", this.m_maxStatements.toString()));
        ref.add(new StringRefAddr("connectionWaitTimeout", this.m_connectionWaitTimeout.toString()));
        ref.add(new StringRefAddr("maxConnectionReuseTime", this.m_maxConnectionReuseTime.toString()));
        ref.add(new StringRefAddr("maxConnectionReuseCount", this.m_maxConnectionReuseCount.toString()));
        ref.add(new StringRefAddr("connectionHarvestTriggerCount", this.m_connectionHarvestTriggerCount.toString()));
        ref.add(new StringRefAddr("connectionHarvestMaxCount", this.m_connectionHarvestMaxCount.toString()));
        if (this.m_fastConnectionFailoverEnabled.get().booleanValue()) {
            ref.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
        object = this.m_onsConfigurationStringLocker;
        synchronized (object) {
            if (this.m_onsConfigurationString != null) {
                ref.add(new StringRefAddr("onsConfiguration", this.m_onsConfigurationString));
            }
        }
        return ref;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SQLException {
        in.defaultReadObject();
    }

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        String[] nvPair;
        String[] propStrs;
        Reference ref = (Reference)refObj;
        String cn = ref.getClassName();
        PoolDataSourceImpl pd = null;
        if (cn.equals("oracle.ucp.jdbc.PoolDataSource") || cn.equals("oracle.ucp.jdbc.PoolDataSourceImpl")) {
            pd = new PoolDataSourceImpl();
        } else if (cn.equals("oracle.ucp.jdbc.PoolXADataSource") || cn.equals("oracle.ucp.jdbc.PoolXADataSourceImpl")) {
            pd = new PoolXADataSourceImpl();
        }
        if (pd == null) {
            return null;
        }
        StringRefAddr ra = (StringRefAddr)ref.get("user");
        if (ra != null) {
            pd.setUser((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("password")) != null) {
            pd.setPassword((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("url")) != null) {
            pd.setURL((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("serverName")) != null) {
            pd.setServerName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("portNumber")) != null) {
            pd.setPortNumber(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("databaseName")) != null) {
            pd.setDatabaseName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("dataSourceName")) != null) {
            pd.setDataSourceName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("description")) != null) {
            pd.setDescription((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("networkProtocol")) != null) {
            pd.setNetworkProtocol((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("roleName")) != null) {
            pd.setRoleName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionFactoryClassName")) != null) {
            pd.setConnectionFactoryClassName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionProperties")) != null) {
            String connPropsStr = (String)ra.getContent();
            Properties connProps = new Properties();
            for (String onePropStr : propStrs = connPropsStr.substring(1, connPropsStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                connProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setConnectionProperties(connProps);
        }
        if ((ra = (StringRefAddr)ref.get("connectionFactoryProperties")) != null) {
            String cfPropsStr = (String)ra.getContent();
            Properties cfProps = new Properties();
            for (String onePropStr : propStrs = cfPropsStr.substring(1, cfPropsStr.length() - 1).split(", ")) {
                nvPair = onePropStr.split("=");
                cfProps.setProperty(nvPair[0], nvPair[1]);
            }
            pd.setConnectionFactoryProperties(cfProps);
        }
        if ((ra = (StringRefAddr)ref.get("validateConnectionOnBorrow")) != null) {
            pd.setValidateConnectionOnBorrow(true);
        }
        if ((ra = (StringRefAddr)ref.get("sqlForValidateConnection")) != null) {
            pd.setSQLForValidateConnection((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("connectionPoolName")) != null) {
            pd.setConnectionPoolName((String)ra.getContent());
        }
        if ((ra = (StringRefAddr)ref.get("initialPoolSize")) != null) {
            pd.setInitialPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("minPoolSize")) != null) {
            pd.setMinPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxPoolSize")) != null) {
            pd.setMaxPoolSize(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("abandonedConnectionTimeout")) != null) {
            pd.setAbandonedConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("timeToLiveConnectionTimeout")) != null) {
            pd.setTimeToLiveConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("inactiveConnectionTimeout")) != null) {
            pd.setInactiveConnectionTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("timeoutCheckInterval")) != null) {
            pd.setTimeoutCheckInterval(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxStatements")) != null) {
            pd.setMaxStatements(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionWaitTimeout")) != null) {
            pd.setConnectionWaitTimeout(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionReuseTime")) != null) {
            pd.setMaxConnectionReuseTime(Long.parseLong((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("maxConnectionReuseCount")) != null) {
            pd.setMaxConnectionReuseCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionHarvestTriggerCount")) != null) {
            pd.setConnectionHarvestTriggerCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("connectionHarvestMaxCount")) != null) {
            pd.setConnectionHarvestMaxCount(Integer.parseInt((String)ra.getContent()));
        }
        if ((ra = (StringRefAddr)ref.get("fastConnectionFailoverEnabled")) != null) {
            pd.setFastConnectionFailoverEnabled(true);
        }
        if ((ra = (StringRefAddr)ref.get("onsConfiguration")) != null) {
            pd.setONSConfiguration((String)ra.getContent());
        }
        return pd;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AutoPropertyX<T>
    extends AutoProperty<T> {
        AutoPropertyX(T value) {
            super(value);
        }

        @Override
        T onGet() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AutoProperty<T> {
        protected T m_value;
        protected int m_err;

        AutoProperty(T value) {
            this.m_value = value;
            PoolDataSourceImpl.this.m_autoProperties.add(this);
        }

        boolean isValid(T value) {
            return true;
        }

        abstract void onSet(T var1) throws Exception;

        abstract T onGet();

        synchronized void set(T value) throws SQLException {
            if (!this.isValid(value)) {
                UCPErrorHandler.throwSQLException(22, null);
            }
            try {
                if (PoolDataSourceImpl.this.m_created.get()) {
                    this.onSet(value);
                }
                this.m_value = value;
            }
            catch (Exception e) {
                UCPErrorHandler.throwSQLException(this.m_err, e);
            }
        }

        synchronized void set() throws SQLException {
            this.set(this.m_value);
        }

        synchronized T get() {
            return PoolDataSourceImpl.this.m_created.get() ? this.onGet() : this.m_value;
        }

        public String toString() {
            return this.m_value.toString();
        }
    }
}

