/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

class TimeToLiveConnectionTimerTask
extends UCPTimerTaskImpl {
    private static final Logger logger = UCPLoggerFactory.createLogger(TimeToLiveConnectionTimerTask.class.getCanonicalName());
    private final UniversalConnectionPoolBase m_connectionPool;

    TimeToLiveConnectionTimerTask(UniversalConnectionPoolBase connectionPool) throws UniversalConnectionPoolException {
        if (connectionPool == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(54);
            logger.throwing(this.getClass().getName(), "TimeToLiveConnectionTimerTask", ucpe);
            throw ucpe;
        }
        this.m_connectionPool = connectionPool;
    }

    public void run() {
        this.m_connectionPool.processTimeToLiveTimeout();
    }

    UniversalConnectionPool getConnectionPool() {
        return this.m_connectionPool;
    }
}

