/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.AvailableConnections;
import oracle.ucp.common.AvailableConnectionsManyCollectionsWithLabels;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionsContainer {
    private static final Logger logger = UCPLoggerFactory.createLogger(ConnectionsContainer.class.getCanonicalName());
    static final int INITIAL_CAPACITY = 1024;
    private int m_connectionCreateRequests = 0;
    int m_allConnections = 0;
    private final Map<Object, UniversalPooledConnection> m_inUseHarvestableConnections = new HashMap<Object, UniversalPooledConnection>(1024);
    private final Map<Object, UniversalPooledConnection> m_inUseNonHarvestableConnections = new HashMap<Object, UniversalPooledConnection>(1024);
    private AvailableConnections m_availableConnections;

    ConnectionsContainer(UniversalConnectionPoolImpl cp) throws UniversalConnectionPoolException {
        this.m_availableConnections = new AvailableConnectionsManyCollectionsWithLabels(cp);
    }

    abstract int getMaxPoolSize();

    int getAllConnections() {
        return this.m_allConnections;
    }

    synchronized Map<Object, UniversalPooledConnection> getHarvestableConnections() {
        return this.m_inUseHarvestableConnections;
    }

    synchronized Map<Object, UniversalPooledConnection> getNonHarvestableConnections() {
        return this.m_inUseNonHarvestableConnections;
    }

    synchronized AvailableConnections getAvailableConnections() {
        return this.m_availableConnections;
    }

    synchronized void setAvailableConnections(AvailableConnections availableConnections) {
        this.m_availableConnections = availableConnections;
    }

    void addNewConnectionCreateRequest() {
        ++this.m_connectionCreateRequests;
    }

    void cancelConnectionCreateRequest() {
        --this.m_connectionCreateRequests;
    }

    int getNumConnectionCreateRequests() {
        return this.m_connectionCreateRequests;
    }

    void updateConnectionCreatedInfo(UniversalPooledConnection conn) {
        --this.m_connectionCreateRequests;
        ++this.m_allConnections;
    }

    boolean isThereRoomToGrowPool() {
        return this.m_allConnections + this.m_connectionCreateRequests < this.getMaxPoolSize();
    }

    synchronized UniversalPooledConnection[] getAllBorrowedConnections() {
        int i = 0;
        UniversalPooledConnection[] aupc = new UniversalPooledConnection[this.m_inUseHarvestableConnections.size() + this.m_inUseNonHarvestableConnections.size()];
        for (UniversalPooledConnection upc : this.m_inUseHarvestableConnections.values()) {
            aupc[i++] = upc;
        }
        for (UniversalPooledConnection upc : this.m_inUseNonHarvestableConnections.values()) {
            aupc[i++] = upc;
        }
        return aupc;
    }

    synchronized int getBorrowedConnectionsCount() {
        return this.m_inUseHarvestableConnections.size() + this.m_inUseNonHarvestableConnections.size();
    }

    public synchronized String toString() {
        int all = this.m_allConnections;
        int inUseHarvestable = this.m_inUseHarvestableConnections.size();
        int inUseNonHarvestable = this.m_inUseNonHarvestableConnections.size();
        int available = this.m_availableConnections.getNumAvailableConnections();
        int pending = this.m_connectionCreateRequests;
        int max = this.getMaxPoolSize();
        return "all: " + all + ", " + "avail: " + available + ", " + "borrowed: " + (inUseHarvestable + inUseNonHarvestable) + ", " + " pending: " + pending + ", " + " max: " + max;
    }
}

