/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.Arrays;
import java.util.NoSuchElementException;
import oracle.jdbc.driver.json.JakartaParserWrapper;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.JsonpParserWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OracleOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonObjectImpl;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.jdbc.driver.json.tree.OracleJsonVectorImpl;
import oracle.sql.CHAR;
import oracle.sql.RAW;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class OsonParserImpl
extends OracleOsonValueFactory
implements OracleJsonParser {
    private static int INITIAL_DEPTH_CAPACITY = 4;
    private final OsonContext ctx;
    private State state;
    private int depth;
    private OracleJsonStructure[] depthStack;
    private int[] currentChild;
    private OsonAbstractObject[] objectCache;
    private OsonAbstractArray[] arrayCache;
    private OracleJsonDecimalImpl numberCache;
    private StringPointer stringPointer = new StringPointer();
    private BinaryPointer binaryPointer = new BinaryPointer();
    private OracleJsonValue currentPrimitive;
    private Closeable closeable;
    OracleJsonParser.Event event;

    public OsonParserImpl(OsonContext ctx) {
        this.ctx = ctx;
        this.depthStack = new OracleJsonStructure[INITIAL_DEPTH_CAPACITY];
        this.currentChild = new int[INITIAL_DEPTH_CAPACITY];
        this.objectCache = new OsonAbstractObject[INITIAL_DEPTH_CAPACITY];
        this.arrayCache = new OsonAbstractArray[INITIAL_DEPTH_CAPACITY];
        this.init();
    }

    private void init() {
        this.state = State.START;
        this.depth = -1;
        this.event = null;
    }

    @Override
    public boolean hasNext() {
        return this.state != State.FINISHED;
    }

    @Override
    public OracleJsonParser.Event next() {
        switch (this.state) {
            case START: {
                int pos = this.ctx.getHeader().getTreeSegmentOffset();
                this.pushDepth();
                OracleJsonValue root = (OracleJsonValue)OsonStructureImpl.getValueInternal(pos, this, this.ctx);
                if (root.getOracleJsonType() != OracleJsonValue.OracleJsonType.ARRAY && root.getOracleJsonType() != OracleJsonValue.OracleJsonType.OBJECT) {
                    this.state = State.FINISHED;
                    this.currentPrimitive = root;
                    this.event = this.OracleJsonTypeToEvent(root);
                    return this.event;
                }
                this.setCurrent((OracleJsonStructure)root);
                this.state = State.NEXT_VALUE;
                if (root.getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
                    this.event = OracleJsonParser.Event.START_ARRAY;
                    return this.event;
                }
                this.event = OracleJsonParser.Event.START_OBJECT;
                return this.event;
            }
            case NEXT_VALUE: {
                this.event = this.nextValue();
                return this.event;
            }
            case AFTER_KEY: {
                this.state = State.NEXT_VALUE;
                this.event = this.nextChild();
                return this.event;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public String getString() {
        if (this.state == State.AFTER_KEY) {
            return ((OsonAbstractObject)((Object)this.depthStack[this.depth])).getFieldName(this.currentChild[this.depth]);
        }
        if (this.currentPrimitive != null) {
            switch (this.currentPrimitive.getOracleJsonType()) {
                case BINARY: {
                    return ((OracleJsonBinary)this.currentPrimitive).getString();
                }
                case DATE: {
                    return ((OracleJsonDate)this.currentPrimitive).getString();
                }
                case DECIMAL: 
                case FLOAT: 
                case DOUBLE: {
                    return ((OracleJsonNumberImpl)((Object)this.currentPrimitive)).getString();
                }
                case INTERVALDS: {
                    return ((OracleJsonIntervalDS)this.currentPrimitive).getString();
                }
                case INTERVALYM: {
                    return ((OracleJsonIntervalYM)this.currentPrimitive).getString();
                }
                case STRING: {
                    return ((OracleJsonString)this.currentPrimitive).getString();
                }
                case TIMESTAMP: {
                    return ((OracleJsonTimestamp)this.currentPrimitive).getString();
                }
                case TIMESTAMPTZ: {
                    return ((OracleJsonTimestampTZ)this.currentPrimitive).getString();
                }
            }
            throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
    }

    @Override
    public boolean isIntegralNumber() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).isIntegral();
    }

    @Override
    public int getInt() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).intValue();
    }

    @Override
    public long getLong() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).bigDecimalValue();
    }

    @Override
    public BigInteger getBigInteger() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).bigIntegerValue();
    }

    @Override
    public double getDouble() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).doubleValue();
    }

    @Override
    public float getFloat() {
        this.assertNumeric();
        return ((OracleJsonNumber)this.currentPrimitive).floatValue();
    }

    @Override
    public OffsetDateTime getOffsetDateTime() {
        if (this.currentPrimitive == null) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMPTZ.toString());
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMPTZ) {
            return ((OracleJsonTimestampTZ)this.currentPrimitive).getOffsetDateTime();
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMPTZ.toString());
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        if (this.currentPrimitive == null) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMP.toString());
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return ((OracleJsonDate)this.currentPrimitive).getLocalDateTime();
        }
        if (this.currentPrimitive.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return ((OracleJsonTimestamp)this.currentPrimitive).getLocalDateTime();
        }
        throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), OracleJsonValue.OracleJsonType.TIMESTAMP.toString());
    }

    @Override
    public byte[] getBytes() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.BINARY);
        return this.binaryPointer.getBytes();
    }

    @Override
    public void getBytes(OutputStream out) {
        this.assertJsonType(OracleJsonValue.OracleJsonType.BINARY);
        try {
            this.binaryPointer.getBytes(out);
        }
        catch (IOException e) {
            throw OracleJsonExceptions.IO.create(this.ctx.getExceptionFactory(), e, new Object[0]);
        }
    }

    public boolean isId() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.BINARY);
        return this.binaryPointer.isId();
    }

    @Override
    public Period getPeriod() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.INTERVALYM);
        return ((OracleJsonIntervalYMImpl)this.currentPrimitive).getPeriod();
    }

    @Override
    public Duration getDuration() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.INTERVALDS);
        return ((OracleJsonIntervalDSImpl)this.currentPrimitive).getDuration();
    }

    @Override
    public OracleJsonObject getObject() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.OBJECT);
        OsonAbstractObject obj = (OsonAbstractObject)((Object)this.getCurrent());
        this.objectCache[this.depth] = null;
        this.pop();
        return (OracleJsonObject)((Object)obj);
    }

    @Override
    public OracleJsonValue getValue() {
        OracleOsonValueFactory f = OracleOsonValueFactory.INSTANCE;
        if (this.event == null || this.event == OracleJsonParser.Event.END_ARRAY || this.event == OracleJsonParser.Event.END_OBJECT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE_VALUE.create(this.ctx.getExceptionFactory(), new Object[0]);
        }
        if (this.event == OracleJsonParser.Event.KEY_NAME) {
            return new OracleJsonStringImpl(this.getString());
        }
        if (this.event == OracleJsonParser.Event.VALUE_NULL) {
            return OracleJsonValue.NULL;
        }
        if (this.event == OracleJsonParser.Event.VALUE_FALSE) {
            return OracleJsonValue.FALSE;
        }
        if (this.event == OracleJsonParser.Event.VALUE_TRUE) {
            return OracleJsonValue.TRUE;
        }
        OracleJsonValue val = this.currentPrimitive == null ? this.getCurrent() : this.currentPrimitive;
        switch (val.getOracleJsonType()) {
            case BINARY: {
                OracleJsonBinary bin = (OracleJsonBinary)val;
                return new OracleJsonBinaryImpl(bin.getBytes(), bin.isId());
            }
            case DOUBLE: {
                OracleJsonDoubleImpl dbl = (OracleJsonDoubleImpl)val;
                return new OracleJsonDoubleImpl(dbl.doubleValue());
            }
            case FLOAT: {
                OracleJsonFloatImpl flt = (OracleJsonFloatImpl)val;
                return new OracleJsonFloatImpl(flt.floatValue());
            }
            case DECIMAL: {
                if (val instanceof OracleJsonStringNumberImpl) {
                    OracleJsonStringNumberImpl stringNumber = (OracleJsonStringNumberImpl)val;
                    return new OracleJsonStringNumberImpl(stringNumber.getString());
                }
                OracleJsonDecimalImpl num = (OracleJsonDecimalImpl)val;
                return new OracleJsonDecimalImpl(num.raw(), num.getTargetType());
            }
            case STRING: {
                return new OracleJsonStringImpl(((OracleJsonString)val).getString());
            }
            case TIMESTAMP: {
                OracleJsonTimestampImpl ts = (OracleJsonTimestampImpl)val;
                return f.createTimestamp(ts.raw());
            }
            case TIMESTAMPTZ: {
                OracleJsonTimestampTZImpl tstz = (OracleJsonTimestampTZImpl)val;
                return f.createTimestampTZ(tstz.raw());
            }
            case DATE: {
                OracleJsonDateImpl date = (OracleJsonDateImpl)val;
                return f.createDate(date.raw());
            }
            case INTERVALDS: {
                OracleJsonIntervalDSImpl intDs = (OracleJsonIntervalDSImpl)val;
                return f.createIntervalDS(intDs.raw());
            }
            case INTERVALYM: {
                OracleJsonIntervalYMImpl intYm = (OracleJsonIntervalYMImpl)val;
                return f.createIntervalYM(intYm.raw());
            }
            case ARRAY: {
                return this.getArray();
            }
            case VECTOR: {
                return (OracleJsonVectorImpl)val;
            }
        }
        return this.getObject();
    }

    @Override
    public OracleJsonArray getArray() {
        this.assertJsonType(OracleJsonValue.OracleJsonType.ARRAY);
        OsonAbstractArray arr = (OsonAbstractArray)((Object)this.getCurrent());
        this.arrayCache[this.depth] = null;
        this.pop();
        return (OracleJsonArray)((Object)arr);
    }

    @Override
    public void skipArray() {
        if (this.depth < 0) {
            return;
        }
        if (this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
            this.pop();
            this.currentPrimitive = null;
        }
    }

    @Override
    public void skipObject() {
        if (this.depth < 0) {
            return;
        }
        if (this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.pop();
            this.currentPrimitive = null;
        }
    }

    @Override
    public void close() {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException e) {
                throw OracleJsonExceptions.IO.create(this.ctx.getExceptionFactory(), e, new Object[0]);
            }
            this.closeable = null;
        }
        this.depth = -1;
        this.state = State.FINISHED;
        this.event = null;
    }

    public void setCloseable(Closeable closeable) {
        this.closeable = closeable;
    }

    @Override
    public OsonAbstractArray createArray(OsonContext ctx, int pos) {
        if (this.arrayCache[this.depth] == null) {
            this.arrayCache[this.depth] = ctx.getFactory().createArray(ctx, pos);
        } else {
            this.arrayCache[this.depth].init(pos);
        }
        return this.arrayCache[this.depth];
    }

    @Override
    public OsonAbstractObject createObject(OsonContext ctx, int pos) {
        if (this.objectCache[this.depth] == null) {
            this.objectCache[this.depth] = ctx.getFactory().createObject(ctx, pos);
        } else {
            this.objectCache[this.depth].init(pos);
        }
        return this.objectCache[this.depth];
    }

    @Override
    public Object createString(OsonContext ctx, int pos, int len) {
        this.stringPointer.reset(pos, len);
        return this.stringPointer;
    }

    @Override
    public Object createBinary(OsonContext ctx, int pos, int len, boolean isId) {
        this.binaryPointer.reset(pos, len, isId);
        return this.binaryPointer;
    }

    @Override
    public OracleJsonDecimalImpl createNumber(byte[] raw, OracleJsonDecimal.TargetType type) {
        if (this.numberCache == null) {
            this.numberCache = super.createNumber(raw, type);
        } else {
            this.numberCache.reset(raw, type);
        }
        return this.numberCache;
    }

    public boolean toEntry(String key) {
        if (this.event != OracleJsonParser.Event.START_OBJECT) {
            throw new IllegalStateException();
        }
        OsonObjectImpl obj = (OsonObjectImpl)this.getCurrent();
        int offset = obj.getChildPosition(key);
        if (offset == -1) {
            return false;
        }
        this.currentChild[this.depth] = offset;
        this.event = OracleJsonParser.Event.KEY_NAME;
        this.state = State.AFTER_KEY;
        return true;
    }

    public void reset() {
        this.init();
    }

    private void setCurrent(OracleJsonStructure v) {
        this.currentChild[this.depth] = 0;
        this.depthStack[this.depth] = v;
        this.currentPrimitive = null;
    }

    private OracleJsonStructure getCurrent() {
        return this.depthStack[this.depth];
    }

    private void pop() {
        --this.depth;
        if (this.depth < 0) {
            this.state = State.FINISHED;
        }
    }

    private OracleJsonParser.Event nextChild() {
        int child = this.currentChild[this.depth];
        int n = this.depth;
        this.currentChild[n] = this.currentChild[n] + 1;
        int pos = ((OsonStructureImpl)((Object)this.depthStack[this.depth])).getChildOffset(child);
        this.pushDepth();
        OracleJsonValue v = (OracleJsonValue)OsonStructureImpl.getValueInternal(pos, this, this.ctx);
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.setCurrent((OracleJsonStructure)v);
            return OracleJsonParser.Event.START_OBJECT;
        }
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) {
            this.setCurrent((OracleJsonStructure)v);
            return OracleJsonParser.Event.START_ARRAY;
        }
        this.currentPrimitive = v;
        --this.depth;
        return this.OracleJsonTypeToEvent(v);
    }

    private OracleJsonParser.Event OracleJsonTypeToEvent(OracleJsonValue v) {
        switch (v.getOracleJsonType()) {
            case FALSE: {
                return OracleJsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return OracleJsonParser.Event.VALUE_NULL;
            }
            case DECIMAL: {
                return OracleJsonParser.Event.VALUE_DECIMAL;
            }
            case STRING: {
                return OracleJsonParser.Event.VALUE_STRING;
            }
            case TRUE: {
                return OracleJsonParser.Event.VALUE_TRUE;
            }
            case BINARY: {
                return OracleJsonParser.Event.VALUE_BINARY;
            }
            case DOUBLE: {
                return OracleJsonParser.Event.VALUE_DOUBLE;
            }
            case FLOAT: {
                return OracleJsonParser.Event.VALUE_FLOAT;
            }
            case INTERVALDS: {
                return OracleJsonParser.Event.VALUE_INTERVALDS;
            }
            case INTERVALYM: {
                return OracleJsonParser.Event.VALUE_INTERVALYM;
            }
            case DATE: {
                return OracleJsonParser.Event.VALUE_DATE;
            }
            case TIMESTAMP: {
                return OracleJsonParser.Event.VALUE_TIMESTAMP;
            }
            case TIMESTAMPTZ: {
                return OracleJsonParser.Event.VALUE_TIMESTAMPTZ;
            }
            case VECTOR: {
                return OracleJsonParser.Event.VALUE_VECTOR;
            }
        }
        throw new IllegalStateException(v.toString());
    }

    private void pushDepth() {
        ++this.depth;
        if (this.depth >= this.depthStack.length) {
            this.expand();
        }
    }

    private void expand() {
        this.depthStack = Arrays.copyOf(this.depthStack, this.depthStack.length * 2);
        this.currentChild = Arrays.copyOf(this.currentChild, this.depthStack.length);
        this.objectCache = Arrays.copyOf(this.objectCache, this.depthStack.length);
        this.arrayCache = Arrays.copyOf(this.arrayCache, this.depthStack.length);
    }

    private OracleJsonParser.Event nextValue() {
        if (this.currentChild[this.depth] >= ((OsonStructureImpl)((Object)this.depthStack[this.depth])).size()) {
            if (this.depthStack[this.depth].getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
                this.pop();
                return OracleJsonParser.Event.END_OBJECT;
            }
            this.pop();
            return OracleJsonParser.Event.END_ARRAY;
        }
        if (this.depthStack[this.depth].getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            this.state = State.AFTER_KEY;
            return OracleJsonParser.Event.KEY_NAME;
        }
        return this.nextChild();
    }

    private void assertNumeric() {
        OracleJsonValue val = this.currentPrimitive == null ? this.getCurrent() : this.currentPrimitive;
        OracleJsonValue.OracleJsonType type = val.getOracleJsonType();
        if (type != OracleJsonValue.OracleJsonType.DECIMAL && type != OracleJsonValue.OracleJsonType.DOUBLE && type != OracleJsonValue.OracleJsonType.FLOAT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE3.create(this.ctx.getExceptionFactory(), new Object[]{this.event});
        }
    }

    private void assertJsonType(OracleJsonValue.OracleJsonType type) {
        if (this.depth < 0) {
            throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), type.toString());
        }
        switch (type) {
            case ARRAY: {
                if (this.currentPrimitive == null && this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.ARRAY) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), type.toString());
            }
            case OBJECT: {
                if (this.currentPrimitive == null && this.getCurrent().getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), type.toString());
            }
            default: {
                if (this.currentPrimitive != null && this.currentPrimitive.getOracleJsonType() == type) break;
                throw OracleJsonExceptions.BAD_PARSER_STATE.create(this.ctx.getExceptionFactory(), type.toString());
            }
        }
    }

    @Override
    public <T> T wrap(Class<T> wrapper) {
        try {
            if (Jsonp.isJakartaJsonStream(wrapper)) {
                return wrapper.cast(new JakartaParserWrapper(this));
            }
            return wrapper.cast(new JsonpParserWrapper(this));
        }
        catch (ClassCastException e) {
            throw OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, e, wrapper.getName());
        }
    }

    public long getStreamOffset() {
        if (this.state == State.START) {
            return 0L;
        }
        return -1L;
    }

    public OsonContext getContext() {
        return this.ctx;
    }

    public int getCurrentStringPos() {
        return this.stringPointer.getPos();
    }

    public int getCurrentStringLen() {
        return this.stringPointer.getLen();
    }

    private static enum State {
        START,
        NEXT_VALUE,
        AFTER_KEY,
        FINISHED;

    }

    private class BinaryPointer
    implements OracleJsonBinary {
        int pos;
        int len;
        boolean isId;

        private BinaryPointer() {
        }

        @Override
        public OracleJsonValue.OracleJsonType getOracleJsonType() {
            return OracleJsonValue.OracleJsonType.BINARY;
        }

        @Override
        public <T> T wrap(Class<T> wrapper) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString() {
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.position(this.pos);
            return ((OsonParserImpl)OsonParserImpl.this).ctx.b.readString(this.len);
        }

        @Override
        public byte[] getBytes() {
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.position(this.pos);
            byte[] res = new byte[this.len];
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.get(res);
            return res;
        }

        protected void getBytes(OutputStream out) throws IOException {
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.position(this.pos);
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.readBytes(out, this.len);
        }

        @Override
        public RAW getRAW() {
            return new RAW(this.getBytes());
        }

        @Override
        public boolean isId() {
            return this.isId;
        }

        public void reset(int pos, int len, boolean isId) {
            this.pos = pos;
            this.len = len;
            this.isId = isId;
        }
    }

    private class StringPointer
    implements OracleJsonString {
        int pos;
        int len;

        private StringPointer() {
        }

        @Override
        public OracleJsonValue.OracleJsonType getOracleJsonType() {
            return OracleJsonValue.OracleJsonType.STRING;
        }

        @Override
        public <T> T wrap(Class<T> wrapper) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString() {
            ((OsonParserImpl)OsonParserImpl.this).ctx.b.position(this.pos);
            return ((OsonParserImpl)OsonParserImpl.this).ctx.b.readString(this.len);
        }

        @Override
        public CharSequence getChars() {
            return this.getString();
        }

        @Override
        public CHAR getCHAR() {
            throw new UnsupportedOperationException();
        }

        public void reset(int pos, int len) {
            this.pos = pos;
            this.len = len;
        }

        public int getLen() {
            return this.len;
        }

        public int getPos() {
            return this.pos;
        }
    }
}

