/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.replay.ReplayableConnection;

class T4CSessionlessTransaction {
    static final int SESSIONLESS_TXN_DEFAULT_TIMEOUT = 60;
    static final int FTSTART = 1;
    static final int FTRESUME = 2;
    static final int FTSUSPEND = 3;
    static final int FTPRESUSPEND = 4;
    static final int FTPOSTSUSPEND = 5;
    private byte[] GTRID = null;
    private int piggyBackQueueMaxSize = 5;
    private int[] operationsQueue = new int[this.piggyBackQueueMaxSize];
    private boolean[] postCallSuspQueue = new boolean[this.piggyBackQueueMaxSize];
    private int[] timeoutsQueue = new int[this.piggyBackQueueMaxSize];
    private byte[][] gtridsQueue = new byte[this.piggyBackQueueMaxSize][];
    private int[] sequenceNumQueue = new int[this.piggyBackQueueMaxSize];
    private int queueTailIndex = 0;
    private T4CConnection conn;

    T4CSessionlessTransaction(T4CConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        this.conn = connection;
    }

    private void setPiggyBackParameters(int operation, boolean postCallSuspend, byte[] GTRID, int timeout, int messageIndex) {
        this.operationsQueue[messageIndex] = operation;
        this.postCallSuspQueue[messageIndex] = postCallSuspend;
        this.timeoutsQueue[messageIndex] = timeout;
        this.gtridsQueue[messageIndex] = GTRID;
    }

    void resetQueueOfPiggyBackMessages() {
        for (int index = 0; index != this.piggyBackQueueMaxSize && this.operationsQueue[index] != 0; ++index) {
            this.setPiggyBackParameters(0, false, null, 60, index);
            this.sequenceNumQueue[index] = 0;
        }
        this.queueTailIndex = 0;
    }

    private void nextPiggyBackMessage() {
        if (this.queueTailIndex == this.piggyBackQueueMaxSize - 1) {
            int newSize = this.piggyBackQueueMaxSize * 2;
            int[] operationsQueue2 = new int[newSize];
            boolean[] postCallSuspQueue2 = new boolean[newSize];
            int[] timeoutsQueue2 = new int[newSize];
            byte[][] gtridsQueue2 = new byte[newSize][];
            int[] sequenceNumQueue2 = new int[newSize];
            System.arraycopy(this.operationsQueue, 0, operationsQueue2, 0, this.piggyBackQueueMaxSize);
            System.arraycopy(this.postCallSuspQueue, 0, postCallSuspQueue2, 0, this.piggyBackQueueMaxSize);
            System.arraycopy(this.timeoutsQueue, 0, timeoutsQueue2, 0, this.piggyBackQueueMaxSize);
            System.arraycopy(this.gtridsQueue, 0, gtridsQueue2, 0, this.piggyBackQueueMaxSize);
            System.arraycopy(this.sequenceNumQueue, 0, sequenceNumQueue2, 0, this.piggyBackQueueMaxSize);
            this.operationsQueue = operationsQueue2;
            this.postCallSuspQueue = postCallSuspQueue2;
            this.timeoutsQueue = timeoutsQueue2;
            this.gtridsQueue = gtridsQueue2;
            this.sequenceNumQueue = sequenceNumQueue2;
            this.piggyBackQueueMaxSize = newSize;
        }
        ++this.queueTailIndex;
    }

    private void doSessionlessTransaction(int operation, boolean postCallSuspend, byte[] GTRID, int timeout, int msgIndex) throws SQLException {
        try {
            byte[] xid = null;
            int gtrid_l = 0;
            int bqual_l = 0;
            if (operation == 1 || operation == 2) {
                if (GTRID == null) {
                    throw new IllegalArgumentException("GTRID cannot be null");
                }
                byte[] globalId = GTRID;
                byte[] bqual = this.conn.getServerSessionInfo("INSTANCE_NAME").getBytes();
                gtrid_l = Math.min(globalId.length, 64);
                bqual_l = Math.min(bqual.length, 64);
                xid = new byte[128];
                System.arraycopy(globalId, 0, xid, 0, gtrid_l);
                System.arraycopy(bqual, 0, xid, gtrid_l, bqual_l);
            }
            int[] applicationValueArr = new int[1];
            int t4cflag = 16;
            int otxeOperation = 0;
            boolean doPig = false;
            if (postCallSuspend) {
                otxeOperation |= 4;
                doPig = true;
            }
            switch (operation) {
                case 1: {
                    otxeOperation |= 1;
                    t4cflag |= 1;
                    doPig = true;
                    break;
                }
                case 2: {
                    otxeOperation |= 1;
                    t4cflag |= 4;
                    doPig = true;
                    break;
                }
                case 3: {
                    if (postCallSuspend) break;
                    otxeOperation |= 2;
                    doPig = false;
                    break;
                }
                case 5: {
                    if (postCallSuspend) break;
                    throw new IllegalStateException("Invalid sessionless txn operation.");
                }
                case 4: {
                    if (!postCallSuspend) {
                        otxeOperation |= 2;
                        doPig = true;
                        break;
                    }
                }
                default: {
                    throw new IllegalStateException("Invalid sessionless txn operation.");
                }
            }
            if (doPig) {
                this.conn.pigOtxse.doOTXSE(otxeOperation, null, xid, 5135422, gtrid_l, bqual_l, timeout, t4cflag, applicationValueArr, doPig);
                this.sequenceNumQueue[msgIndex] = this.conn.pigOtxse.sequenceNumber;
            } else {
                this.conn.otxse.doOTXSE(otxeOperation, null, xid, 5135422, gtrid_l, bqual_l, timeout, t4cflag, applicationValueArr, doPig);
            }
        }
        catch (IOException ioe) {
            throw (SQLException)DatabaseError.createSqlException(this.conn.getConnectionDuringExceptionHandling(), ioe).fillInStackTrace();
        }
    }

    void ensureSessionlessTxnIsSupported() throws SQLException {
        if (!this.conn.hasServerCompileTimeCapability(44, 32)) {
            throw DatabaseError.createSqlException(this.conn.getConnectionDuringExceptionHandling(), 26207);
        }
    }

    void disallowMixUseOfXAandSessionlessAPIs(int txnMode) throws SQLException {
        if (this.conn.inSessionlessTxnMode() && txnMode != this.conn.getTxnMode()) {
            throw DatabaseError.createSqlException(this.conn.getConnectionDuringExceptionHandling(), 1743);
        }
    }

    void doStartOrResume(byte[] GTRID, int timeout, int operation, int txnMode) throws SQLException {
        if (operation != 1 && operation != 2) {
            throw new IllegalArgumentException("Invalid operation!");
        }
        this.ensureSessionlessTxnIsSupported();
        this.disallowMixUseOfXAandSessionlessAPIs(txnMode);
        if (timeout < 0) {
            throw DatabaseError.createSqlException(this.conn.getConnectionDuringExceptionHandling(), 26206);
        }
        if (this.conn.getAutoCommit()) {
            throw DatabaseError.createSqlException(this.conn.getConnectionDuringExceptionHandling(), 1742);
        }
        if (GTRID == null || GTRID.length == 0 || GTRID.length > 64) {
            throw DatabaseError.createSqlException(this.conn.getConnectionDuringExceptionHandling(), 26200);
        }
        if (this.operationsQueue[this.queueTailIndex] != 0) {
            if (this.operationsQueue[this.queueTailIndex] == 5) {
                throw new IllegalStateException("No piggy back operation can follow a post call suspend");
            }
            this.nextPiggyBackMessage();
        }
        if (txnMode == 3) {
            this.enterXASessionlessTxnMode();
        } else {
            this.enterSessionlessTxnMode();
        }
        this.GTRID = (byte[])GTRID.clone();
        this.operationsQueue[this.queueTailIndex] = operation;
        this.timeoutsQueue[this.queueTailIndex] = timeout;
        this.gtridsQueue[this.queueTailIndex] = this.GTRID;
    }

    void doSuspendImmediately() throws SQLException {
        this.ensureSessionlessTxnIsSupported();
        this.disallowMixUseOfXAandSessionlessAPIs(2);
        this.GTRID = null;
        this.doSessionlessTransaction(3, false, this.GTRID, 0, 0);
    }

    void doPreCallSuspend(int txnMode) throws SQLException {
        this.ensureSessionlessTxnIsSupported();
        this.disallowMixUseOfXAandSessionlessAPIs(txnMode);
        if (this.operationsQueue[this.queueTailIndex] != 0) {
            if (this.operationsQueue[this.queueTailIndex] == 5) {
                throw new IllegalStateException("No piggy back operation can follow a post call suspend");
            }
            this.nextPiggyBackMessage();
        }
        this.operationsQueue[this.queueTailIndex] = 4;
        this.GTRID = null;
    }

    void doPostCallSuspend() throws SQLException {
        this.ensureSessionlessTxnIsSupported();
        this.disallowMixUseOfXAandSessionlessAPIs(2);
        if (this.operationsQueue[this.queueTailIndex] != 0) {
            if (this.operationsQueue[this.queueTailIndex] == 4) {
                this.nextPiggyBackMessage();
            } else {
                if (this.operationsQueue[this.queueTailIndex] == 5) {
                    throw new IllegalStateException("No piggy back operation can follow a post call suspend");
                }
                this.postCallSuspQueue[this.queueTailIndex] = true;
                return;
            }
        }
        this.operationsQueue[this.queueTailIndex] = 5;
        this.postCallSuspQueue[this.queueTailIndex] = true;
        this.GTRID = null;
    }

    void sendPiggyBackMessages() throws SQLException {
        for (int index = 0; index != this.piggyBackQueueMaxSize && this.operationsQueue[index] != 0; ++index) {
            this.doSessionlessTransaction(this.operationsQueue[index], this.postCallSuspQueue[index], this.gtridsQueue[index], this.timeoutsQueue[index], index);
        }
    }

    int getLastPiggyBackOperation() {
        return this.operationsQueue[this.queueTailIndex];
    }

    boolean lastPiggyBackOpIsPostCallSuspend() {
        return this.postCallSuspQueue[this.queueTailIndex];
    }

    int[] getListOfPiggyBackMessagesSequenceNumbers() {
        return Arrays.copyOfRange(this.sequenceNumQueue, 0, this.queueTailIndex + 1);
    }

    byte[] getGTRID() {
        return this.GTRID != null ? (byte[])this.GTRID.clone() : null;
    }

    void setGTRID(byte[] GTRID) {
        this.GTRID = GTRID != null ? (byte[])GTRID.clone() : null;
    }

    void exitSessionlessTxnMode() {
        this.conn.setTxnMode(0);
    }

    void enterSessionlessTxnMode() throws SQLException {
        if (this.conn.acProxy != null) {
            ((ReplayableConnection)this.conn.acProxy).disableReplay();
        }
        this.conn.setTxnMode(2);
    }

    void enterXASessionlessTxnMode() throws SQLException {
        if (this.conn.acProxy != null) {
            ((ReplayableConnection)this.conn.acProxy).disableReplay();
        }
        this.conn.setTxnMode(3);
    }
}

