/*
 * Decompiled with CFR 0.152.
 */
package oracle.simplefan.impl;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.simplefan.impl.FanSubscription;

public final class FanManager
extends oracle.simplefan.FanManager {
    static final Logger logger = Logger.getLogger("oracle.simplefan.FanManager");
    private boolean isConfigured = false;
    private ONS ons = null;
    static final Pattern onsMaskPattern = Pattern.compile("(walletfile=|walletpassword=).*(\n|$)");

    public static final FanManager getInstanceInternal() {
        return new FanManager();
    }

    @Override
    public final synchronized void configure(Properties properties) {
        String string;
        String string2;
        if (this.isConfigured) {
            logger.warning("attempt to configure FanManager more than once");
            throw new IllegalStateException("attempt to configure oracle.simplefan.FanManager more than once");
        }
        String string3 = properties.getProperty("onsRemoteConfig");
        if (string3 != null && !"".equals(string3)) {
            string2 = string3;
            string = FanManager.maskONSConfigurationString(string2);
            logger.config("creating ONS: " + string);
        } else {
            string = "";
            String string4 = "";
            String string5 = "";
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                if (string6.equals("onsNodes")) {
                    string = properties.getProperty(string6);
                    continue;
                }
                if (string6.equals("onsWalletFile")) {
                    string4 = properties.getProperty(string6);
                    continue;
                }
                if (string6.equals("onsWalletPassword")) {
                    string5 = properties.getProperty(string6);
                    continue;
                }
                logger.severe("unrecognized property while configuring FanManager");
                throw new IllegalArgumentException("unrecognized property \"" + string6 + "\"");
            }
            string2 = "nodes=" + string + "\n" + (string4 == "" ? "" : "walletfile=" + string4 + "\n") + (string5 == "" ? "" : "walletpassword=" + string5 + "\n");
            logger.config("creating ONS: nodes=\"" + string + "\" walletfile=\"" + string4 + "\" walletpassword=\"" + "********************************************************************".substring(0, string5.length()) + "\"");
        }
        try {
            this.ons = AccessController.doPrivileged(new PrivilegedExceptionAction<ONS>(){

                @Override
                public ONS run() throws ONSException {
                    return new ONS(string2);
                }
            });
        }
        catch (Exception exception) {
            logger.severe("attempt to configure ONS in FanManager failed with " + exception);
            throw new IllegalArgumentException("ONS configuration failed", exception);
        }
        logger.config("ONS created");
        this.isConfigured = true;
    }

    static String maskONSConfigurationString(String string) {
        return string == null || "".equals(string) ? "" : onsMaskPattern.matcher(string).replaceAll("*****");
    }

    @Override
    public final synchronized oracle.simplefan.FanSubscription subscribe(Properties properties) {
        FanSubscription fanSubscription;
        String string = properties.getProperty("serviceName");
        if (string == null || string.length() == 0) {
            logger.severe("attempt to create FanSubscription with null serviceName");
            throw new IllegalArgumentException("serviceName is null");
        }
        if (properties.size() != 1) {
            logger.severe("attempt to create FanSubscription with unknown property");
            throw new IllegalArgumentException("unrecognized property");
        }
        try {
            fanSubscription = this.ons == null ? FanSubscription.createFanSubscription(string) : FanSubscription.createFanSubscription(this.ons, string);
        }
        catch (ONSException oNSException) {
            logger.severe("attempt to create FanSubscription failed");
            throw new IllegalArgumentException("unable to create ONS subscriber with properties provided", oNSException);
        }
        logger.finest("attempt to create FanSubscription succeeded");
        this.isConfigured = true;
        return fanSubscription;
    }
}

