/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import oracle.ons.Message;
import oracle.ons.Notification;
import oracle.ons.NotificationNetwork;
import oracle.ons.SubscribePermission;
import oracle.ons.Subscriber;

class SubscriptionProxy {
    private final Map<Integer, WeakReference<Subscriber>> frontendSubscribers = new ConcurrentHashMap<Integer, WeakReference<Subscriber>>();
    private final NotificationNetwork network;
    private final Map<Notification.NotificationKey, Notification.NotificationKey> notificationHistory = new ConcurrentHashMap<Notification.NotificationKey, Notification.NotificationKey>();
    private final Queue<Notification.NotificationKey> notificationHistoryTimeouts = new LinkedList<Notification.NotificationKey>();
    private final String subscriptionKey;
    protected final Message subscriptionMessage;
    private volatile Notification registrationNotification = null;

    public SubscriptionProxy(NotificationNetwork network, Subscriber subscriber) {
        this.add(subscriber);
        this.subscriptionKey = subscriber.getSubscriptionKey();
        this.subscriptionMessage = subscriber.getSubscriptionMessage();
        this.network = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(Notification n) throws InterruptedException {
        ++this.network.messageReceived;
        if (n.getKey() != null) {
            long windowStart = System.currentTimeMillis() - this.network.config.getNotificationWindow();
            Notification.NotificationKey key = this.notificationHistory.get(n.getKey());
            if (key != null) {
                ++this.network.messageDropped;
                return;
            }
            SubscriptionProxy subscriptionProxy = this;
            synchronized (subscriptionProxy) {
                while (!this.notificationHistoryTimeouts.isEmpty() && this.notificationHistoryTimeouts.peek().expired(windowStart)) {
                    this.notificationHistory.remove(this.notificationHistoryTimeouts.remove());
                }
                this.notificationHistoryTimeouts.add(n.getKey());
            }
            this.notificationHistory.put(n.getKey(), n.getKey());
        }
        for (WeakReference<Subscriber> s : this.frontendSubscribers.values()) {
            Subscriber subscriber = (Subscriber)s.get();
            if (subscriber == null) continue;
            subscriber.put(n);
        }
    }

    public void add(Subscriber s) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SubscribePermission("ONSUser"));
        }
        this.frontendSubscribers.put(s.id, new WeakReference<Subscriber>(s));
        if (this.registrationNotification != null) {
            try {
                s.put(this.registrationNotification);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    synchronized void setRegistrationNotification(Notification n) {
        this.registrationNotification = n;
    }

    public void remove(Subscriber subscriber) {
        this.frontendSubscribers.remove(subscriber.id);
    }

    public String getSubscriptionKey() {
        return this.subscriptionKey;
    }

    public boolean isEmpty() {
        return this.frontendSubscribers.isEmpty();
    }
}

