/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.java.container;

import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.runtime.java.container.AbstractScope;
import com.oracle.bedrock.runtime.java.container.ContainerMBeanServerBuilder;
import com.oracle.bedrock.runtime.network.AvailablePortIterator;
import java.util.Map;
import java.util.Properties;

@Internal
public abstract class AbstractContainerScope
extends AbstractScope {
    private ContainerMBeanServerBuilder mBeanServerBuilder;

    public AbstractContainerScope(String name, Properties properties, AvailablePortIterator availablePorts, ContainerMBeanServerBuilder mBeanServerBuilder) {
        super(name, new Properties(), availablePorts);
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        this.mBeanServerBuilder = mBeanServerBuilder == null ? new ContainerMBeanServerBuilder(this.availablePorts) : mBeanServerBuilder;
    }

    public ContainerMBeanServerBuilder getMBeanServerBuilder() {
        return this.mBeanServerBuilder;
    }

    @Override
    public boolean close() {
        if (super.close()) {
            this.mBeanServerBuilder.close();
            return true;
        }
        return false;
    }
}

