/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class Version
implements Comparable<Version> {
    private static final HashMap<String, String> QUALIFIER_ALIASES = new HashMap();
    private ArrayList components = new ArrayList();

    private Version(String ... strings) {
        if (strings == null) {
            this.components.add("0");
        } else {
            for (String number : strings) {
                number = number == null ? "" : number.trim().toLowerCase(Locale.ENGLISH);
                StringBuilder collector = new StringBuilder();
                char last = '\u0000';
                for (char c : number.toCharArray()) {
                    if (Character.isDigit(c)) {
                        if (!Character.isDigit(last) && collector.length() != 0) {
                            this.components.add(this.expand(collector.toString()));
                            collector = new StringBuilder();
                        }
                        collector.append(c);
                        last = c;
                        continue;
                    }
                    if (Character.isLetter(c)) {
                        if (!Character.isLetter(last) && collector.length() != 0) {
                            this.components.add(Integer.parseInt(collector.toString()));
                            collector = new StringBuilder();
                        }
                        collector.append(c);
                        last = c;
                        continue;
                    }
                    if (c != '.' && c != 45) break;
                    if (last == '\u0000') {
                        this.components.add(0);
                    } else if (Character.isDigit(last)) {
                        this.components.add(Integer.parseInt(collector.toString()));
                    } else if (Character.isLetter(last)) {
                        this.components.add(this.expand(collector.toString()));
                    }
                    collector = new StringBuilder();
                    last = '\u0000';
                }
                if (!this.components.isEmpty() && last == '\u0000') continue;
                if (last == '\u0000') {
                    this.components.add(0);
                    continue;
                }
                if (Character.isDigit(last)) {
                    this.components.add(Integer.parseInt(collector.toString()));
                    continue;
                }
                if (!Character.isLetter(last)) continue;
                this.components.add(this.expand(collector.toString()));
            }
        }
    }

    private String expand(String qualifier) {
        return QUALIFIER_ALIASES.getOrDefault(qualifier, qualifier);
    }

    public static Version of(String ... strings) {
        return new Version(strings);
    }

    public static Version unknown() {
        return new Version("unknown");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.components.equals(version.components);
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        for (int i = 0; i < Math.max(this.components.size(), other.components.size()); ++i) {
            Integer y;
            Integer x = i < this.components.size() ? this.components.get(i) : Integer.valueOf(0);
            Integer n = y = i < other.components.size() ? other.components.get(i) : Integer.valueOf(0);
            if (x instanceof Integer && y instanceof Integer) {
                if (((Object)x).equals(y)) continue;
                return x.compareTo(y);
            }
            if (x instanceof Integer && y instanceof String) {
                return 1;
            }
            if (x instanceof String && y instanceof Integer) {
                return -1;
            }
            if (((Object)x).equals(y)) continue;
            return ((String)((Object)x)).compareTo((String)((Object)y));
        }
        return 0;
    }

    public int hashCode() {
        return this.components.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Object component : this.components) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(component);
        }
        return builder.toString();
    }

    static {
        QUALIFIER_ALIASES.put("a", "alpha");
        QUALIFIER_ALIASES.put("b", "beta");
        QUALIFIER_ALIASES.put("m", "milestone");
        QUALIFIER_ALIASES.put("r", "release");
        QUALIFIER_ALIASES.put("rc", "release candidate");
        QUALIFIER_ALIASES.put("sp", "service pack");
    }
}

