/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ProxyHelper {
    public static <T> T createProxyOf(T object, Object interceptor) {
        return (T)ProxyHelper.createProxyOf(object.getClass(), interceptor);
    }

    public static <T> T createProxyOf(Class<T> clazz, final Interceptor interceptor) {
        return (T)Mockito.mock(clazz, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Method method = invocation.getMethod();
                Object[] arguments = invocation.getArguments();
                if (method.isVarArgs()) {
                    int count = method.getParameterCount();
                    Object[] params = new Object[count];
                    int varargsIndex = count - 1;
                    System.arraycopy(arguments, 0, params, 0, varargsIndex);
                    Class<?> varargsClass = method.getParameterTypes()[varargsIndex];
                    int varargsLength = arguments.length - varargsIndex;
                    Object varargs = Array.newInstance(varargsClass.getComponentType(), new int[]{varargsLength});
                    for (int i = 0; i < varargsLength; ++i) {
                        Array.set(varargs, i, arguments[varargsIndex + i]);
                    }
                    params[varargsIndex] = varargs;
                    return interceptor.intercept(method, params);
                }
                return interceptor.intercept(method, arguments);
            }
        });
    }

    public static interface Interceptor {
        public Object intercept(Method var1, Object[] var2) throws Throwable;
    }
}

