/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.util;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class Capture<T>
implements Iterator<T> {
    private final Supplier<Iterator<T>> supplier;
    private volatile Iterator<T> iterator;
    private volatile AtomicReference<T> capture;

    public Capture(Iterator<T> iterator) {
        this(() -> iterator);
    }

    public Capture(Supplier<Iterator<T>> supplier) {
        this.supplier = supplier;
        this.capture = null;
    }

    public boolean hasValue() {
        return this.capture != null;
    }

    public T get() {
        return this.next();
    }

    @Override
    public boolean hasNext() {
        return this.hasValue() || this.ensureIterator().hasNext();
    }

    @Override
    public T next() {
        if (!this.hasValue()) {
            this.capture = new AtomicReference<T>(this.ensureIterator().next());
        }
        return this.capture.get();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from a Capture");
    }

    private synchronized Iterator<T> ensureIterator() {
        if (this.iterator == null) {
            Iterator<T> it = this.supplier.get();
            if (it == null) {
                throw new IllegalStateException("The iterator supplier returned null");
            }
            this.iterator = it;
        }
        return this.iterator;
    }

    public static <T> Capture<T> of(Supplier<Iterator<T>> supplier) {
        return new Capture<T>(supplier);
    }

    public static <T> Capture<T> of(Iterator<T> iterator) {
        return new Capture<T>(iterator);
    }
}

