/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.table;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Table
implements Iterable<Row>,
Option {
    private ArrayList<Row> rows = new ArrayList();
    private OptionsByType optionsByType;

    public Table(Row ... rows) {
        if (rows != null) {
            for (Row row : rows) {
                this.rows.add(row);
            }
        }
        this.optionsByType = OptionsByType.empty();
    }

    public static Row.Comparator orderByColumn(final int column) {
        return new Row.Comparator(){

            @Override
            public int compare(Row row1, Row row2) {
                return row1.getCell(column).getLine(0).compareTo(row2.getCell(column).getLine(0));
            }
        };
    }

    public OptionsByType getOptions() {
        return this.optionsByType;
    }

    public Table addRow(Row row) {
        this.rows.add(row);
        return this;
    }

    public Table addRow(Cell ... cells) {
        return this.addRow(new Row(cells));
    }

    public Table addRow(String ... cells) {
        if (cells == null) {
            return this;
        }
        Row row = new Row(new Cell[0]);
        for (String cell : cells) {
            row.addCell(cell);
        }
        return this.addRow(row);
    }

    public Row getRow(int index) {
        if (index < 0 || index >= this.rows.size()) {
            return null;
        }
        return this.rows.get(index);
    }

    public int size() {
        return this.rows.size();
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rows.iterator();
    }

    public String toString() {
        Cell.Separator cellSeparator = this.optionsByType.get(Cell.Separator.class, new Object[0]);
        ArrayList<Integer> cellWidths = new ArrayList<Integer>();
        for (Row row : this) {
            int rowWidth = row.width();
            while (cellWidths.size() < rowWidth) {
                cellWidths.add(0);
            }
            int i = 0;
            for (Cell cell : row) {
                int cellWidth;
                int currentWidth = (Integer)cellWidths.get(i);
                Cell.Width width = cell.getOptions().getOrDefault(Cell.Width.class, row.getOptions().getOrDefault(Cell.Width.class, this.getOptions().get(Cell.Width.class, new Object[0])));
                if (width.isAutoDetect()) {
                    cellWidth = cell.width();
                    if (cell.containsNull()) {
                        Cell.DisplayNull displayNull = cell.getOptions().getOrDefault(Cell.DisplayNull.class, row.getOptions().getOrDefault(Cell.DisplayNull.class, this.getOptions().get(Cell.DisplayNull.class, new Object[0])));
                        cellWidth = Math.max(cellWidth, displayNull.getValue().length());
                    }
                } else {
                    cellWidth = width.getCharacters();
                }
                if (cellWidth > currentWidth) {
                    cellWidths.set(i, cellWidth);
                }
                ++i;
            }
        }
        Row.Comparator comparator = this.optionsByType.get(Row.Comparator.class, new Object[0]);
        Row[] orderedRows = new Row[this.rows.size()];
        this.rows.toArray(orderedRows);
        if (comparator != null) {
            Arrays.sort(orderedRows, comparator);
        }
        StringBuilder builder = new StringBuilder();
        for (int rowIndex = 0; rowIndex < orderedRows.length; ++rowIndex) {
            int rowHeight;
            Row row = orderedRows[rowIndex];
            if (rowIndex > 0) {
                builder.append("\n");
            }
            int line = 0;
            do {
                rowHeight = 0;
                int rowWidth = row.width();
                for (int cellIndex = 0; cellIndex < rowWidth; ++cellIndex) {
                    String justifiedContent;
                    Cell cell = row.getCell(cellIndex);
                    Cell.Justification justification = cell.getOptions().getOrDefault(Cell.Justification.class, row.getOptions().getOrDefault(Cell.Justification.class, this.getOptions().get(Cell.Justification.class, new Object[0])));
                    int cellHeight = cell.height();
                    int n = rowHeight = cellHeight > rowHeight ? cellHeight : rowHeight;
                    if (cell.isEmpty() || line >= cellHeight) {
                        if (cellIndex > 0) {
                            builder.append(" ");
                            builder.append(cellSeparator.getSeparator());
                            builder.append(" ");
                        }
                        justifiedContent = justification.format("", (Integer)cellWidths.get(cellIndex));
                    } else {
                        String content;
                        if (cellIndex > 0) {
                            builder.append(" ");
                            builder.append(cellSeparator.getSeparator());
                            builder.append(" ");
                        }
                        if ((content = cell.getLine(line)) == null) {
                            Cell.DisplayNull displayNull = cell.getOptions().getOrDefault(Cell.DisplayNull.class, row.getOptions().getOrDefault(Cell.DisplayNull.class, this.getOptions().get(Cell.DisplayNull.class, new Object[0])));
                            content = displayNull.getValue();
                        }
                        justifiedContent = justification.format(content, (Integer)cellWidths.get(cellIndex));
                    }
                    if (cellIndex == rowWidth - 1) {
                        justifiedContent = StringHelper.trimTrailingWhiteSpace(justifiedContent);
                    }
                    builder.append(justifiedContent);
                }
                if (++line >= rowHeight) continue;
                builder.append("\n");
            } while (line < rowHeight);
        }
        return builder.toString();
    }
}

