/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.predicate;

import com.oracle.bedrock.predicate.AllOf;
import com.oracle.bedrock.predicate.Always;
import com.oracle.bedrock.predicate.Contains;
import com.oracle.bedrock.predicate.EqualTo;
import com.oracle.bedrock.predicate.GreaterThan;
import com.oracle.bedrock.predicate.Is;
import com.oracle.bedrock.predicate.IsNot;
import com.oracle.bedrock.predicate.IsNull;
import com.oracle.bedrock.predicate.LessThan;
import com.oracle.bedrock.predicate.Never;
import java.util.Collection;
import java.util.function.Predicate;

public class Predicates {
    public static <T> Predicate<T> allOf(Predicate<T> ... predicates) {
        return new AllOf<T>(predicates);
    }

    public static <T> Predicate<T> always() {
        return new Always();
    }

    public static <T> Predicate<Collection<T>> contains(T value) {
        return new Contains<T>(value);
    }

    public static <T> Predicate<Collection<T>> doesNotContain(T value) {
        return Predicates.isNot(new Contains<T>(value));
    }

    public static <T> Predicate<T> equalTo(T value) {
        return new EqualTo<T>(value);
    }

    public static <T extends Comparable<T>> Predicate<T> greaterThan(T value) {
        return new GreaterThan<T>(value);
    }

    public static <T> Predicate<T> is(Predicate<T> predicate) {
        return new Is<T>(predicate);
    }

    public static <T> Predicate<T> is(T value) {
        return new Is<T>(new EqualTo<T>(value));
    }

    public static <T> Predicate<T> isNot(Predicate<T> predicate) {
        return new IsNot<T>(predicate);
    }

    public static <T> Predicate<T> isNot(T value) {
        return new IsNot<T>(new EqualTo<T>(value));
    }

    public static <T> Predicate<T> isNull() {
        return new IsNull();
    }

    public static <T extends Comparable<T>> Predicate<T> lessThan(T value) {
        return new LessThan<T>(value);
    }

    public static <T> Predicate<T> never() {
        return new Never();
    }
}

