/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.options.Decoration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class Decorations
implements Option.Collector<Decoration, Decorations> {
    private LinkedHashSet<Decoration> decorations = new LinkedHashSet();

    @OptionsByType.Default
    public Decorations() {
    }

    public Decorations(Decoration ... decorations) {
        this();
        if (decorations != null) {
            for (Decoration decoration : decorations) {
                this.add(decoration);
            }
        }
    }

    public Decorations(Decorations decorations) {
        this();
        this.decorations.addAll(decorations.decorations);
    }

    public int size() {
        return this.decorations.size();
    }

    public boolean isEmpty() {
        return this.decorations.isEmpty();
    }

    public Decorations add(Decoration decoration) {
        if (decoration == null) {
            return this;
        }
        Decorations result = new Decorations(this);
        result.decorations.add(decoration);
        return result;
    }

    public Decorations remove(Decoration decoration) {
        if (decoration == null || !this.decorations.contains(decoration)) {
            return this;
        }
        Decorations result = new Decorations(this);
        result.decorations.remove(decoration);
        return result;
    }

    public Decorations addAll(Decorations decorations) {
        Decorations result = new Decorations(this);
        for (Decoration decoration : decorations) {
            result.decorations.add(decoration);
        }
        return result;
    }

    public boolean contains(Decoration decoration) {
        return this.decorations.contains(decoration);
    }

    public <T> T get(Class<T> requiredClass) {
        for (Decoration decoration : this.decorations) {
            if (!requiredClass.isInstance(decoration.get())) continue;
            return (T)decoration.get();
        }
        return null;
    }

    @Override
    public Decorations with(Decoration decoration) {
        return this.add(decoration);
    }

    @Override
    public Decorations without(Decoration decoration) {
        return this.remove(decoration);
    }

    @Override
    public Iterator<Decoration> iterator() {
        return this.decorations.iterator();
    }

    @Override
    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Decoration decoration : this.decorations) {
            if (requiredClass.isInstance(decoration)) {
                result.add(decoration);
            }
            if (!requiredClass.isInstance(decoration.get())) continue;
            result.add(decoration.get());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Decorations)) {
            return false;
        }
        Decorations that = (Decorations)o;
        return this.decorations.equals(that.decorations);
    }

    public int hashCode() {
        return this.decorations.hashCode();
    }
}

