/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.io;

import com.oracle.bedrock.predicate.Predicates;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public class NetworkHelper {
    public static final Predicate<InetAddress> LOOPBACK_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean test(InetAddress address) {
            return address != null && address.isLoopbackAddress();
        }

        public String toString() {
            return "LOOPBACK";
        }
    };
    public static final Predicate<InetAddress> NON_LOOPBACK_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean test(InetAddress address) {
            return address != null && !address.isLoopbackAddress();
        }

        public String toString() {
            return "NON-LOOPBACK";
        }
    };
    public static final Predicate<InetAddress> IPv4_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean test(InetAddress address) {
            return address instanceof Inet4Address;
        }

        public String toString() {
            return "IPv4-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> IPv6_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean test(InetAddress address) {
            return address instanceof Inet6Address;
        }

        public String toString() {
            return "IPv6-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> LINK_LOCAL_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean test(InetAddress address) {
            return address != null && address.isLinkLocalAddress();
        }

        public String toString() {
            return "LINK-LOCAL-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> ANY_LOCAL_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean test(InetAddress address) {
            return address != null && address.isAnyLocalAddress();
        }

        public String toString() {
            return "ANY-LOCAL-ADDRESS";
        }
    };
    public static final Predicate<InetAddress> DEFAULT_ADDRESS = new Predicate<InetAddress>(){

        @Override
        public boolean test(InetAddress address) {
            Predicate<InetAddress> predicate = Boolean.getBoolean("java.net.preferIPv4Stack") ? IPv4_ADDRESS : (Boolean.getBoolean("java.net.preferIPv6Addresses") ? IPv6_ADDRESS : Predicates.always());
            return predicate.test(address);
        }
    };
    public static final Predicate<InetAddress> BINDABLE_ADDRESS = new Predicate<InetAddress>(){

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean test(InetAddress address) {
            try (ServerSocket serverSocket = new ServerSocket(0, 1, address);){
                DatagramSocket datagramSocket = new DatagramSocket(0, address);
                try {
                    boolean bl = true;
                    datagramSocket.close();
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        datagramSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return false;
            }
        }

        public String toString() {
            return "BINDABLE_ADDRESS";
        }
    };

    public static InetAddress getInetAddress(Predicate<? super InetAddress> predicate) throws SocketException {
        for (NetworkInterface networkInterface : NetworkHelper.getNetworkInterfaces(Predicates.always())) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!predicate.test(address)) continue;
                return address;
            }
        }
        return null;
    }

    public static List<InetAddress> getInetAddresses(Iterable<InetAddress> addresses, Predicate<? super InetAddress> predicate) {
        LinkedList<InetAddress> addressList = new LinkedList<InetAddress>();
        for (InetAddress address : addresses) {
            try {
                if (!predicate.test(address)) continue;
                addressList.add(address);
            }
            catch (Exception exception) {}
        }
        return addressList;
    }

    public static List<InetAddress> getInetAddresses(Predicate<? super InetAddress> predicate) {
        LinkedList<InetAddress> addressList = new LinkedList<InetAddress>();
        for (NetworkInterface networkInterface : NetworkHelper.getNetworkInterfaces(Predicates.always())) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                try {
                    if (!predicate.test(address)) continue;
                    addressList.add(address);
                }
                catch (Exception exception) {}
            }
        }
        return addressList;
    }

    public static List<NetworkInterface> getNetworkInterfaces(Predicate<? super NetworkInterface> predicate) {
        ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!predicate.test(networkInterface)) continue;
                networkInterfaces.add(networkInterface);
            }
            Collections.sort(networkInterfaces, new Comparator<NetworkInterface>(){

                @Override
                public int compare(NetworkInterface networkInterface1, NetworkInterface networkInterface2) {
                    return networkInterface1.getIndex() - networkInterface2.getIndex();
                }
            });
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return networkInterfaces;
    }

    public static InetAddress getFeasibleLocalHost() {
        try {
            InetAddress potentialInetAddress = null;
            for (NetworkInterface networkInterface : NetworkHelper.getNetworkInterfaces(Predicates.always())) {
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (!BINDABLE_ADDRESS.test(inetAddress) || inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress.isSiteLocalAddress()) {
                        return inetAddress;
                    }
                    if (potentialInetAddress != null) continue;
                    potentialInetAddress = inetAddress;
                }
            }
            if (potentialInetAddress == null) {
                potentialInetAddress = InetAddress.getLocalHost();
            }
            if (potentialInetAddress == null) {
                potentialInetAddress = InetAddress.getLoopbackAddress();
            }
            return potentialInetAddress;
        }
        catch (Exception e) {
            return InetAddress.getLoopbackAddress();
        }
    }

    public static InetAddress getWildcardAddress() {
        return new InetSocketAddress(0).getAddress();
    }
}

