/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileHelper {
    public static File createTemporaryFolder(String prefix) throws IOException {
        File systemTemporaryFolder = new File(System.getProperty("java.io.tmpdir"));
        int maximumAttempts = 100;
        File temporaryFolder = null;
        for (int attemptsRemaining = 100; attemptsRemaining > 0 && temporaryFolder == null; --attemptsRemaining) {
            String randomness = UUID.randomUUID().toString();
            temporaryFolder = new File(systemTemporaryFolder, prefix + randomness);
            if (temporaryFolder.exists()) {
                temporaryFolder = null;
                continue;
            }
            try {
                temporaryFolder.mkdir();
                return temporaryFolder;
            }
            catch (Exception e) {
                temporaryFolder = null;
            }
        }
        throw new IOException("Failed to create a unique temporary folder after 100 attempts.");
    }

    public static boolean recursiveDelete(File file) {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    if (FileHelper.recursiveDelete(child)) continue;
                    return false;
                }
            }
            return file.delete();
        }
        return true;
    }

    public static void zip(Iterable<File> files, String baseFolderName, String toZipFile) throws IOException {
        ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(toZipFile));
        if (files != null) {
            for (File file : files) {
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    FileHelper.addFolderToZip(file, baseFolderName, zip);
                    continue;
                }
                FileHelper.addFileToZip(file, baseFolderName, zip);
            }
        }
        zip.flush();
        zip.close();
    }

    private static void addFileToZip(File file, String parentFolderName, ZipOutputStream zip) throws IOException {
        String parent;
        String string = parent = parentFolderName == null || parentFolderName.trim().isEmpty() ? "" : parentFolderName.trim() + "/";
        if (file.exists()) {
            zip.putNextEntry(new ZipEntry(parent + file.getName()));
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[16096];
            int count = 0;
            while ((count = inputStream.read(buffer)) != -1) {
                zip.write(buffer, 0, count);
            }
            zip.closeEntry();
        }
    }

    private static void addFolderToZip(File folder, String parentFolderName, ZipOutputStream zip) throws IOException {
        File[] files;
        String parent;
        String string = parent = parentFolderName == null || parentFolderName.trim().isEmpty() ? "" : parentFolderName.trim() + "/";
        if (folder.exists() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileHelper.addFolderToZip(file, parent + file.getName(), zip);
                    continue;
                }
                FileHelper.addFileToZip(file, parentFolderName, zip);
            }
        }
    }
}

