/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.extensible;

import com.oracle.bedrock.extensible.Extensible;
import com.oracle.bedrock.extensible.Feature;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractExtensible
implements Extensible {
    private ConcurrentHashMap<Class, Object> features = new ConcurrentHashMap();

    @Override
    public <T> boolean has(Class<T> featureClass) {
        return featureClass != null && (featureClass.isInstance(this) || this.features.containsKey(featureClass));
    }

    @Override
    public <T> T get(Class<T> featureClass) {
        if (featureClass == null) {
            return null;
        }
        Object feature = this.features.get(featureClass);
        if (feature == null && featureClass.isInstance(this)) {
            feature = this;
        }
        return (T)feature;
    }

    @Override
    public <T> T add(Class<T> featureClass, T feature) {
        if (featureClass == null) {
            return null;
        }
        if (featureClass.isInstance(this)) {
            throw new UnsupportedOperationException("Can't add " + String.valueOf(featureClass) + " as it is directly implemented by " + this.getClass().getName());
        }
        if (feature instanceof Feature) {
            ((Feature)feature).onAddingTo(this);
        }
        return (T)this.features.put(featureClass, feature);
    }

    @Override
    public <T> T add(T feature) {
        return feature == null ? null : (T)this.add(feature.getClass(), feature);
    }

    @Override
    public <T> T remove(Class<T> featureClass) {
        if (featureClass == null) {
            return null;
        }
        if (featureClass.isInstance(this)) {
            throw new UnsupportedOperationException("Can't remove " + String.valueOf(featureClass) + " as it is directly implemented by " + this.getClass().getName());
        }
        Object feature = this.features.remove(featureClass);
        if (feature instanceof Feature) {
            ((Feature)feature).onRemovingFrom(this);
        }
        return (T)feature;
    }

    protected <T> Iterable<T> getInstancesOf(Class<T> requiredClass) {
        if (requiredClass == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList result = new LinkedList();
        this.features.values().forEach(feature -> {
            if (requiredClass.isInstance(feature)) {
                result.add(feature);
            }
        });
        return result;
    }

    protected void removeAllFeatures() {
        for (Map.Entry<Class, Object> entry : this.features.entrySet()) {
            this.remove(entry.getKey());
        }
    }
}

