/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.diagnostics;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.table.Cell;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiagnosticsRecording
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(DiagnosticsRecording.class.getName());
    private static ThreadLocal<Stack<DiagnosticsRecording>> recordings = new ThreadLocal<Stack<DiagnosticsRecording>>(){

        @Override
        protected Stack<DiagnosticsRecording> initialValue() {
            return new Stack<DiagnosticsRecording>();
        }
    };
    private DiagnosticsRecording parent;
    private String name;
    private Table table;
    private Logger logger;
    private Level level;

    public DiagnosticsRecording(String name) {
        this.parent = null;
        this.name = name;
        this.table = new Table(new Row[0]);
        this.logger = null;
        this.level = null;
        recordings.get().push(this);
    }

    public DiagnosticsRecording(DiagnosticsRecording parent, String name) {
        this.parent = parent;
        this.name = name;
        this.table = name == null ? parent.table : new Table(new Row[0]);
        this.logger = null;
        this.level = null;
        recordings.get().push(this);
    }

    public DiagnosticsRecording add(Row row) {
        if (row != null) {
            this.table.addRow(row);
        }
        return this;
    }

    public DiagnosticsRecording add(Cell ... cells) {
        if (cells != null) {
            this.table.addRow(cells);
        }
        return this;
    }

    public DiagnosticsRecording add(String ... cells) {
        if (cells != null) {
            this.table.addRow(cells);
        }
        return this;
    }

    public DiagnosticsRecording with(Option ... options) {
        if (options != null) {
            this.table.getOptions().addAll(options);
        }
        return this;
    }

    public DiagnosticsRecording using(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        return this;
    }

    public static DiagnosticsRecording create(String name) {
        return new DiagnosticsRecording(name);
    }

    public static DiagnosticsRecording continued() {
        if (recordings.get().isEmpty()) {
            return new DiagnosticsRecording("(undefined)");
        }
        return new DiagnosticsRecording(recordings.get().peek(), null);
    }

    public static DiagnosticsRecording section(String name) {
        if (recordings.get().isEmpty()) {
            return new DiagnosticsRecording(name);
        }
        return new DiagnosticsRecording(recordings.get().peek(), name);
    }

    @Override
    public void close() {
        DiagnosticsRecording recording = recordings.get().pop();
        if (this != recording) {
            throw new IllegalStateException("Attempted to close a DiagnosticRecording that was previously closed");
        }
        if (this.parent == null) {
            Level level;
            Logger logger = this.logger == null ? LOGGER : this.logger;
            Level level2 = level = this.level == null ? Level.INFO : this.level;
            if (level != Level.OFF && logger.isLoggable(level)) {
                logger.log(level, "Oracle Bedrock " + Bedrock.getVersion() + ": " + this.name + " ...\n------------------------------------------------------------------------\n" + this.table.toString() + "\n------------------------------------------------------------------------\n");
            }
        } else if (this.name != null) {
            this.parent.table.addRow(this.name, this.table.toString());
        }
    }
}

