/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred.options;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.util.Duration;
import com.oracle.bedrock.util.ExponentialIterator;
import com.oracle.bedrock.util.FibonacciIterator;
import com.oracle.bedrock.util.MappingIterator;
import com.oracle.bedrock.util.PerpetualIterator;
import com.oracle.bedrock.util.RandomIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

public class RetryFrequency
implements Option {
    private Iterable<Duration> durations;

    private RetryFrequency(Iterable<Duration> durations) {
        this.durations = durations;
    }

    public Iterable<Duration> get() {
        return this.durations;
    }

    public RetryFrequency randomized() {
        return new RetryFrequency(() -> new MappingIterator<Long, Duration>(new RandomIterator(new MappingIterator<Duration, Long>(this.get().iterator(), duration -> duration.to(TimeUnit.MILLISECONDS))), duration -> Duration.of(duration, TimeUnit.MILLISECONDS)));
    }

    @OptionsByType.Default
    public static RetryFrequency standard() {
        return RetryFrequency.every(250L, TimeUnit.MILLISECONDS);
    }

    public static RetryFrequency of(Iterable<Duration> durations) {
        return new RetryFrequency(durations);
    }

    public static RetryFrequency of(TimeUnit unit, long ... instants) {
        ArrayList<Long> frequencies = new ArrayList<Long>();
        if (instants.length > 0) {
            Arrays.sort(instants);
            frequencies.add(instants[0]);
            long sum = instants[0];
            for (int i = 1; i < instants.length; ++i) {
                long delta = instants[i] - sum;
                sum += delta;
                frequencies.add(delta);
            }
            return new RetryFrequency(() -> new MappingIterator<Long, Duration>(frequencies.iterator(), duration -> Duration.of(duration, TimeUnit.MILLISECONDS)));
        }
        throw new IllegalArgumentException("Failed to specify any times for the RetryFrequency");
    }

    public static RetryFrequency every(long duration, TimeUnit unit) {
        return new RetryFrequency(() -> new PerpetualIterator<Duration>(Duration.of(duration, unit)));
    }

    public static RetryFrequency fibonacci() {
        return new RetryFrequency(() -> new MappingIterator<Long, Duration>(new FibonacciIterator(), duration -> Duration.of(duration, TimeUnit.MILLISECONDS)));
    }

    public static RetryFrequency exponential() {
        return RetryFrequency.exponential(0.0, 50.0);
    }

    public static RetryFrequency exponential(double initial, double percentage) {
        return new RetryFrequency(() -> new MappingIterator<Long, Duration>(new ExponentialIterator(initial, percentage), duration -> Duration.of(duration, TimeUnit.MILLISECONDS)));
    }
}

