/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred.jmx;

import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.deferred.UnavailableException;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class DeferredMBeanAttribute<T>
implements Deferred<T> {
    private Deferred<JMXConnector> deferredJMXConnector;
    private ObjectName objectName;
    private String attributeName;
    private Class<T> attributeClass;

    public DeferredMBeanAttribute(Deferred<JMXConnector> deferredJMXConnector, ObjectName objectName, String attributeName, Class<T> attributeClass) {
        this.deferredJMXConnector = deferredJMXConnector;
        this.objectName = objectName;
        this.attributeName = attributeName;
        this.attributeClass = attributeClass;
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            JMXConnector connector = this.deferredJMXConnector.get();
            if (connector == null) {
                throw new TemporarilyUnavailableException(this);
            }
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            Object attribute = connection.getAttribute(this.objectName, this.attributeName);
            return this.attributeClass.cast(attribute);
        }
        catch (IOException e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
        catch (Exception e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.attributeClass;
    }

    public String toString() {
        return String.format("Deferred<MBeanAttribute>{on=%s, object=%s, attribute=%s, class=%s}", this.deferredJMXConnector, this.objectName, this.attributeName, this.attributeClass);
    }
}

