/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.DeferredHelper;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.deferred.options.InitialDelay;
import com.oracle.bedrock.deferred.options.MaximumRetryDelay;
import com.oracle.bedrock.deferred.options.RetryFrequency;
import com.oracle.bedrock.options.Timeout;
import com.oracle.bedrock.util.Duration;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class Ensured<T>
implements Deferred<T> {
    private Deferred<T> deferred;
    private long initialDelayDurationMS;
    private long maximumPollingDurationMS;
    private long maximumRetryDurationMS;
    private Iterator<Duration> retryDurations;

    public Ensured(Deferred<T> deferred, Option ... options) {
        this.deferred = deferred instanceof Ensured ? ((Ensured)deferred).getDeferred() : deferred;
        OptionsByType optionsByType = OptionsByType.of(options);
        this.initialDelayDurationMS = optionsByType.getOrDefault(InitialDelay.class, InitialDelay.none()).to(TimeUnit.MILLISECONDS);
        this.maximumRetryDurationMS = optionsByType.getOrDefault(Timeout.class, Timeout.after(DeferredHelper.getDefaultEnsuredMaximumRetryDuration())).to(TimeUnit.MILLISECONDS);
        this.maximumPollingDurationMS = optionsByType.getOrDefault(MaximumRetryDelay.class, MaximumRetryDelay.of(DeferredHelper.getDefaultEnsuredMaximumPollingDuration())).to(TimeUnit.MILLISECONDS);
        this.retryDurations = optionsByType.getOrDefault(RetryFrequency.class, RetryFrequency.of(DeferredHelper.getDefaultEnsuredRetryDurationsIterable())).get().iterator();
    }

    public Deferred<T> getDeferred() {
        return this.deferred;
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        long remainingRetryDurationMS = this.maximumRetryDurationMS;
        if (this.initialDelayDurationMS > 0L) {
            try {
                Thread.sleep(this.initialDelayDurationMS);
            }
            catch (InterruptedException e) {
                throw new PermanentlyUnavailableException(this.deferred, (Throwable)e);
            }
            remainingRetryDurationMS -= this.initialDelayDurationMS;
        }
        do {
            long acquisitionDurationMS = 0L;
            long started = System.currentTimeMillis();
            try {
                return this.deferred.get();
            }
            catch (PermanentlyUnavailableException e) {
                throw e;
            }
            catch (UnsupportedOperationException e) {
                throw new PermanentlyUnavailableException(this, (Throwable)e);
            }
            catch (TemporarilyUnavailableException e) {
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            long stopped = System.currentTimeMillis();
            acquisitionDurationMS = stopped - started;
            if (this.maximumRetryDurationMS >= 0L && (remainingRetryDurationMS -= acquisitionDurationMS < 0L ? 0L : acquisitionDurationMS) <= 0L) continue;
            if (this.retryDurations.hasNext()) {
                try {
                    Duration duration = this.retryDurations.next();
                    long durationMS = duration.to(TimeUnit.MILLISECONDS);
                    if (durationMS > this.maximumPollingDurationMS) {
                        durationMS = this.maximumPollingDurationMS;
                    }
                    if (remainingRetryDurationMS - durationMS < 0L) {
                        durationMS = remainingRetryDurationMS;
                    }
                    if (durationMS > 0L) {
                        TimeUnit.MILLISECONDS.sleep(durationMS);
                    }
                    remainingRetryDurationMS -= durationMS;
                }
                catch (InterruptedException e) {
                    throw new PermanentlyUnavailableException(this.deferred, (Throwable)e);
                }
            } else {
                throw new PermanentlyUnavailableException(this.deferred);
            }
        } while (this.maximumRetryDurationMS < 0L || remainingRetryDurationMS > 0L);
        throw new PermanentlyUnavailableException(this.deferred);
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.deferred.getDeferredClass();
    }

    public String toString() {
        return String.format("Ensured{%s}", this.getDeferredClass(), this.getDeferred());
    }
}

