/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.Existing;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.deferred.UnavailableException;
import java.util.function.Predicate;

public class DeferredPredicate<T>
implements Deferred<Boolean> {
    private Predicate<? super T> predicate;
    private Deferred<T> deferred;
    private T lastMatchedValue;

    public DeferredPredicate(Deferred<T> deferred, Predicate<? super T> predicate) {
        this.deferred = deferred;
        this.predicate = predicate;
        this.lastMatchedValue = null;
    }

    public DeferredPredicate(T value, Predicate<? super T> predicate) {
        this.deferred = value instanceof Deferred ? (Deferred)value : new Existing<T>(value);
        this.predicate = predicate;
        this.lastMatchedValue = null;
    }

    public Deferred<T> getDeferred() {
        return this.deferred;
    }

    public Predicate<? super T> getPredicate() {
        return this.predicate;
    }

    public T getLastUsedMatchValue() {
        return this.lastMatchedValue;
    }

    @Override
    public Boolean get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            this.lastMatchedValue = this.deferred.get();
            if (this.predicate.test(this.lastMatchedValue)) {
                return true;
            }
            throw new TemporarilyUnavailableException(this);
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PermanentlyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<Boolean> getDeferredClass() {
        return Boolean.class;
    }

    public String toString() {
        return String.format("DeferredPredicate{deferred=%s, predicate=%s, lastUsedMatchValue=%s}", this.deferred, this.predicate, this.lastMatchedValue);
    }
}

