/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.deferred;

import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import java.util.concurrent.Callable;

public class DeferredCallable<T>
implements Deferred<T> {
    private Callable<T> callable;
    private Class<T> deferredClass;

    public DeferredCallable(Callable<T> callable, Class<T> deferredClass) {
        this.callable = callable;
        this.deferredClass = deferredClass;
    }

    @Override
    public T get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            return this.callable.call();
        }
        catch (TemporarilyUnavailableException e) {
            throw e;
        }
        catch (PermanentlyUnavailableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemporarilyUnavailableException(this, (Throwable)e);
        }
    }

    @Override
    public Class<T> getDeferredClass() {
        return this.deferredClass;
    }
}

