/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock;

import com.oracle.bedrock.ComposableOption;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Optional;

@Internal
class Options
implements OptionsByType {
    private final LinkedHashMap<Class<? extends Option>, Option> options = new LinkedHashMap();

    Options(Option ... options) {
        if (options != null) {
            for (Option option : options) {
                this.add(option);
            }
        }
    }

    Options(OptionsByType optionsByType) {
        this.addAll(optionsByType);
    }

    @Override
    public <T extends Option> T get(Class<T> classOfOption, Object ... arguments) {
        if (classOfOption == null) {
            return null;
        }
        Option option = this.options.get(classOfOption);
        if (option == null) {
            option = this.getDefaultFor(classOfOption, arguments);
            this.add(option);
        }
        return (T)option;
    }

    @Override
    public <T extends Option> Optional<T> optionally(Class<T> classOfOption, Object ... arguments) {
        return Optional.ofNullable(this.get(classOfOption, arguments));
    }

    @Override
    public <T extends Option, D extends T> T getOrDefault(Class<T> classOfOption, D defaultOption) {
        if (classOfOption == null) {
            return null;
        }
        Option option = this.options.get(classOfOption);
        if (option == null) {
            option = defaultOption;
        }
        return (T)option;
    }

    @Override
    public <T extends Option, D extends T> T getOrSetDefault(Class<T> classOfOption, D defaultOption) {
        if (classOfOption == null) {
            return null;
        }
        Option option = this.options.get(classOfOption);
        if (option == null && defaultOption != null) {
            option = defaultOption;
            this.add(option);
        }
        return (T)option;
    }

    @Override
    public boolean contains(Class<? extends Option> classOfOption) {
        return this.get(classOfOption, new Object[0]) != null;
    }

    @Override
    public boolean contains(Option option) {
        Class<?> classOfOption = option.getClass();
        return this.get(classOfOption, new Object[0]).equals(option);
    }

    @Override
    public <O> Iterable<O> getInstancesOf(Class<O> requiredClass) {
        ArrayList<Option> result = new ArrayList<Option>();
        for (Option option : this.options.values()) {
            if (requiredClass.isInstance(option)) {
                result.add(option);
            }
            if (!(option instanceof Option.Collector)) continue;
            for (O o : ((Option.Collector)option).getInstancesOf(requiredClass)) {
                result.add((Option)o);
            }
        }
        return result;
    }

    @Override
    public Option[] asArray() {
        Option[] aOptions = new Option[this.options.size()];
        int i = 0;
        for (Option option : this.options.values()) {
            aOptions[i++] = option;
        }
        return aOptions;
    }

    public String toString() {
        StringBuilder bldrResult = new StringBuilder();
        bldrResult.append("Options{");
        boolean fFirst = true;
        for (Option option : this.options.values()) {
            if (fFirst) {
                fFirst = false;
            } else {
                bldrResult.append(", ");
            }
            bldrResult.append(option);
        }
        bldrResult.append("}");
        return bldrResult.toString();
    }

    @Override
    public OptionsByType add(Option option) {
        if (option != null) {
            if (option instanceof Option.Collectable) {
                Option.Collectable collectable = (Option.Collectable)option;
                Class<? extends Option> classOfCollector = OptionsByType.getClassOf(collectable.getCollectorClass());
                Option.Collector collector = (Option.Collector)this.options.get(classOfCollector);
                if (collector == null) {
                    collector = (Option.Collector)this.getDefaultFor(classOfCollector, new Object[0]);
                }
                if (collector == null) {
                    throw new IllegalStateException("Failed to instantiate a default Collector of type " + String.valueOf(classOfCollector) + " for " + String.valueOf(option));
                }
                collector = collector.with(collectable);
                this.options.put(classOfCollector, collector);
            } else {
                Option existing;
                Class<? extends Option> classOfOption = OptionsByType.getClassOf(option);
                if (option instanceof ComposableOption && (existing = this.options.get(classOfOption)) != null) {
                    option = ((ComposableOption)existing).compose((ComposableOption)option);
                }
                this.options.put(classOfOption, option);
            }
        }
        return this;
    }

    @Override
    public OptionsByType addIfAbsent(Option option) {
        Class<? extends Option> classOfOption = OptionsByType.getClassOf(option);
        if (!this.options.containsKey(classOfOption)) {
            this.add(option);
        }
        return this;
    }

    @Override
    public OptionsByType addAll(Option ... options) {
        if (options != null) {
            for (Option option : options) {
                this.add(option);
            }
        }
        return this;
    }

    @Override
    public OptionsByType addAll(OptionsByType options) {
        for (Option option : options.asArray()) {
            this.add(option);
        }
        return this;
    }

    @Override
    public <T extends Option> boolean remove(Class<T> classOfOption) {
        if (classOfOption == null) {
            return false;
        }
        Option option = (Option)this.options.remove(OptionsByType.getClassOf(classOfOption));
        return option != null;
    }

    @Override
    public boolean remove(Option option) {
        if (option == null) {
            return false;
        }
        if (option instanceof Option.Collectable) {
            Option.Collectable collectable = (Option.Collectable)option;
            Class<? extends Option> classOfCollector = OptionsByType.getClassOf(collectable.getCollectorClass());
            Option.Collector collector = (Option.Collector)this.options.get(classOfCollector);
            if (collector == null) {
                return false;
            }
            collector = collector.without(collectable);
            this.options.put(classOfCollector, collector);
            return true;
        }
        Class<? extends Option> classOfOption = OptionsByType.getClassOf(option);
        Option existingOption = this.get(classOfOption, new Object[0]);
        if (existingOption == null || !existingOption.equals(option)) {
            return false;
        }
        this.options.remove(classOfOption);
        return true;
    }

    protected <T extends Option> T getDefaultFor(Class<T> classOfOption, Object ... arguments) {
        int modifiers;
        if (classOfOption == null) {
            return null;
        }
        for (Method method : classOfOption.getMethods()) {
            modifiers = method.getModifiers();
            if (method.getAnnotation(OptionsByType.Default.class) == null || method.getParameterTypes().length != arguments.length || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !classOfOption.isAssignableFrom(method.getReturnType())) continue;
            try {
                return (T)((Option)method.invoke(null, arguments));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : classOfOption.getFields()) {
            modifiers = ((Field)accessibleObject).getModifiers();
            if (((Field)accessibleObject).getAnnotation(OptionsByType.Default.class) == null || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !classOfOption.isAssignableFrom(((Field)accessibleObject).getType())) continue;
            try {
                return (T)((Option)((Field)accessibleObject).get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : classOfOption.getConstructors()) {
            modifiers = ((Constructor)accessibleObject).getModifiers();
            if (((Constructor)accessibleObject).getAnnotation(OptionsByType.Default.class) == null || !Modifier.isPublic(modifiers) || ((Constructor)accessibleObject).getParameterTypes().length != arguments.length) continue;
            try {
                return (T)((Option)((Constructor)accessibleObject).newInstance(arguments));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

