/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.utils.ConfigurationUtils;
import java.time.Instant;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static String createAuthorizationHeader(Object object, String key, String prefix) {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("payload", object);
        Map payloadMap = (Map)objectMapper.convertValue(data, new TypeReference<Map<String, ?>>(){});
        String headerToken = SecurityUtils.createToken(payloadMap, key);
        return prefix + headerToken;
    }

    public static String createToken(Object object, String key) {
        ObjectMapper objectMapper = new ObjectMapper();
        Map payloadMap = (Map)objectMapper.convertValue(object, new TypeReference<Map<String, ?>>(){});
        return SecurityUtils.createToken(payloadMap, key);
    }

    public static String createToken(Map<String, ?> payloadMap, String key) {
        Algorithm algorithm = Algorithm.HMAC256((String)key);
        Calendar calendar = Calendar.getInstance();
        Instant issuedAt = calendar.toInstant();
        calendar.add(12, ConfigurationUtils.getDocsIntegrationSdkProperties().getDocumentServer().getSecurity().getTokenValidityInMinutes());
        Instant expiresAt = calendar.toInstant();
        return JWT.create().withIssuedAt(issuedAt).withExpiresAt(expiresAt).withPayload(payloadMap).sign(algorithm);
    }

    public static String verifyToken(String token, String key) {
        Algorithm algorithm = Algorithm.HMAC256((String)key);
        Base64.Decoder decoder = Base64.getUrlDecoder();
        DecodedJWT jwt = JWT.require((Algorithm)algorithm).acceptLeeway(ConfigurationUtils.getDocsIntegrationSdkProperties().getDocumentServer().getSecurity().getLeeway().longValue()).build().verify(token);
        return new String(decoder.decode(jwt.getPayload()));
    }
}

